/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.shaded.asm;

import com.nimbusds.jose.shaded.asm.ASMUtil;
import com.nimbusds.jose.shaded.asm.Accessor;
import com.nimbusds.jose.shaded.asm.BeansAccessBuilder;
import com.nimbusds.jose.shaded.asm.BeansAccessConfig;
import com.nimbusds.jose.shaded.asm.DynamicClassLoader;
import com.nimbusds.jose.shaded.asm.FieldFilter;
import com.nimbusds.jose.shaded.asm.ex.NoSuchFieldException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class BeansAccess<T> {
    private HashMap<String, Accessor> map;
    private Accessor[] accs;
    private static ConcurrentHashMap<Class<?>, BeansAccess<?>> cache = new ConcurrentHashMap();

    protected void setAccessor(Accessor[] accs) {
        int i2 = 0;
        this.accs = accs;
        this.map = new HashMap();
        for (Accessor acc : accs) {
            acc.index = i2++;
            this.map.put(acc.getName(), acc);
        }
    }

    public HashMap<String, Accessor> getMap() {
        return this.map;
    }

    public Accessor[] getAccessors() {
        return this.accs;
    }

    public static <P> BeansAccess<P> get(Class<P> type) {
        return BeansAccess.get(type, null);
    }

    public static <P> BeansAccess<P> get(Class<P> type, FieldFilter filter) {
        BeansAccess<?> access = cache.get(type);
        if (access != null) {
            return access;
        }
        Accessor[] accs = ASMUtil.getAccessors(type, filter);
        String className = type.getName();
        String accessClassName = className.startsWith("java.util.") ? "com.nimbusds.jose.shaded.asm." + className + "AccAccess" : className.concat("AccAccess");
        DynamicClassLoader loader = new DynamicClassLoader(type.getClassLoader());
        Class<?> accessClass = null;
        try {
            accessClass = loader.loadClass(accessClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        LinkedList<Class<P>> parentClasses = BeansAccess.getParents(type);
        if (accessClass == null) {
            BeansAccessBuilder builder = new BeansAccessBuilder(type, accs, loader);
            for (Class clazz : parentClasses) {
                builder.addConversion((Iterable)BeansAccessConfig.classMapper.get(clazz));
            }
            accessClass = builder.bulid();
        }
        try {
            BeansAccess access2 = (BeansAccess)accessClass.newInstance();
            access2.setAccessor(accs);
            cache.putIfAbsent(type, access2);
            for (Class clazz : parentClasses) {
                BeansAccess.addAlias(access2, BeansAccessConfig.classFiledNameMapper.get(clazz));
            }
            return access2;
        }
        catch (Exception ex) {
            throw new RuntimeException("Error constructing accessor class: " + accessClassName, ex);
        }
    }

    private static LinkedList<Class<?>> getParents(Class<?> type) {
        LinkedList m4 = new LinkedList();
        while (type != null && !type.equals(Object.class)) {
            m4.addLast(type);
            for (Class<?> c2 : type.getInterfaces()) {
                m4.addLast(c2);
            }
            type = type.getSuperclass();
        }
        m4.addLast(Object.class);
        return m4;
    }

    private static void addAlias(BeansAccess<?> access, HashMap<String, String> m4) {
        if (m4 == null) {
            return;
        }
        HashMap<String, Accessor> changes = new HashMap<String, Accessor>();
        for (Map.Entry<String, String> e2 : m4.entrySet()) {
            Accessor a1 = access.map.get(e2.getValue());
            if (a1 == null) continue;
            changes.put(e2.getValue(), a1);
        }
        access.map.putAll(changes);
    }

    public abstract void set(T var1, int var2, Object var3);

    public abstract Object get(T var1, int var2);

    public abstract T newInstance();

    public void set(T object, String methodName, Object value) {
        int i2 = this.getIndex(methodName);
        if (i2 == -1) {
            throw new NoSuchFieldException(methodName + " in " + object.getClass() + " to put value : " + value);
        }
        this.set(object, i2, value);
    }

    public Object get(T object, String methodName) {
        return this.get(object, this.getIndex(methodName));
    }

    public int getIndex(String name) {
        Accessor ac = this.map.get(name);
        if (ac == null) {
            return -1;
        }
        return ac.index;
    }
}

