/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import ai.h2o.com.google.common.collect.ImmutableMap;
import com.google.auth.oauth2.AutoValue_JwtClaims;
import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.Map;
import javax.annotation.Nullable;

@AutoValue
public abstract class JwtClaims
implements Serializable {
    private static final long serialVersionUID = 4974444151019426702L;

    @Nullable
    abstract String getAudience();

    @Nullable
    abstract String getIssuer();

    @Nullable
    abstract String getSubject();

    abstract Map<String, String> getAdditionalClaims();

    public static Builder newBuilder() {
        return new AutoValue_JwtClaims.Builder().setAdditionalClaims(ImmutableMap.of());
    }

    public JwtClaims merge(JwtClaims other) {
        ImmutableMap.Builder<String, String> newClaimsBuilder = ImmutableMap.builder();
        newClaimsBuilder.putAll(this.getAdditionalClaims());
        newClaimsBuilder.putAll(other.getAdditionalClaims());
        return JwtClaims.newBuilder().setAudience(other.getAudience() == null ? this.getAudience() : other.getAudience()).setIssuer(other.getIssuer() == null ? this.getIssuer() : other.getIssuer()).setSubject(other.getSubject() == null ? this.getSubject() : other.getSubject()).setAdditionalClaims(newClaimsBuilder.build()).build();
    }

    public boolean isComplete() {
        boolean hasScopes = this.getAdditionalClaims().containsKey("scope") && !this.getAdditionalClaims().get("scope").isEmpty();
        return (this.getAudience() != null || hasScopes) && this.getIssuer() != null && this.getSubject() != null;
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setAudience(String var1);

        public abstract Builder setIssuer(String var1);

        public abstract Builder setSubject(String var1);

        public abstract Builder setAdditionalClaims(Map<String, String> var1);

        public abstract JwtClaims build();
    }
}

