/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.tracing;

import ai.h2o.com.google.common.base.Preconditions;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiStreamObserver;
import com.google.api.gax.rpc.ClientStreamingCallable;
import com.google.api.gax.tracing.ApiTracer;
import com.google.api.gax.tracing.ApiTracerFactory;
import com.google.api.gax.tracing.SpanName;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;

@BetaApi(value="The surface for tracing is not stable and might change in the future")
@InternalApi
public class TracedClientStreamingCallable<RequestT, ResponseT>
extends ClientStreamingCallable<RequestT, ResponseT> {
    private final ClientStreamingCallable<RequestT, ResponseT> innerCallable;
    private final ApiTracerFactory tracerFactory;
    private final SpanName spanName;

    public TracedClientStreamingCallable(@Nonnull ClientStreamingCallable<RequestT, ResponseT> innerCallable, @Nonnull ApiTracerFactory tracerFactory, @Nonnull SpanName spanName) {
        this.tracerFactory = Preconditions.checkNotNull(tracerFactory, "tracerFactory can't be null");
        this.spanName = Preconditions.checkNotNull(spanName, "spanName can't be null");
        this.innerCallable = Preconditions.checkNotNull(innerCallable, "innerCallable can't be null");
    }

    @Override
    public ApiStreamObserver<RequestT> clientStreamingCall(ApiStreamObserver<ResponseT> responseObserver, ApiCallContext context) {
        ApiTracer tracer = this.tracerFactory.newTracer(context.getTracer(), this.spanName, ApiTracerFactory.OperationType.ClientStreaming);
        context = context.withTracer(tracer);
        AtomicReference<Object> cancellationCauseHolder = new AtomicReference<Object>(null);
        try {
            TracedResponseObserver<ResponseT> innerResponseObserver = new TracedResponseObserver<ResponseT>(tracer, responseObserver, cancellationCauseHolder);
            ApiStreamObserver<RequestT> innerRequestObserver = this.innerCallable.clientStreamingCall(innerResponseObserver, context);
            return new TracedRequestObserver<RequestT>(tracer, innerRequestObserver, cancellationCauseHolder);
        }
        catch (RuntimeException e2) {
            tracer.operationFailed(e2);
            throw e2;
        }
    }

    private static class TracedResponseObserver<RequestT>
    implements ApiStreamObserver<RequestT> {
        @Nonnull
        private final ApiTracer tracer;
        @Nonnull
        private final ApiStreamObserver<RequestT> innerObserver;
        @Nonnull
        private final AtomicReference<Throwable> cancellationCauseHolder;

        TracedResponseObserver(@Nonnull ApiTracer tracer, @Nonnull ApiStreamObserver<RequestT> innerObserver, @Nonnull AtomicReference<Throwable> cancellationCauseHolder) {
            this.tracer = Preconditions.checkNotNull(tracer, "tracer can't be null");
            this.innerObserver = Preconditions.checkNotNull(innerObserver, "innerObserver can't be null");
            this.cancellationCauseHolder = cancellationCauseHolder;
        }

        @Override
        public void onNext(RequestT value) {
            this.tracer.responseReceived();
            this.innerObserver.onNext(value);
        }

        @Override
        public void onError(Throwable t2) {
            Throwable cancellationCause = this.cancellationCauseHolder.get();
            if (cancellationCause != null) {
                this.tracer.operationCancelled();
            } else {
                this.tracer.operationFailed(t2);
            }
            this.innerObserver.onError(t2);
        }

        @Override
        public void onCompleted() {
            this.tracer.operationSucceeded();
            this.innerObserver.onCompleted();
        }
    }

    private static class TracedRequestObserver<RequestT>
    implements ApiStreamObserver<RequestT> {
        private final ApiTracer tracer;
        private final ApiStreamObserver<RequestT> innerObserver;
        private final AtomicReference<Throwable> cancellationCauseHolder;

        TracedRequestObserver(@Nonnull ApiTracer tracer, @Nonnull ApiStreamObserver<RequestT> innerObserver, @Nonnull AtomicReference<Throwable> cancellationCauseHolder) {
            this.tracer = Preconditions.checkNotNull(tracer, "tracer can't be null");
            this.innerObserver = Preconditions.checkNotNull(innerObserver, "innerObserver can't be null");
            this.cancellationCauseHolder = Preconditions.checkNotNull(cancellationCauseHolder, "cancellationCauseHolder can't be null");
        }

        @Override
        public void onNext(RequestT value) {
            this.tracer.requestSent();
            this.innerObserver.onNext(value);
        }

        @Override
        public void onError(Throwable throwable) {
            if (throwable == null) {
                throwable = new CancellationException("Cancelled without a cause");
            }
            this.cancellationCauseHolder.compareAndSet(null, throwable);
            this.innerObserver.onError(throwable);
        }

        @Override
        public void onCompleted() {
            this.innerObserver.onCompleted();
        }
    }
}

