/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import ai.h2o.com.google.common.base.Preconditions;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallOptions;
import com.google.api.gax.httpjson.HttpJsonChannel;
import com.google.api.gax.httpjson.HttpJsonClientCall;
import com.google.api.gax.httpjson.HttpJsonClientCallImpl;
import com.google.api.gax.httpjson.HttpJsonClientCalls;
import com.google.api.gax.httpjson.HttpJsonMetadata;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

@BetaApi
public class ManagedHttpJsonChannel
implements HttpJsonChannel,
BackgroundResource {
    private static final ExecutorService DEFAULT_EXECUTOR = InstantiatingExecutorProvider.newBuilder().build().getExecutor();
    private final Executor executor;
    private final String endpoint;
    private final HttpJsonMetadata defaultHeaders;
    private final HttpTransport httpTransport;
    private boolean isTransportShutdown;

    private ManagedHttpJsonChannel(Executor executor, String endpoint, @Nullable HttpTransport httpTransport, HttpJsonMetadata defaultHeaders) {
        this.executor = executor;
        this.endpoint = endpoint;
        this.httpTransport = httpTransport == null ? new NetHttpTransport() : httpTransport;
        this.defaultHeaders = defaultHeaders;
    }

    @Override
    public <RequestT, ResponseT> HttpJsonClientCall<RequestT, ResponseT> newCall(ApiMethodDescriptor<RequestT, ResponseT> methodDescriptor, HttpJsonCallOptions callOptions) {
        return new HttpJsonClientCallImpl<RequestT, ResponseT>(methodDescriptor, this.endpoint, callOptions, this.httpTransport, this.executor, this.defaultHeaders);
    }

    @Override
    @Deprecated
    public <ResponseT, RequestT> ApiFuture<ResponseT> issueFutureUnaryCall(HttpJsonCallOptions callOptions, RequestT request, ApiMethodDescriptor<RequestT, ResponseT> methodDescriptor) {
        return HttpJsonClientCalls.eagerFutureUnaryCall(this.newCall(methodDescriptor, callOptions), request);
    }

    @Override
    public synchronized void shutdown() {
        if (this.isTransportShutdown) {
            return;
        }
        try {
            this.httpTransport.shutdown();
            this.isTransportShutdown = true;
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public boolean isShutdown() {
        return this.isTransportShutdown;
    }

    @Override
    public boolean isTerminated() {
        return this.isTransportShutdown;
    }

    @Override
    public void shutdownNow() {
        this.shutdown();
    }

    @Override
    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return false;
    }

    @Override
    public void close() {
    }

    public static Builder newBuilder() {
        return new Builder().setDefaultHeaders(HttpJsonMetadata.newBuilder().build()).setExecutor(DEFAULT_EXECUTOR);
    }

    public static class Builder {
        private Executor executor;
        private String endpoint;
        private HttpJsonMetadata defaultHeaders;
        private HttpTransport httpTransport;

        private Builder() {
        }

        public Builder setExecutor(Executor executor) {
            this.executor = executor == null ? DEFAULT_EXECUTOR : executor;
            return this;
        }

        public Builder setEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder setDefaultHeaders(HttpJsonMetadata defaultHeaders) {
            this.defaultHeaders = defaultHeaders;
            return this;
        }

        public Builder setHttpTransport(HttpTransport httpTransport) {
            this.httpTransport = httpTransport;
            return this;
        }

        public ManagedHttpJsonChannel build() {
            Preconditions.checkNotNull(this.endpoint);
            return new ManagedHttpJsonChannel(this.executor, this.endpoint, this.httpTransport, this.defaultHeaders);
        }
    }
}

