/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.core;

import com.google.api.gax.core.AutoValue_InstantiatingExecutorProvider;
import com.google.api.gax.core.ExecutorProvider;
import com.google.auto.value.AutoValue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

@AutoValue
public abstract class InstantiatingExecutorProvider
implements ExecutorProvider {
    private static final ThreadFactory DEFAULT_THREAD_FACTORY = new ThreadFactory(){
        private final AtomicInteger threadCount = new AtomicInteger();

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread2 = new Thread(runnable);
            thread2.setName("Gax-" + this.threadCount.incrementAndGet());
            thread2.setDaemon(true);
            return thread2;
        }
    };

    InstantiatingExecutorProvider() {
    }

    @Override
    public ScheduledExecutorService getExecutor() {
        return new ScheduledThreadPoolExecutor(this.getExecutorThreadCount(), this.getThreadFactory());
    }

    @Override
    public boolean shouldAutoClose() {
        return true;
    }

    public abstract int getExecutorThreadCount();

    public abstract ThreadFactory getThreadFactory();

    public abstract Builder toBuilder();

    public static Builder newBuilder() {
        int numCpus = Runtime.getRuntime().availableProcessors();
        int numThreads = Math.max(4, numCpus);
        return new AutoValue_InstantiatingExecutorProvider.Builder().setExecutorThreadCount(numThreads).setThreadFactory(DEFAULT_THREAD_FACTORY);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setExecutorThreadCount(int var1);

        public abstract int getExecutorThreadCount();

        public abstract Builder setThreadFactory(ThreadFactory var1);

        public abstract ThreadFactory getThreadFactory();

        public abstract InstantiatingExecutorProvider build();
    }
}

