/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.targetencoding.interaction;

import water.Iced;
import water.util.ArrayUtils;

class InteractionsEncoder
extends Iced {
    static final String UNSEEN = "_UNSEEN_";
    static final String NA = "_NA_";
    private boolean _encodeUnseenAsNA;
    private String[][] _interactingDomains;
    private long[] _encodingFactors;

    InteractionsEncoder(String[][] interactingDomains, boolean encodeUnseenAsNA) {
        this._encodeUnseenAsNA = encodeUnseenAsNA;
        this._interactingDomains = interactingDomains;
        this._encodingFactors = this.createEncodingFactors();
    }

    long encode(int[] interactingValues) {
        long value = 0L;
        for (int i2 = 0; i2 < interactingValues.length; ++i2) {
            int domainCard = this._interactingDomains[i2].length;
            long interactionFactor = this._encodingFactors[i2];
            int ival = interactingValues[i2];
            if (ival >= domainCard) {
                ival = domainCard;
            }
            if (ival < 0) {
                ival = this._encodeUnseenAsNA ? domainCard : domainCard + 1;
            }
            value += (long)ival * interactionFactor;
        }
        return value;
    }

    long encodeStr(String[] interactingValues) {
        int[] values = new int[interactingValues.length];
        for (int i2 = 0; i2 < interactingValues.length; ++i2) {
            String[] domain = this._interactingDomains[i2];
            String val = interactingValues[i2];
            int ival = val == null ? -1 : ArrayUtils.find(domain, val);
            values[i2] = ival < 0 && val != null ? domain.length : ival;
        }
        return this.encode(values);
    }

    int[] decode(long interactionValue) {
        int[] values = new int[this._encodingFactors.length];
        long value = interactionValue;
        for (int i2 = this._encodingFactors.length - 1; i2 >= 0; --i2) {
            long factor = this._encodingFactors[i2];
            values[i2] = (int)(value / factor);
            value %= factor;
        }
        return values;
    }

    String[] decodeStr(long interactionValue) {
        int[] values = this.decode(interactionValue);
        String[] catValues = new String[values.length];
        for (int i2 = 0; i2 < values.length; ++i2) {
            int val = values[i2];
            String[] domain = this._interactingDomains[i2];
            catValues[i2] = val < domain.length ? domain[val] : (i2 == domain.length ? (this._encodeUnseenAsNA ? null : UNSEEN) : null);
        }
        return catValues;
    }

    private long[] createEncodingFactors() {
        long[] factors = new long[this._interactingDomains.length];
        long multiplier = 1L;
        for (int i2 = 0; i2 < this._interactingDomains.length; ++i2) {
            int domainCard = this._interactingDomains[i2].length;
            int interactionFactor = this._encodeUnseenAsNA ? domainCard + 1 : domainCard + 2;
            factors[i2] = multiplier;
            multiplier *= (long)interactionFactor;
        }
        return factors;
    }
}

