/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.ml.models;

import ai.h2o.sparkling.H2OConf;
import ai.h2o.sparkling.H2OContext$;
import ai.h2o.sparkling.backend.BuildInfo$;
import ai.h2o.sparkling.backend.NodeDesc;
import ai.h2o.sparkling.backend.utils.RestApiUtils$;
import ai.h2o.sparkling.backend.utils.RestCommunication;
import ai.h2o.sparkling.backend.utils.RestCommunication$LoggingLevel$;
import ai.h2o.sparkling.backend.utils.RestEncodingUtils;
import ai.h2o.sparkling.ml.models.H2OBinaryModel;
import ai.h2o.sparkling.utils.ScalaUtils$;
import ai.h2o.sparkling.utils.SparkSessionUtils$;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.DataInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URI;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import water.AutoBuffer;
import water.api.schemas3.ModelSchemaBaseV3;
import water.api.schemas3.ModelsV3;

public final class H2OBinaryModel$
implements RestCommunication {
    public static H2OBinaryModel$ MODULE$;
    private volatile RestCommunication$LoggingLevel$ LoggingLevel$module;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new H2OBinaryModel$();
    }

    @Override
    public <ResultType> ResultType query(URI endpoint, String suffix, H2OConf conf, Map<String, Object> params, Seq<Tuple2<Class<?>, String>> skippedFields, Enumeration.Value confirmationLoggingLevel, ClassTag<ResultType> evidence$1) {
        return (ResultType)RestCommunication.query$(this, endpoint, suffix, conf, params, skippedFields, confirmationLoggingLevel, evidence$1);
    }

    @Override
    public <ResultType> Map<String, Object> query$default$4() {
        return RestCommunication.query$default$4$(this);
    }

    @Override
    public <ResultType> Seq<Tuple2<Class<?>, String>> query$default$5() {
        return RestCommunication.query$default$5$(this);
    }

    @Override
    public <ResultType> Enumeration.Value query$default$6() {
        return RestCommunication.query$default$6$(this);
    }

    @Override
    public <ResultType> ResultType update(URI endpoint, String suffix, H2OConf conf, Map<String, Object> params, Seq<Tuple2<Class<?>, String>> skippedFields, boolean encodeParamsAsJson, ClassTag<ResultType> evidence$2) {
        return (ResultType)RestCommunication.update$(this, endpoint, suffix, conf, params, skippedFields, encodeParamsAsJson, evidence$2);
    }

    @Override
    public <ResultType> Map<String, Object> update$default$4() {
        return RestCommunication.update$default$4$(this);
    }

    @Override
    public <ResultType> Seq<Tuple2<Class<?>, String>> update$default$5() {
        return RestCommunication.update$default$5$(this);
    }

    @Override
    public <ResultType> boolean update$default$6() {
        return RestCommunication.update$default$6$(this);
    }

    @Override
    public <ResultType> ResultType delete(URI endpoint, String suffix, H2OConf conf, Map<String, Object> params, Seq<Tuple2<Class<?>, String>> skippedFields, boolean encodeParamsAsJson, ClassTag<ResultType> evidence$3) {
        return (ResultType)RestCommunication.delete$(this, endpoint, suffix, conf, params, skippedFields, encodeParamsAsJson, evidence$3);
    }

    @Override
    public <ResultType> Map<String, Object> delete$default$4() {
        return RestCommunication.delete$default$4$(this);
    }

    @Override
    public <ResultType> Seq<Tuple2<Class<?>, String>> delete$default$5() {
        return RestCommunication.delete$default$5$(this);
    }

    @Override
    public <ResultType> boolean delete$default$6() {
        return RestCommunication.delete$default$6$(this);
    }

    @Override
    public OutputStream insertToNode(NodeDesc node, String suffix, H2OConf conf, Map<String, Object> params) {
        return RestCommunication.insertToNode$(this, node, suffix, conf, params);
    }

    @Override
    public Map<String, Object> insertToNode$default$4() {
        return RestCommunication.insertToNode$default$4$(this);
    }

    @Override
    public OutputStream insert(URI endpoint, String suffix, H2OConf conf, Function1<OutputStream, OutputStream> streamWrapper, Map<String, Object> params) {
        return RestCommunication.insert$(this, endpoint, suffix, conf, streamWrapper, params);
    }

    @Override
    public Function1<OutputStream, OutputStream> insert$default$4() {
        return RestCommunication.insert$default$4$(this);
    }

    @Override
    public Map<String, Object> insert$default$5() {
        return RestCommunication.insert$default$5$(this);
    }

    @Override
    public void delete(URI endpoint, String suffix, H2OConf conf) {
        RestCommunication.delete$(this, endpoint, suffix, conf);
    }

    @Override
    public <ResultType> ResultType request(URI endpoint, String requestType, String suffix, H2OConf conf, Map<String, Object> params, Seq<Tuple2<Class<?>, String>> skippedFields, boolean encodeParamsAsJson, Enumeration.Value confirmationLoggingLevel, ClassTag<ResultType> evidence$4) {
        return (ResultType)RestCommunication.request$(this, endpoint, requestType, suffix, conf, params, skippedFields, encodeParamsAsJson, confirmationLoggingLevel, evidence$4);
    }

    @Override
    public <ResultType> Map<String, Object> request$default$5() {
        return RestCommunication.request$default$5$(this);
    }

    @Override
    public <ResultType> Seq<Tuple2<Class<?>, String>> request$default$6() {
        return RestCommunication.request$default$6$(this);
    }

    @Override
    public <ResultType> boolean request$default$7() {
        return RestCommunication.request$default$7$(this);
    }

    @Override
    public <ResultType> Enumeration.Value request$default$8() {
        return RestCommunication.request$default$8$(this);
    }

    @Override
    public <ResultType> ResultType deserialize(String content, Seq<Tuple2<Class<?>, String>> skippedFields, ClassTag<ResultType> evidence$5) {
        return (ResultType)RestCommunication.deserialize$((RestCommunication)this, content, skippedFields, evidence$5);
    }

    @Override
    public <ResultType> ResultType deserialize(JsonElement content, Seq<Tuple2<Class<?>, String>> skippedFields, ClassTag<ResultType> evidence$6) {
        return (ResultType)RestCommunication.deserialize$((RestCommunication)this, content, skippedFields, evidence$6);
    }

    @Override
    public JsonObject deserializeAsJsonObject(String content, Seq<Tuple2<Class<?>, String>> skippedFields) {
        return RestCommunication.deserializeAsJsonObject$(this, content, skippedFields);
    }

    @Override
    public void downloadBinaryURLContent(URI endpoint, String suffix, H2OConf conf, File file) {
        RestCommunication.downloadBinaryURLContent$(this, endpoint, suffix, conf, file);
    }

    @Override
    public void downloadStringURLContent(URI endpoint, String suffix, H2OConf conf, File file) {
        RestCommunication.downloadStringURLContent$(this, endpoint, suffix, conf, file);
    }

    @Override
    public InputStream readURLContent(URI endpoint, String requestType, String suffix, H2OConf conf, Map<String, Object> params, boolean encodeParamsAsJson, Option<String> file, Enumeration.Value confirmationLoggingLevel) {
        return RestCommunication.readURLContent$(this, endpoint, requestType, suffix, conf, params, encodeParamsAsJson, file, confirmationLoggingLevel);
    }

    @Override
    public Map<String, Object> readURLContent$default$5() {
        return RestCommunication.readURLContent$default$5$(this);
    }

    @Override
    public boolean readURLContent$default$6() {
        return RestCommunication.readURLContent$default$6$(this);
    }

    @Override
    public Option<String> readURLContent$default$7() {
        return RestCommunication.readURLContent$default$7$(this);
    }

    @Override
    public Enumeration.Value readURLContent$default$8() {
        return RestCommunication.readURLContent$default$8$(this);
    }

    @Override
    public void checkResponseCode(HttpURLConnection connection, Enumeration.Value confirmationLoggingLevel) {
        RestCommunication.checkResponseCode$(this, connection, confirmationLoggingLevel);
    }

    @Override
    public Enumeration.Value checkResponseCode$default$2() {
        return RestCommunication.checkResponseCode$default$2$(this);
    }

    @Override
    public String stringifyPrimitiveParam(Object value) {
        return RestEncodingUtils.stringifyPrimitiveParam$(this, value);
    }

    @Override
    public boolean isPrimitiveType(Object value) {
        return RestEncodingUtils.isPrimitiveType$(this, value);
    }

    @Override
    public String stringifyArray(Object arr) {
        return RestEncodingUtils.stringifyArray$(this, arr);
    }

    @Override
    public String stringifyMap(Map<?, ?> map) {
        return RestEncodingUtils.stringifyMap$(this, map);
    }

    @Override
    public String stringifyPair(Tuple2<?, ?> pair) {
        return RestEncodingUtils.stringifyPair$(this, pair);
    }

    @Override
    public String stringify(Object value) {
        return RestEncodingUtils.stringify$(this, value);
    }

    @Override
    public String stringifyParams(Map<String, Object> params, boolean encodeParamsAsJson) {
        return RestEncodingUtils.stringifyParams$(this, params, encodeParamsAsJson);
    }

    @Override
    public Map<String, Object> stringifyParams$default$1() {
        return RestEncodingUtils.stringifyParams$default$1$(this);
    }

    @Override
    public boolean stringifyParams$default$2() {
        return RestEncodingUtils.stringifyParams$default$2$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public RestCommunication$LoggingLevel$ LoggingLevel() {
        if (this.LoggingLevel$module == null) {
            this.LoggingLevel$lzycompute$2();
        }
        return this.LoggingLevel$module;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public boolean exists(String modelId) {
        H2OConf conf = H2OContext$.MODULE$.ensure((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> H2OContext$.MODULE$.ensure$default$1()).getConf();
        URI endpoint = RestApiUtils$.MODULE$.getClusterEndpoint(conf);
        ModelsV3 models = (ModelsV3)this.query(endpoint, "/3/Models", conf, this.query$default$4(), this.query$default$5(), this.query$default$6(), ClassTag$.MODULE$.apply(ModelsV3.class));
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])models.models)).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)H2OBinaryModel$.$anonfun$exists$2(modelId, x$1)));
    }

    public H2OBinaryModel read(String path) {
        return this.read(path, (Option<String>)None$.MODULE$);
    }

    private String extractVersionFromModel(String path) {
        return (String)ScalaUtils$.MODULE$.withResource(SparkSessionUtils$.MODULE$.readHDFSFile(path), (Function1 & Serializable & scala.Serializable)fis -> (String)ScalaUtils$.MODULE$.withResource(new DataInputStream((InputStream)fis), (Function1 & Serializable & scala.Serializable)dis -> {
            byte[] arr = new byte[20];
            dis.readFully(arr);
            AutoBuffer ab = new AutoBuffer(arr);
            int persistenceInfo = ab.get1U();
            int magic = ab.get1U();
            if (persistenceInfo != 28 || magic != 237) {
                throw new RuntimeException("Invalid binary model");
            }
            return ab.getStr();
        }));
    }

    private void checkVersion(String expected, String modelVersion) {
        String string = expected;
        String string2 = modelVersion;
        if ((string == null ? string2 != null : !string.equals(string2)) && !modelVersion.endsWith("99999")) {
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(278).append("\n           | The binary model has been trained in H2O of version\n           | ").append(modelVersion).append(" but you are currently running H2O version of ").append(expected).append(".\n           | Please make sure that running Sparkling Water/H2O-3 cluster and the loaded binary\n           | model correspond to the same H2O-3 version.").toString())).stripMargin());
        }
    }

    public H2OBinaryModel read(String path, Option<String> modelIdOption) {
        String string;
        this.verifyH2OIsRunning();
        String modelVersion = this.extractVersionFromModel(path);
        this.checkVersion(BuildInfo$.MODULE$.H2OVersion(), modelVersion);
        if (modelIdOption.isDefined()) {
            string = (String)modelIdOption.get();
        } else {
            H2OConf conf = H2OContext$.MODULE$.ensure((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> H2OContext$.MODULE$.ensure$default$1()).getConf();
            URI endpoint = RestApiUtils$.MODULE$.getClusterEndpoint(conf);
            Map params = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dir"), (Object)SparkSessionUtils$.MODULE$.hdfsQualifiedPath(path)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"model_id"), (Object)"test")}));
            ModelsV3 modelsV3 = (ModelsV3)RestApiUtils$.MODULE$.update(endpoint, "/99/Models.bin/", conf, (Map<String, Object>)params, RestApiUtils$.MODULE$.update$default$5(), RestApiUtils$.MODULE$.update$default$6(), ClassTag$.MODULE$.apply(ModelsV3.class));
            string = ((ModelSchemaBaseV3)new ArrayOps.ofRef((Object[])Predef$.MODULE$.refArrayOps((Object[])((Object[])modelsV3.models))).head()).model_id.name;
        }
        String modelId = string;
        H2OBinaryModel model = new H2OBinaryModel(modelId);
        return (H2OBinaryModel)model.setBinaryModel(SparkSessionUtils$.MODULE$.readHDFSFile(path));
    }

    private void verifyH2OIsRunning() {
        if (H2OContext$.MODULE$.get().isEmpty()) {
            throw new IllegalArgumentException("To use features available on a binary model, H2O Context has to be running!");
        }
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final void LoggingLevel$lzycompute$2() {
        H2OBinaryModel$ h2OBinaryModel$ = this;
        synchronized (h2OBinaryModel$) {
            if (this.LoggingLevel$module == null) {
                this.LoggingLevel$module = new RestCommunication$LoggingLevel$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$exists$2(String modelId$1, ModelSchemaBaseV3 x$1) {
        String string = x$1.model_id.name;
        String string2 = modelId$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private H2OBinaryModel$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        RestEncodingUtils.$init$(this);
        RestCommunication.$init$(this);
    }
}

