/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.extensions.internals;

import java.util.ArrayList;
import water.Key;
import water.nbhm.NonBlockingHashMap;

public final class LocalNodeDomains {
    private static NonBlockingHashMap<Key, ArrayList<String[][]>> domainsMap = new NonBlockingHashMap();
    private static NonBlockingHashMap<String, String[][]> domainsMapByChunk = new NonBlockingHashMap();
    private static NonBlockingHashMap<Key, ArrayList<String>> frameKeyToChunkKeys = new NonBlockingHashMap();

    public static synchronized void addDomains(Key frameKey, int chunkId, String[][] domains) {
        ArrayList<Object> nodeDomains = domainsMap.get(frameKey);
        if (nodeDomains == null) {
            nodeDomains = new ArrayList();
            domainsMap.put(frameKey, nodeDomains);
        }
        nodeDomains.add(domains);
        ArrayList<String> chunkKeys = frameKeyToChunkKeys.get(frameKey);
        if (chunkKeys == null) {
            chunkKeys = new ArrayList();
            frameKeyToChunkKeys.put(frameKey, chunkKeys);
        }
        String chunkKey = LocalNodeDomains.createChunkKey(frameKey, chunkId);
        chunkKeys.add(chunkKey);
        domainsMapByChunk.putIfAbsent(chunkKey, domains);
    }

    public static synchronized boolean containsDomains(Key frameKey) {
        return domainsMap.containsKey(frameKey);
    }

    public static synchronized boolean containsDomains(Key frameKey, int chunkId) {
        String chunkKey = LocalNodeDomains.createChunkKey(frameKey, chunkId);
        return domainsMapByChunk.containsKey(chunkKey);
    }

    public static synchronized String[][][] getDomains(Key frameKey) {
        return (String[][][])domainsMap.get(frameKey).toArray((T[])new String[0][][]);
    }

    public static synchronized String[][] getDomains(Key frameKey, int chunkId) {
        String chunkKey = LocalNodeDomains.createChunkKey(frameKey, chunkId);
        return domainsMapByChunk.get(chunkKey);
    }

    public static synchronized void remove(Key frameKey) {
        if (domainsMap.remove(frameKey) != null) {
            ArrayList<String> chunkKeys = frameKeyToChunkKeys.remove(frameKey);
            for (String chunkKey : chunkKeys) {
                domainsMapByChunk.remove(chunkKey);
            }
            frameKeyToChunkKeys.remove(frameKey);
        }
    }

    public static synchronized void remove(Key frameKey, int[] domainIndices) {
        ArrayList<String> chunkKeys;
        if (domainIndices.length > 0 && (chunkKeys = frameKeyToChunkKeys.get(frameKey)) != null) {
            ArrayList<String[][]> newFrameDomains = new ArrayList<String[][]>();
            for (int i2 = 0; i2 < chunkKeys.size(); ++i2) {
                String chunkKey = chunkKeys.get(i2);
                String[][] oldDomains = domainsMapByChunk.get(chunkKey);
                String[][] newDomains = LocalNodeDomains.removeDomains(oldDomains, domainIndices);
                domainsMapByChunk.replace(chunkKey, newDomains);
                newFrameDomains.add(newDomains);
            }
            domainsMap.replace(frameKey, newFrameDomains);
        }
    }

    private static String[][] removeDomains(String[][] originalDomains, int[] domainsToRemove) {
        int newSize = originalDomains.length - domainsToRemove.length;
        String[][] result = new String[newSize][];
        int removedDomainIndex = 0;
        for (int originalIndex = 0; originalIndex < originalDomains.length; ++originalIndex) {
            if (removedDomainIndex >= domainsToRemove.length || originalIndex != domainsToRemove[removedDomainIndex]) {
                result[originalIndex - removedDomainIndex] = originalDomains[originalIndex];
                continue;
            }
            ++removedDomainIndex;
        }
        return result;
    }

    private static String createChunkKey(Key frameKey, int chunkId) {
        return frameKey.toString() + "_" + chunkId;
    }
}

