/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.backend.utils;

import ai.h2o.org.eclipse.jetty.server.Server;
import ai.h2o.sparkling.H2OConf;
import ai.h2o.sparkling.H2OContext;
import ai.h2o.sparkling.utils.SparkSessionUtils$;
import java.io.Serializable;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.URI;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;
import scala.util.matching.Regex;
import water.H2O;
import water.init.NetworkInit;
import water.webserver.H2OHttpViewImpl;
import water.webserver.iface.H2OHttpConfig;
import water.webserver.jetty9.SparklingWaterJettyHelper;

public final class ProxyStarter$
implements org.apache.spark.expose.Logging {
    public static ProxyStarter$ MODULE$;
    private Server server;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new ProxyStarter$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Server server() {
        return this.server;
    }

    private void server_$eq(Server x$1) {
        this.server = x$1;
    }

    public URI startFlowProxy(H2OContext hc, H2OConf conf) {
        int port = this.findFlowProxyBasePort(conf);
        while (true) {
            try {
                H2OHttpConfig config = NetworkInit.webServerConfig(this.confToH2OArgs(conf));
                H2OHttpViewImpl h2oHttpView = new H2OHttpViewImpl(config);
                SparklingWaterJettyHelper helper = new SparklingWaterJettyHelper(hc, conf, h2oHttpView);
                port = this.findNextFreeFlowPort(conf.clientWebPort(), port);
                this.server_$eq(helper.startServer(port));
                return new URI(new StringBuilder(4).append(conf.getScheme()).append("://").append(SparkEnv$.MODULE$.get().blockManager().blockManagerId().host()).append(":").append(port).append(conf.contextPath().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString());
            }
            catch (BindException bindException) {
                ++port;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    private H2O.OptArgs confToH2OArgs(H2OConf conf) {
        void var2_2;
        H2O.OptArgs args = new H2O.OptArgs();
        args.jks = (String)conf.jks().orNull(Predef$.MODULE$.$conforms());
        args.jks_pass = (String)conf.jksPass().orNull(Predef$.MODULE$.$conforms());
        args.jks_alias = (String)conf.jksAlias().orNull(Predef$.MODULE$.$conforms());
        args.login_conf = (String)conf.loginConf().orNull(Predef$.MODULE$.$conforms());
        args.user_name = (String)conf.userName().orNull(Predef$.MODULE$.$conforms());
        args.context_path = (String)conf.contextPath().orNull(Predef$.MODULE$.$conforms());
        args.hash_login = conf.hashLogin();
        args.ldap_login = conf.ldapLogin();
        args.kerberos_login = conf.kerberosLogin();
        args.embedded = true;
        return var2_2;
    }

    public void stopFlowProxy() {
        try {
            this.server().stop();
        }
        catch (Throwable throwable) {}
    }

    private int findFlowProxyBasePort(H2OConf conf) {
        int n2;
        Regex LOCAL_N_REGEX = new StringOps(Predef$.MODULE$.augmentString("local\\[([0-9]+|\\*)\\]")).r();
        Regex LOCAL_N_FAILURES_REGEX = new StringOps(Predef$.MODULE$.augmentString("local\\[([0-9]+|\\*)\\s*,\\s*([0-9]+)\\]")).r();
        Regex LOCAL_CLUSTER_REGEX = new StringOps(Predef$.MODULE$.augmentString("local-cluster\\[\\s*([0-9]+)\\s*,\\s*([0-9]+)\\s*,\\s*([0-9]+)\\s*]")).r();
        String LOCAL = "local";
        String master = SparkSessionUtils$.MODULE$.active().sparkContext().master();
        if (conf.runsInInternalClusterMode() && conf.internalPortOffset() == 1) {
            int n3;
            String string = master;
            String string2 = LOCAL;
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                n3 = 2;
            } else {
                Option option = LOCAL_N_REGEX.unapplySeq((CharSequence)string);
                if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                    n3 = 2;
                } else {
                    Option option2 = LOCAL_N_FAILURES_REGEX.unapplySeq((CharSequence)string);
                    if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(2) == 0) {
                        n3 = 2;
                    } else {
                        Option option3 = LOCAL_CLUSTER_REGEX.unapplySeq((CharSequence)string);
                        if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(3) == 0) {
                            String nodes = (String)((LinearSeqOptimized)option3.get()).apply(0);
                            n3 = new StringOps(Predef$.MODULE$.augmentString(nodes)).toInt() * 2;
                        } else {
                            n3 = 0;
                        }
                    }
                }
            }
            n2 = n3;
        } else {
            n2 = 0;
        }
        int numSkipped = n2;
        return conf.basePort() + numSkipped;
    }

    private boolean isTcpPortAvailable(int port) {
        return BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            ServerSocket serverSocket = new ServerSocket();
            serverSocket.setReuseAddress(false);
            String host = SparkEnv$.MODULE$.get().blockManager().blockManagerId().host();
            MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Trying to bind on ").append(host).append(":").append(port).append(" using 0.0.0.0 ip address").toString());
            InetSocketAddress socketAddress = new InetSocketAddress("0.0.0.0", port);
            serverSocket.bind(socketAddress, 1);
            serverSocket.close();
            return true;
        }).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
    }

    private int findNextFreeFlowPort(int clientWebPort, int clientBasePort) {
        int n2;
        if (clientWebPort == -1) {
            IntRef port = IntRef.create((int)clientBasePort);
            while (!this.isTcpPortAvailable(port.elem)) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Tried using port ").append(port$2.elem).append(" for Flow proxy, but port was already occupied!").toString());
                ++port.elem;
            }
            n2 = port.elem;
        } else {
            int port = clientWebPort;
            if (!this.isTcpPortAvailable(port)) {
                throw new RuntimeException(new StringBuilder(86).append("Explicitly specified client web port ").append(port).append(" is already occupied, please specify a free port!").toString());
            }
            n2 = port;
        }
        return n2;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ProxyStarter$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

