/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.backend.utils;

import ai.h2o.sparkling.H2OConf;
import ai.h2o.sparkling.H2OContext;
import ai.h2o.sparkling.H2OFrame;
import ai.h2o.sparkling.H2OFrame$;
import ai.h2o.sparkling.backend.BuildInfo$;
import ai.h2o.sparkling.backend.H2OJob$;
import ai.h2o.sparkling.backend.NodeDesc;
import ai.h2o.sparkling.backend.SharedBackendConf$;
import ai.h2o.sparkling.backend.exceptions.H2OClusterNotReachableException;
import ai.h2o.sparkling.backend.exceptions.RestApiCommunicationException;
import ai.h2o.sparkling.backend.exceptions.RestApiException;
import ai.h2o.sparkling.backend.external.ExternalBackendConf$;
import ai.h2o.sparkling.backend.external.K8sExternalBackendClient$;
import ai.h2o.sparkling.backend.internal.InternalBackendConf$;
import ai.h2o.sparkling.backend.utils.H2OContextExtensions$;
import ai.h2o.sparkling.backend.utils.RestApiUtils;
import ai.h2o.sparkling.backend.utils.RestApiUtils$;
import ai.h2o.sparkling.backend.utils.ShellUtils;
import ai.h2o.sparkling.extensions.rest.api.schema.VerifyVersionV3;
import ai.h2o.sparkling.extensions.rest.api.schema.VerifyWebOpenV3;
import java.awt.Desktop;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.spark.SparkContext;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Mirrors;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import water.api.schemas3.CloudLockV3;
import water.api.schemas3.JobV3;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g!C\n\u0015!\u0003\r\taHA`\u0011\u0015\u0001\u0004\u0001\"\u00012\u0011\u0015)\u0004\u0001\"\u00017\u0011\u00151\u0005\u0001\"\u0001H\u0011\u001dY\u0006!%A\u0005\u0002qCqa\u001a\u0001\u0012\u0002\u0013\u0005\u0001\u000eC\u0004k\u0001E\u0005I\u0011A6\t\u000b5\u0004A\u0011\u00038\t\u000f\u0005\u0015\u0001\u0001\"\u0005\u0002\b!9\u0011Q\u0002\u0001\u0005\n\u0005=\u0001bBA\t\u0001\u0011%\u00111\u0003\u0005\b\u0003/\u0001A\u0011BA\r\u0011\u001d\tI\u0003\u0001C\t\u0003WAq!!\u000f\u0001\t#\tY\u0004C\u0004\u0002:\u0001!I!a\u0011\t\u000f\u0005\u001d\u0006\u0001\"\u0003\u0002*\"9\u0011Q\u0016\u0001\u0005\n\u0005=\u0006bBAZ\u0001\u0011%\u0011Q\u0017\u0005\b\u0003s\u0003A\u0011BA^\u0005QA%gT\"p]R,\u0007\u0010^#yi\u0016t7/[8og*\u0011QCF\u0001\u0006kRLGn\u001d\u0006\u0003/a\tqAY1dW\u0016tGM\u0003\u0002\u001a5\u0005I1\u000f]1sW2Lgn\u001a\u0006\u00037q\t1\u0001\u001b\u001ap\u0015\u0005i\u0012AA1j\u0007\u0001\u0019R\u0001\u0001\u0011'U5\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012a!\u00118z%\u00164\u0007CA\u0014)\u001b\u0005!\u0012BA\u0015\u0015\u0005E\u0011Vm\u001d;D_6lWO\\5dCRLwN\u001c\t\u0003O-J!\u0001\f\u000b\u0003\u0019I+7\u000f^!qSV#\u0018\u000e\\:\u0011\u0005\u001dr\u0013BA\u0018\u0015\u0005)\u0019\u0006.\u001a7m+RLGn]\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0015\u0003I\u0002\"!I\u001a\n\u0005Q\u0012#\u0001B+oSR\fq\u0002Z8x]2|\u0017\r\u001a%3\u001f2{wm\u001d\u000b\u0004o\t#\u0005C\u0001\u001d@\u001d\tIT\b\u0005\u0002;E5\t1H\u0003\u0002==\u00051AH]8pizJ!A\u0010\u0012\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0015I\u0001\u0004TiJLgn\u001a\u0006\u0003}\tBQa\u0011\u0002A\u0002]\na\u0002Z3ti&t\u0017\r^5p]\u0012K'\u000fC\u0003F\u0005\u0001\u0007q'\u0001\u0007m_\u001e\u001cuN\u001c;bS:,'/A\bj[B|'\u000f\u001e%jm\u0016$\u0016M\u00197f)\u0015AEJ\u0014)W!\tI%*D\u0001\u0019\u0013\tY\u0005D\u0001\u0005Ie=3%/Y7f\u0011\u001di5\u0001%AA\u0002]\n\u0001\u0002Z1uC\n\f7/\u001a\u0005\u0006\u001f\u000e\u0001\raN\u0001\u0006i\u0006\u0014G.\u001a\u0005\b#\u000e\u0001\n\u00111\u0001S\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u0004CM+\u0016B\u0001+#\u0005\u0015\t%O]1z!\r\t3k\u000e\u0005\b/\u000e\u0001\n\u00111\u0001Y\u0003A\tG\u000e\\8x\u001bVdG/\u001b$pe6\fG\u000f\u0005\u0002\"3&\u0011!L\t\u0002\b\u0005>|G.Z1o\u0003eIW\u000e]8si\"Kg/\u001a+bE2,G\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003uS#a\u000e0,\u0003}\u0003\"\u0001Y3\u000e\u0003\u0005T!AY2\u0002\u0013Ut7\r[3dW\u0016$'B\u00013#\u0003)\tgN\\8uCRLwN\\\u0005\u0003M\u0006\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003eIW\u000e]8si\"Kg/\u001a+bE2,G\u0005Z3gCVdG\u000fJ\u001a\u0016\u0003%T#A\u00150\u00023%l\u0007o\u001c:u\u0011&4X\rV1cY\u0016$C-\u001a4bk2$H\u0005N\u000b\u0002Y*\u0012\u0001LX\u0001\u001ao&$\bnQ8om\u0016\u00148/[8o\t\u0016\u0014Wo\u001a)sS:$8\u000f\u0006\u0003I_nl\b\"\u00029\b\u0001\u0004\t\u0018AA:d!\t\u0011\u00180D\u0001t\u0015\t!X/A\u0003ta\u0006\u00148N\u0003\u0002wo\u00061\u0011\r]1dQ\u0016T\u0011\u0001_\u0001\u0004_J<\u0017B\u0001>t\u00051\u0019\u0006/\u0019:l\u0007>tG/\u001a=u\u0011\u0015ax\u00011\u00018\u00039\u0019wN\u001c<feNLwN\u001c(b[\u0016DaA`\u0004\u0005\u0002\u0004y\u0018!\u00022m_\u000e\\\u0007\u0003B\u0011\u0002\u0002!K1!a\u0001#\u0005!a$-\u001f8b[\u0016t\u0014aB8qK:,&+\u0013\u000b\u0004e\u0005%\u0001BBA\u0006\u0011\u0001\u0007q'A\u0002ve&\f1\u0002\\8h\r&dWMT1nKR\tq'\u0001\nwKJLg-\u001f'pO\u000e{g\u000e^1j]\u0016\u0014Hc\u0001\u001a\u0002\u0016!)QI\u0003a\u0001o\u0005qAO]=U_2{7m[\"m_V$G#\u0002-\u0002\u001c\u0005\u0015\u0002bBA\u000f\u0017\u0001\u0007\u0011qD\u0001\u0005G>tg\rE\u0002J\u0003CI1!a\t\u0019\u0005\u001dA%gT\"p]\u001aDa!a\n\f\u0001\u0004A\u0016AD2bi\u000eDW\t_2faRLwN\\\u0001\u0018O\u0016$\u0018I\u001c3WKJLg-_,pe.,'OT8eKN$B!!\f\u00028A!\u0011eUA\u0018!\u0011\t\t$a\r\u000e\u0003YI1!!\u000e\u0017\u0005!qu\u000eZ3EKN\u001c\u0007bBA\u000f\u0019\u0001\u0007\u0011qD\u0001\u0015G>dG.Z2u!J|\u0007/\u001a:uS\u0016\u001cHi\\2\u0015\u0005\u0005u\u0002#\u0002\u001d\u0002@]:\u0014bAA!\u0003\n\u0019Q*\u00199\u0016\t\u0005\u0015\u0013\u0011\u0011\u000b\u0005\u0003\u000f\n\u0019\n\u0006\u0003\u0002>\u0005%\u0003bBA&\u001d\u0001\u000f\u0011QJ\u0001\u0004i\u0006<\u0007CBA(\u0003c\niH\u0004\u0003\u0002R\u0005-d\u0002BA*\u0003KrA!!\u0016\u0002`9!\u0011qKA.\u001d\rQ\u0014\u0011L\u0005\u0002G%\u0019\u0011Q\f\u0012\u0002\u000fI,g\r\\3di&!\u0011\u0011MA2\u0003\u001d\u0011XO\u001c;j[\u0016T1!!\u0018#\u0013\u0011\t9'!\u001b\u0002\u000fA\f7m[1hK*!\u0011\u0011MA2\u0013\u0011\ti'a\u001c\u0002\u0011Ut\u0017N^3sg\u0016TA!a\u001a\u0002j%!\u00111OA;\u0005\u001d!\u0016\u0010]3UC\u001eLA!a\u001e\u0002z\tAA+\u001f9f)\u0006<7O\u0003\u0003\u0002|\u0005\r\u0014aA1qSB!\u0011qPAA\u0019\u0001!q!a!\u000f\u0005\u0004\t)IA\u0001U#\u0011\t9)!$\u0011\u0007\u0005\nI)C\u0002\u0002\f\n\u0012qAT8uQ&tw\rE\u0002\"\u0003\u001fK1!!%#\u0005\r\te.\u001f\u0005\b\u0003+s\u0001\u0019AAL\u0003\u0005!\b\u0003BAM\u0003Gk!!a'\u000b\t\u0005u\u0015qT\u0001\u0005Y\u0006twM\u0003\u0002\u0002\"\u0006!!.\u0019<b\u0013\u0011\t)+a'\u0003\r=\u0013'.Z2u\u0003Y\u0019Ho\u001c9FqR,'O\\1m\u0011Jz5\t\\;ti\u0016\u0014Hc\u0001\u001a\u0002,\"9\u0011QD\bA\u0002\u0005}\u0011!\u0004<fe&4\u0017pV3c\u001fB,g\u000eF\u00023\u0003cCq!!\b\u0011\u0001\u0004\ty\"A\u0007wKJLg-\u001f,feNLwN\u001c\u000b\u0004e\u0005]\u0006bBA\u000f#\u0001\u0007\u0011qD\u0001\nY>\u001c7n\u00117pk\u0012$2AMA_\u0011\u001d\tiB\u0005a\u0001\u0003?\u00012!SAa\u0013\r\t\u0019\r\u0007\u0002\u000b\u0011Jz5i\u001c8uKb$\b")
public interface H2OContextExtensions
extends RestApiUtils,
ShellUtils {
    public static /* synthetic */ String downloadH2OLogs$(H2OContextExtensions $this, String destinationDir, String logContainer) {
        return $this.downloadH2OLogs(destinationDir, logContainer);
    }

    default public String downloadH2OLogs(String destinationDir, String logContainer) {
        this.verifyLogContainer(logContainer);
        URI endpoint = RestApiUtils$.MODULE$.getClusterEndpoint(((H2OContext)this).getConf());
        File file = new File(destinationDir, new StringBuilder(1).append(this.logFileName()).append(".").append(logContainer.toLowerCase()).toString());
        String logEndpoint = new StringBuilder(17).append("/3/Logs/download/").append(logContainer).toString();
        String string = logContainer;
        if ("LOG".equals(string)) {
            this.downloadStringURLContent(endpoint, logEndpoint, ((H2OContext)this).getConf(), file);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("ZIP".equals(string)) {
            this.downloadBinaryURLContent(endpoint, logEndpoint, ((H2OContext)this).getConf(), file);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)string);
        }
        return file.getAbsolutePath();
    }

    public static /* synthetic */ H2OFrame importHiveTable$(H2OContextExtensions $this, String database, String table, String[][] partitions, boolean allowMultiFormat) {
        return $this.importHiveTable(database, table, partitions, allowMultiFormat);
    }

    default public H2OFrame importHiveTable(String database, String table, String[][] partitions, boolean allowMultiFormat) {
        H2OFrame h2OFrame;
        URI endpoint = RestApiUtils$.MODULE$.getClusterEndpoint(((H2OContext)this).getConf());
        Map params = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"database"), (Object)database), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"table"), (Object)table), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partitions"), (Object)partitions), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"allow_multi_format"), (Object)BoxesRunTime.boxToBoolean((boolean)allowMultiFormat))}));
        try {
            JobV3 job = (JobV3)RestApiUtils$.MODULE$.update(endpoint, "/3/ImportHiveTable", ((H2OContext)this).getConf(), (Map<String, Object>)params, RestApiUtils$.MODULE$.update$default$5(), RestApiUtils$.MODULE$.update$default$6(), ClassTag$.MODULE$.apply(JobV3.class));
            H2OJob$.MODULE$.apply(job.key.name).waitForFinishAndPrintProgress();
            h2OFrame = H2OFrame$.MODULE$.apply(job.dest.name);
        }
        catch (Throwable throwable) {
            RestApiCommunicationException restApiCommunicationException;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof RestApiCommunicationException && (restApiCommunicationException = (RestApiCommunicationException)throwable2).getMessage().contains("table not found")) {
                throw new IllegalArgumentException(new StringBuilder(43).append("Table '").append(table).append("' not found in the Hive database '").append(database).append("'!").toString());
            }
            throw throwable;
        }
        return h2OFrame;
    }

    public static /* synthetic */ String importHiveTable$default$1$(H2OContextExtensions $this) {
        return $this.importHiveTable$default$1();
    }

    default public String importHiveTable$default$1() {
        return "default";
    }

    public static /* synthetic */ String[][] importHiveTable$default$3$(H2OContextExtensions $this) {
        return $this.importHiveTable$default$3();
    }

    default public String[][] importHiveTable$default$3() {
        return null;
    }

    public static /* synthetic */ boolean importHiveTable$default$4$(H2OContextExtensions $this) {
        return $this.importHiveTable$default$4();
    }

    default public boolean importHiveTable$default$4() {
        return false;
    }

    public static /* synthetic */ H2OFrame withConversionDebugPrints$(H2OContextExtensions $this, SparkContext sc, String conversionName, Function0 block) {
        return $this.withConversionDebugPrints(sc, conversionName, (Function0<H2OFrame>)block);
    }

    default public H2OFrame withConversionDebugPrints(SparkContext sc, String conversionName, Function0<H2OFrame> block) {
        H2OFrame h2OFrame;
        String propName = "spark.h2o.measurements.timing";
        Option performancePrintConf = sc.getConf().getOption(propName).orElse((Function0 & Serializable & scala.Serializable)() -> scala.sys.package$.MODULE$.props().get(propName));
        if (performancePrintConf.nonEmpty() && new StringOps(Predef$.MODULE$.augmentString((String)performancePrintConf.get())).toBoolean()) {
            long t0 = System.nanoTime();
            H2OFrame result = (H2OFrame)block.apply();
            long t1 = System.nanoTime();
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Elapsed time of the ").append(conversionName).append(" conversion into H2OFrame ").append(result.frameId()).append(": ").append((t1 - t0) / 1000L).append(" millis").toString());
            h2OFrame = result;
        } else {
            h2OFrame = (H2OFrame)block.apply();
        }
        return h2OFrame;
    }

    public static /* synthetic */ void openURI$(H2OContextExtensions $this, String uri) {
        $this.openURI(uri);
    }

    default public void openURI(String uri) {
        if (Desktop.isDesktopSupported()) {
            Desktop.getDesktop().browse(new URI(uri));
        } else {
            this.logWarning((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Desktop support is missing! Cannot open browser for ").append(uri).toString());
        }
    }

    private String logFileName() {
        String pattern = "yyyyMMdd_hhmmss";
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        String now = formatter.format(new Date());
        return new StringBuilder(8).append("h2ologs_").append(now).toString();
    }

    private void verifyLogContainer(String logContainer) {
        if (!((SeqLike)new .colon.colon((Object)"ZIP", (List)new .colon.colon((Object)"LOG", (List)Nil$.MODULE$))).contains((Object)logContainer)) {
            throw new IllegalArgumentException(new StringBuilder(61).append("Supported LOG container is either LOG or ZIP, specified was: ").append(logContainer).toString());
        }
    }

    private boolean tryToLockCloud(H2OConf conf, boolean catchException) {
        boolean bl;
        String h2oCluster = new StringBuilder(0).append((String)conf.h2oCluster().get()).append(conf.contextPath().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString();
        String h2oClusterName = (String)conf.cloudName().get();
        try {
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Trying to lock H2O cluster ").append(h2oCluster).append(" - ").append(h2oClusterName).append(".").toString());
            this.lockCloud(conf);
            bl = true;
        }
        catch (Throwable throwable) {
            RestApiException restApiException;
            block5: {
                block4: {
                    Throwable throwable2 = throwable;
                    if (!(throwable2 instanceof RestApiException)) break block4;
                    restApiException = (RestApiException)throwable2;
                    if (catchException) break block5;
                }
                throw throwable;
            }
            this.logWarning((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Locking of the H2O cluster ").append(h2oCluster).append(" - ").append(h2oClusterName).append(" failed.").toString(), restApiException);
            boolean bl2 = false;
            bl = bl2;
        }
        return bl;
    }

    public static /* synthetic */ NodeDesc[] getAndVerifyWorkerNodes$(H2OContextExtensions $this, H2OConf conf) {
        return $this.getAndVerifyWorkerNodes(conf);
    }

    default public NodeDesc[] getAndVerifyWorkerNodes(H2OConf conf) {
        NodeDesc[] nodeDescArray;
        try {
            int maximumNumberOfAttempts = 6;
            int attemptId = 0;
            while (attemptId < maximumNumberOfAttempts) {
                boolean catchException = attemptId < maximumNumberOfAttempts - 1;
                boolean locked = this.tryToLockCloud(conf, catchException);
                if (locked) {
                    attemptId = maximumNumberOfAttempts;
                    continue;
                }
                Thread.sleep(10000L);
                ++attemptId;
            }
            this.verifyWebOpen(conf);
            if (!conf.isBackendVersionCheckDisabled()) {
                this.verifyVersion(conf);
            }
            nodeDescArray = RestApiUtils$.MODULE$.getNodes(conf);
        }
        catch (RestApiException cause) {
            if (conf.isAutoClusterStartUsed()) {
                this.stopExternalH2OCluster(conf);
            }
            String h2oCluster = new StringBuilder(0).append((String)conf.h2oCluster().get()).append(conf.contextPath().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString();
            String h2oClusterName = (String)conf.cloudName().get();
            throw new H2OClusterNotReachableException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(80).append("H2O cluster ").append(h2oCluster).append(" - ").append(h2oClusterName).append(" is not reachable.\n             |H2OContext has not been created.").toString())).stripMargin(), cause);
        }
        return nodeDescArray;
    }

    public static /* synthetic */ Map collectPropertiesDoc$(H2OContextExtensions $this) {
        return $this.collectPropertiesDoc();
    }

    default public Map<String, String> collectPropertiesDoc() {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(H2OContextExtensions.class.getClassLoader());
        public final class Ai_h2o_sparkling_backend_utils_H2OContextExtensions$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("ai.h2o.sparkling.backend").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("ai.h2o.sparkling.backend.SharedBackendConf"));
            }

            public Ai_h2o_sparkling_backend_utils_H2OContextExtensions$$typecreator1$1(H2OContext $outer) {
            }
        }
        Map<String, String> sharedConfOptions = this.collectPropertiesDoc(SharedBackendConf$.MODULE$, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Ai_h2o_sparkling_backend_utils_H2OContextExtensions$$typecreator1$1((H2OContext)this)));
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(H2OContextExtensions.class.getClassLoader());
        public final class Ai_h2o_sparkling_backend_utils_H2OContextExtensions$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("ai.h2o.sparkling.backend.internal").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("ai.h2o.sparkling.backend.internal.InternalBackendConf"));
            }

            public Ai_h2o_sparkling_backend_utils_H2OContextExtensions$$typecreator2$1(H2OContext $outer) {
            }
        }
        Map<String, String> internalConfOptions = this.collectPropertiesDoc(InternalBackendConf$.MODULE$, ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Ai_h2o_sparkling_backend_utils_H2OContextExtensions$$typecreator2$1((H2OContext)this)));
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(H2OContextExtensions.class.getClassLoader());
        public final class Ai_h2o_sparkling_backend_utils_H2OContextExtensions$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("ai.h2o.sparkling.backend.external").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("ai.h2o.sparkling.backend.external.ExternalBackendConf"));
            }

            public Ai_h2o_sparkling_backend_utils_H2OContextExtensions$$typecreator3$1(H2OContext $outer) {
            }
        }
        Map<String, String> externalConfOptions = this.collectPropertiesDoc(ExternalBackendConf$.MODULE$, ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Ai_h2o_sparkling_backend_utils_H2OContextExtensions$$typecreator3$1((H2OContext)this)));
        return sharedConfOptions.$plus$plus(internalConfOptions).$plus$plus(externalConfOptions);
    }

    private <T> Map<String, String> collectPropertiesDoc(Object t2, TypeTags.TypeTag<T> tag) {
        JavaUniverse ru = package$.MODULE$.universe();
        JavaUniverse.JavaMirror rm = ru.runtimeMirror(this.getClass().getClassLoader());
        Mirrors.InstanceMirror instanceMirror = rm.reflect(t2, ClassTag$.MODULE$.Object());
        Types.TypeApi typ = ((TypeTags)ru).typeOf(tag.in((Mirror)ru.runtimeMirror(H2OContextExtensions.class.getClassLoader())));
        Iterable members = (Iterable)((TraversableLike)typ.members().filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isPublic()))).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)H2OContextExtensions.$anonfun$collectPropertiesDoc$2(x$3)));
        Iterable reflectedMembers = (Iterable)((TraversableLike)members.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.asTerm(), Iterable$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)field -> instanceMirror.reflectField(field), Iterable$.MODULE$.canBuildFrom());
        return ((TraversableOnce)reflectedMembers.map((Function1 & Serializable & scala.Serializable)member -> {
            Tuple4 optionTuple = (Tuple4)member.get();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(optionTuple._1()), optionTuple._4());
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private void stopExternalH2OCluster(H2OConf conf) {
        String string = conf.externalAutoStartBackend();
        String string2 = ExternalBackendConf$.MODULE$.YARN_BACKEND();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            Option<String> yarnAppId = conf.getOption((String)ExternalBackendConf$.MODULE$.PROP_EXTERNAL_CLUSTER_YARN_APP_ID()._1());
            this.launchShellCommand((Seq)new .colon.colon((Object)"yarn", (List)new .colon.colon((Object)"application", (List)new .colon.colon((Object)"-kill", (List)new .colon.colon((Object)((String)yarnAppId.get()), (List)Nil$.MODULE$)))));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            String string4 = ExternalBackendConf$.MODULE$.KUBERNETES_BACKEND();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                K8sExternalBackendClient$.MODULE$.stopExternalH2OOnKubernetes(conf);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new RuntimeException("Invalid auto cluster start backend!");
            }
        }
    }

    private void verifyWebOpen(H2OConf conf) {
        URI endpoint = RestApiUtils$.MODULE$.getClusterEndpoint(conf);
        VerifyWebOpenV3 verifyWebOpenV3 = (VerifyWebOpenV3)RestApiUtils$.MODULE$.query(endpoint, "/3/verifyWebOpen", conf, RestApiUtils$.MODULE$.query$default$4(), RestApiUtils$.MODULE$.query$default$5(), RestApiUtils$.MODULE$.query$default$6(), ClassTag$.MODULE$.apply(VerifyWebOpenV3.class));
        String[] nodesWithoutWeb = verifyWebOpenV3.nodes_web_disabled;
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nodesWithoutWeb)).nonEmpty()) {
            throw new H2OClusterNotReachableException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(233).append("\n    The following worker nodes are not reachable, but belong to the cluster:\n    ").append(conf.h2oCluster().get()).append(" - ").append(conf.cloudName().get()).append(":\n    ----------------------------------------------\n    ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nodesWithoutWeb)).mkString("\n    ")).append("\n\n    The common reason for this error are disabled web interfaces on the H2O worker nodes.").toString())).stripMargin());
        }
    }

    private void verifyVersion(H2OConf conf) {
        String referencedVersion = BuildInfo$.MODULE$.H2OVersion();
        if (!referencedVersion.endsWith("-SNAPSHOT")) {
            URI endpoint = RestApiUtils$.MODULE$.getClusterEndpoint(conf);
            Map params = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"referenced_version"), (Object)referencedVersion)}));
            VerifyVersionV3 verifyVersionV3 = (VerifyVersionV3)RestApiUtils$.MODULE$.query(endpoint, "/3/verifyVersion", conf, (Map<String, Object>)params, RestApiUtils$.MODULE$.query$default$5(), RestApiUtils$.MODULE$.query$default$6(), ClassTag$.MODULE$.apply(VerifyVersionV3.class));
            VerifyVersionV3.NodeWithVersionV3[] nodesWrongVersion = verifyVersionV3.nodes_wrong_version;
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nodesWrongVersion)).nonEmpty()) {
                if (conf.runsInExternalClusterMode() && conf.isAutoClusterStartUsed()) {
                    this.stopExternalH2OCluster(conf);
                }
                throw new RuntimeException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(215).append("\n    Sparkling Water is using version of H2O ").append(referencedVersion).append(", but the following nodes have different version:\n    ----------------------------------------------\n    ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nodesWrongVersion)).map((Function1 & Serializable & scala.Serializable)nodeWithVersion -> new StringBuilder(3).append(nodeWithVersion.ip_port).append(" - ").append(nodeWithVersion.version).toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("\n    ")).append("\n\n    Please make sure to use the corresponding assembly H2O JAR.").toString())).stripMargin());
            }
        }
    }

    private void lockCloud(H2OConf conf) {
        URI endpoint = RestApiUtils$.MODULE$.getClusterEndpoint(conf);
        RestApiUtils$.MODULE$.update(endpoint, "/3/CloudLock", conf, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"reason"), (Object)"Locked from Sparkling Water.")}))), RestApiUtils$.MODULE$.update$default$5(), RestApiUtils$.MODULE$.update$default$6(), ClassTag$.MODULE$.apply(CloudLockV3.class));
    }

    public static /* synthetic */ boolean $anonfun$collectPropertiesDoc$2(Symbols.SymbolApi x$3) {
        return x$3.name().toString().startsWith("PROP_");
    }

    public static void $init$(H2OContextExtensions $this) {
    }
}

