/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.backend.external;

import ai.h2o.sparkling.H2OConf;
import ai.h2o.sparkling.backend.external.K8sUtils;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.Filterable;
import io.fabric8.kubernetes.client.dsl.Listable;
import io.fabric8.kubernetes.client.dsl.Nameable;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005aa\u0002\u0006\f!\u0003\r\tA\u0006\u0005\u0006C\u0001!\tA\t\u0005\u0006M\u0001!\tb\n\u0005\u0006\u0011\u0002!\t\"\u0013\u0005\u0006\u0019\u0002!I!\u0014\u0005\u0006!\u0002!I!\u0015\u0005\u0006?\u0002!I\u0001\u0019\u0005\u0006W\u0002!I\u0001\u001c\u0005\u0006c\u0002!IA\u001d\u0005\u0006o\u0002!I\u0001\u001f\u0002\u0012\u0017b\u001a\bJM(Ti\u0006$XMZ;m'\u0016$(B\u0001\u0007\u000e\u0003!)\u0007\u0010^3s]\u0006d'B\u0001\b\u0010\u0003\u001d\u0011\u0017mY6f]\u0012T!\u0001E\t\u0002\u0013M\u0004\u0018M]6mS:<'B\u0001\n\u0014\u0003\rA'g\u001c\u0006\u0002)\u0005\u0011\u0011-[\u0002\u0001'\r\u0001q#\b\t\u00031mi\u0011!\u0007\u0006\u00025\u0005)1oY1mC&\u0011A$\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005yyR\"A\u0006\n\u0005\u0001Z!\u0001C&9gV#\u0018\u000e\\:\u0002\r\u0011Jg.\u001b;%)\u0005\u0019\u0003C\u0001\r%\u0013\t)\u0013D\u0001\u0003V]&$\u0018!F5ogR\fG\u000e\u001c%3\u001fN#\u0018\r^3gk2\u001cV\r\u001e\u000b\u0005QM\u0002e\t\u0005\u0002*a9\u0011!F\f\t\u0003Wei\u0011\u0001\f\u0006\u0003[U\ta\u0001\u0010:p_Rt\u0014BA\u0018\u001a\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011G\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005=J\u0002\"\u0002\u001b\u0003\u0001\u0004)\u0014AB2mS\u0016tG\u000f\u0005\u00027}5\tqG\u0003\u00025q)\u0011\u0011HO\u0001\u000bWV\u0014WM\u001d8fi\u0016\u001c(BA\u001e=\u0003\u001d1\u0017M\u0019:jGbR\u0011!P\u0001\u0003S>L!aP\u001c\u0003!-+(-\u001a:oKR,7o\u00117jK:$\b\"B!\u0003\u0001\u0004\u0011\u0015\u0001B2p]\u001a\u0004\"a\u0011#\u000e\u0003=I!!R\b\u0003\u000f!\u0013tjQ8oM\")qI\u0001a\u0001Q\u0005\u0011\u0002.Z1eY\u0016\u001c8oU3sm&\u001cW-\u0016*M\u0003Q!W\r\\3uK\"\u0013tj\u0015;bi\u00164W\u000f\\*fiR\u00191ES&\t\u000bQ\u001a\u0001\u0019A\u001b\t\u000b\u0005\u001b\u0001\u0019\u0001\"\u0002/]\f\u0017\u000e\u001e$pe\u000ecWo\u001d;feR{')\u001a*fC\u0012LHc\u0001\u0015O\u001f\")A\u0007\u0002a\u0001k!)\u0011\t\u0002a\u0001\u0005\u0006)r-\u001a;Q_\u0012\u001chi\u001c:Ti\u0006$XMZ;m'\u0016$Hc\u0001*^=B\u0019\u0001dU+\n\u0005QK\"!B!se\u0006L\bC\u0001,\\\u001b\u00059&B\u0001-Z\u0003\u0015iw\u000eZ3m\u0015\tQ\u0006(A\u0002ba&L!\u0001X,\u0003\u0007A{G\rC\u00035\u000b\u0001\u0007Q\u0007C\u0003B\u000b\u0001\u0007!)A\td_:4XM\u001d;MC\n,G\u000eV8NCB$\"!Y5\u0011\t\t<\u0007\u0006K\u0007\u0002G*\u0011A-Z\u0001\u0005kRLGNC\u0001g\u0003\u0011Q\u0017M^1\n\u0005!\u001c'aA'ba\")!N\u0002a\u0001Q\u0005)A.\u00192fY\u0006iA.[:u%\u0016\fG-\u001f)pIN$BAU7pa\")an\u0002a\u0001%\u0006!\u0001o\u001c3t\u0011\u0015!t\u00011\u00016\u0011\u0015\tu\u00011\u0001C\u000319W\r\u001e(uQJ,\u0017\rZ3t)\t\u0019h\u000f\u0005\u0002\u0019i&\u0011Q/\u0007\u0002\u0004\u0013:$\b\"B!\t\u0001\u0004\u0011\u0015\u0001B:qK\u000e$2!\u001f@\u0000!\tQH0D\u0001|\u0015\tiT-\u0003\u0002~w\nY\u0011J\u001c9viN#(/Z1n\u0011\u0015\t\u0015\u00021\u0001C\u0011\u00159\u0015\u00021\u0001)\u0001")
public interface K8sH2OStatefulSet
extends K8sUtils {
    public static /* synthetic */ String installH2OStatefulSet$(K8sH2OStatefulSet $this, KubernetesClient client, H2OConf conf, String headlessServiceURL) {
        return $this.installH2OStatefulSet(client, conf, headlessServiceURL);
    }

    default public String installH2OStatefulSet(KubernetesClient client, H2OConf conf, String headlessServiceURL) {
        List resource = (List)client.load(this.spec(conf, headlessServiceURL)).get();
        client.resourceList((Collection)resource).createOrReplace();
        return this.waitForClusterToBeReady(client, conf);
    }

    public static /* synthetic */ void deleteH2OStatefulSet$(K8sH2OStatefulSet $this, KubernetesClient client, H2OConf conf) {
        $this.deleteH2OStatefulSet(client, conf);
    }

    default public void deleteH2OStatefulSet(KubernetesClient client, H2OConf conf) {
        ((Deletable)((Nameable)client.apps().statefulSets().inNamespace(conf.externalK8sNamespace())).withName(conf.externalK8sH2OStatefulsetName())).delete();
    }

    private String waitForClusterToBeReady(KubernetesClient client, H2OConf conf) {
        long start = System.currentTimeMillis();
        int timeout = conf.cloudTimeout();
        while (System.currentTimeMillis() - start < (long)timeout) {
            Pod[] readyPods;
            Pod[] currentPods = this.getPodsForStatefulSet(client, conf);
            if (currentPods.length == new StringOps(Predef$.MODULE$.augmentString((String)conf.clusterSize().get())).toInt() && (readyPods = this.listReadyPods(currentPods, client, conf)).length == 1) {
                return ((Pod)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])readyPods)).head()).getMetadata().getName();
            }
            Thread.sleep(100L);
        }
        throw new RuntimeException("Timeout during clouding of external H2O backend on K8s.");
    }

    private Pod[] getPodsForStatefulSet(KubernetesClient client, H2OConf conf) {
        return (Pod[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((PodList)((Listable)((Filterable)client.pods().inNamespace(conf.externalK8sNamespace())).withLabels(this.convertLabelToMap(conf.externalK8sH2OLabel()))).list()).getItems()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)K8sH2OStatefulSet.$anonfun$getPodsForStatefulSet$1(x$1)))).toArray(ClassTag$.MODULE$.apply(Pod.class));
    }

    private java.util.Map<String, String> convertLabelToMap(String label) {
        String[] split = label.split("=");
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)split[0]), (Object)split[1])}))).asJava();
    }

    private Pod[] listReadyPods(Pod[] pods, KubernetesClient client, H2OConf conf) {
        return (Pod[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pods)).filter((Function1 & Serializable & scala.Serializable)pod -> BoxesRunTime.boxToBoolean((boolean)K8sH2OStatefulSet.$anonfun$listReadyPods$1(client, conf, pod)));
    }

    private int getNthreades(H2OConf conf) {
        return conf.nthreads() > 0 ? conf.nthreads() : 1;
    }

    private InputStream spec(H2OConf conf, String headlessServiceURL) {
        String spec = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(1940).append("\n                  |apiVersion: apps/v1\n                  |kind: StatefulSet\n                  |metadata:\n                  |  name: ").append(conf.externalK8sH2OStatefulsetName()).append("\n                  |  namespace: ").append(conf.externalK8sNamespace()).append("\n                  |spec:\n                  |  serviceName: ").append(conf.externalK8sH2OServiceName()).append("\n                  |  podManagementPolicy: \"Parallel\"\n                  |  replicas: ").append(conf.clusterSize().get()).append("\n                  |  selector:\n                  |    matchLabels:\n                  |      ").append(this.convertLabel(conf.externalK8sH2OLabel())).append("\n                  |  template:\n                  |    metadata:\n                  |      labels:\n                  |        ").append(this.convertLabel(conf.externalK8sH2OLabel())).append("\n                  |    spec:\n                  |      terminationGracePeriodSeconds: 10\n                  |      containers:\n                  |        - name: ").append(conf.externalK8sH2OServiceName()).append("\n                  |          image: '").append(conf.externalK8sDockerImage()).append("'\n                  |          resources:\n                  |            requests:\n                  |              cpu: ").append(this.getNthreades(conf)).append("\n                  |              memory: \"").append(conf.externalMemory()).append("\"\n                  |            limits:\n                  |              cpu: ").append(this.getNthreades(conf)).append("\n                  |              memory: \"").append(conf.externalMemory()).append("\"\n                  |          ports:\n                  |            - containerPort: 54321\n                  |              protocol: TCP\n                  |          readinessProbe:\n                  |            httpGet:\n                  |              path: /kubernetes/isLeaderNode\n                  |              port: ").append(conf.externalK8sH2OApiPort()).append("\n                  |            initialDelaySeconds: 5\n                  |            periodSeconds: 5\n                  |            failureThreshold: 1\n                  |          env:\n                  |          - name: H2O_KUBERNETES_SERVICE_DNS\n                  |            value: ").append(headlessServiceURL).append("\n                  |          - name: H2O_NODE_LOOKUP_TIMEOUT\n                  |            value: '180'\n                  |          - name: H2O_NODE_EXPECTED_COUNT\n                  |            value: '").append(conf.clusterSize().get()).append("'\n                  |          - name: H2O_KUBERNETES_API_PORT\n                  |            value: '").append(conf.externalK8sH2OApiPort()).append("'").toString())).stripMargin();
        return new ByteArrayInputStream(spec.getBytes());
    }

    public static /* synthetic */ boolean $anonfun$getPodsForStatefulSet$1(Pod x$1) {
        String string = x$1.getStatus().getPhase();
        String string2 = "Running";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static /* synthetic */ boolean $anonfun$listReadyPods$1(KubernetesClient client$1, H2OConf conf$1, Pod pod) {
        PodResource newPod = (PodResource)((Nameable)client$1.pods().inNamespace(conf$1.externalK8sNamespace())).withName(pod.getMetadata().getName());
        return Predef$.MODULE$.Boolean2boolean(newPod.isReady()) && newPod.getLog().contains(new StringBuilder(24).append("Created cluster of size ").append(conf$1.clusterSize().get()).toString());
    }

    public static void $init$(K8sH2OStatefulSet $this) {
    }
}

