/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.backend.api.dataframes;

import ai.h2o.org.eclipse.jetty.servlet.ServletContextHandler;
import ai.h2o.sparkling.H2OConf;
import ai.h2o.sparkling.H2OContext;
import ai.h2o.sparkling.H2OContext$;
import ai.h2o.sparkling.H2OFrame;
import ai.h2o.sparkling.backend.api.ServletBase;
import ai.h2o.sparkling.backend.api.dataframes.DataFrameInfo;
import ai.h2o.sparkling.backend.api.dataframes.DataFrameInfo$DataFrameInfoParameters$;
import ai.h2o.sparkling.backend.api.dataframes.DataFrameToH2OFrame;
import ai.h2o.sparkling.backend.api.dataframes.DataFrameToH2OFrame$DataFrameToH2OFrameParameters$;
import ai.h2o.sparkling.backend.api.dataframes.DataFrames;
import ai.h2o.sparkling.backend.api.dataframes.DataFramesServlet$;
import ai.h2o.sparkling.utils.SparkSessionUtils$;
import java.io.Serializable;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import water.exceptions.H2ONotFoundArgumentException;

@ScalaSignature(bytes="\u0006\u0001\u00055c!B\b\u0011\u0001Ia\u0002\"B\u0016\u0001\t\u0003i\u0003\u0002\u0003\u0019\u0001\u0011\u000b\u0007I\u0011B\u0019\t\u000by\u0002A\u0011I \t\u000bA\u0003A\u0011I)\t\u000bQ\u0003A\u0011A+\t\u000be\u0003A\u0011\u0001.\t\u000b\u0005\u0004A\u0011\u00012\t\u000bA\u0004A\u0011A9\b\u000bm\u0004\u0002\u0012\u0001?\u0007\u000b=\u0001\u0002\u0012A?\t\r-RA\u0011AA\b\u0011\u001d\t\tB\u0003C)\u0003'Aq!a\u0006\u000b\t#\nI\u0002C\u0005\u0002:)\t\t\u0011\"\u0003\u0002<\t\tB)\u0019;b\rJ\fW.Z:TKJ4H.\u001a;\u000b\u0005E\u0011\u0012A\u00033bi\u00064'/Y7fg*\u00111\u0003F\u0001\u0004CBL'BA\u000b\u0017\u0003\u001d\u0011\u0017mY6f]\u0012T!a\u0006\r\u0002\u0013M\u0004\u0018M]6mS:<'BA\r\u001b\u0003\rA'g\u001c\u0006\u00027\u0005\u0011\u0011-[\n\u0004\u0001u9\u0003C\u0001\u0010&\u001b\u0005y\"B\u0001\u0011\"\u0003\u0011AG\u000f\u001e9\u000b\u0005\t\u001a\u0013aB:feZdW\r\u001e\u0006\u0002I\u0005)!.\u0019<bq&\u0011ae\b\u0002\f\u0011R$\boU3sm2,G\u000f\u0005\u0002)S5\t!#\u0003\u0002+%\tY1+\u001a:wY\u0016$()Y:f\u0003\u0019a\u0014N\\5u}\r\u0001A#\u0001\u0018\u0011\u0005=\u0002Q\"\u0001\t\u0002\u0015M\fHnQ8oi\u0016DH/F\u00013!\t\u0019D(D\u00015\u0015\t)d'A\u0002tc2T!a\u000e\u001d\u0002\u000bM\u0004\u0018M]6\u000b\u0005eR\u0014AB1qC\u000eDWMC\u0001<\u0003\ry'oZ\u0005\u0003{Q\u0012!bU)M\u0007>tG/\u001a=u\u0003\u0015!wnR3u)\r\u0001ei\u0013\t\u0003\u0003\u0012k\u0011A\u0011\u0006\u0002\u0007\u0006)1oY1mC&\u0011QI\u0011\u0002\u0005+:LG\u000fC\u0003H\u0007\u0001\u0007\u0001*A\u0002sKF\u0004\"AH%\n\u0005){\"A\u0005%uiB\u001cVM\u001d<mKR\u0014V-];fgRDQ\u0001T\u0002A\u00025\u000bAA]3taB\u0011aDT\u0005\u0003\u001f~\u00111\u0003\u0013;uaN+'O\u001e7fiJ+7\u000f]8og\u0016\fa\u0001Z8Q_N$Hc\u0001!S'\")q\t\u0002a\u0001\u0011\")A\n\u0002a\u0001\u001b\u0006!A.[:u)\u00051\u0006CA\u0018X\u0013\tA\u0006C\u0001\u0006ECR\fgI]1nKN\f\u0001BZ3uG\"\fE\u000e\u001c\u000b\u00027B\u0019\u0011\t\u00180\n\u0005u\u0013%!B!se\u0006L\bCA\u0018`\u0013\t\u0001\u0007CA\u0007ECR\fgI]1nK&sgm\\\u0001\rO\u0016$H)\u0019;b\rJ\fW.\u001a\u000b\u0003=\u000eDQ\u0001Z\u0004A\u0002\u0015\f1\u0002Z1uC\u001a\u0013\u0018-\\3JIB\u0011a-\u001c\b\u0003O.\u0004\"\u0001\u001b\"\u000e\u0003%T!A\u001b\u0017\u0002\rq\u0012xn\u001c;?\u0013\ta')\u0001\u0004Qe\u0016$WMZ\u0005\u0003]>\u0014aa\u0015;sS:<'B\u00017C\u0003)!x\u000e\u0013\u001aP\rJ\fW.\u001a\u000b\u0004eV4\bCA\u0018t\u0013\t!\bCA\nECR\fgI]1nKR{\u0007JM(Ge\u0006lW\rC\u0003e\u0011\u0001\u0007Q\rC\u0003x\u0011\u0001\u0007\u00010\u0001\u0006ie=4%/Y7f\u0013\u0012\u00042!Q=f\u0013\tQ(I\u0001\u0004PaRLwN\\\u0001\u0012\t\u0006$\u0018M\u0012:b[\u0016\u001c8+\u001a:wY\u0016$\bCA\u0018\u000b'\u0019Qa0a\u0001\u0002\nA\u0011\u0011i`\u0005\u0004\u0003\u0003\u0011%AB!osJ+g\rE\u0002)\u0003\u000bI1!a\u0002\u0013\u0005=\u0019VM\u001d<mKR\u0014VmZ5ti\u0016\u0014\bcA!\u0002\f%\u0019\u0011Q\u0002\"\u0003\u0019M+'/[1mSj\f'\r\\3\u0015\u0003q\fqbZ3u%\u0016\fX/Z:u!\u0006$\bn\u001d\u000b\u0003\u0003+\u00012!\u0011/f\u0003)9W\r^*feZdW\r\u001e\u000b\u0007\u00037\t\u0019#a\f\u0011\t\u0005u\u0011qD\u0007\u0002C%\u0019\u0011\u0011E\u0011\u0003\u000fM+'O\u001e7fi\"9\u0011QE\u0007A\u0002\u0005\u001d\u0012\u0001B2p]\u001a\u0004B!!\u000b\u0002,5\ta#C\u0002\u0002.Y\u0011q\u0001\u0013\u001aP\u0007>tg\rC\u0004\u000225\u0001\r!a\r\u0002\u0005!\u001c\u0007\u0003BA\u0015\u0003kI1!a\u000e\u0017\u0005)A%gT\"p]R,\u0007\u0010^\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002>A!\u0011qHA%\u001b\t\t\tE\u0003\u0003\u0002D\u0005\u0015\u0013\u0001\u00027b]\u001eT!!a\u0012\u0002\t)\fg/Y\u0005\u0005\u0003\u0017\n\tE\u0001\u0004PE*,7\r\u001e")
public class DataFramesServlet
extends HttpServlet
implements ServletBase {
    private SQLContext sqlContext;
    private volatile boolean bitmap$0;

    public static void register(ServletContextHandler servletContextHandler, H2OConf h2OConf, H2OContext h2OContext) {
        DataFramesServlet$.MODULE$.register(servletContextHandler, h2OConf, h2OContext);
    }

    @Override
    public void sendResult(Object obj, HttpServletResponse resp) {
        ServletBase.sendResult$(this, obj, resp);
    }

    private SQLContext sqlContext$lzycompute() {
        DataFramesServlet dataFramesServlet = this;
        synchronized (dataFramesServlet) {
            if (!this.bitmap$0) {
                this.sqlContext = SparkSessionUtils$.MODULE$.active().sqlContext();
                this.bitmap$0 = true;
            }
        }
        return this.sqlContext;
    }

    private SQLContext sqlContext() {
        return !this.bitmap$0 ? this.sqlContext$lzycompute() : this.sqlContext;
    }

    @Override
    public void doGet(HttpServletRequest req, HttpServletResponse resp) {
        String string = req.getPathInfo();
        if (string != null) {
            throw new H2ONotFoundArgumentException(new StringBuilder(17).append("Invalid endpoint ").append(string).toString());
        }
        DataFrames dataFrames = this.list();
        DataFrames obj = dataFrames;
        this.sendResult(obj, resp);
    }

    @Override
    public void doPost(HttpServletRequest req, HttpServletResponse resp) {
        Object object;
        String string = req.getPathInfo();
        if (string.matches("/.*/h2oframe")) {
            DataFrameToH2OFrame.DataFrameToH2OFrameParameters parameters = DataFrameToH2OFrame$DataFrameToH2OFrameParameters$.MODULE$.parse(req);
            parameters.validate();
            object = this.toH2OFrame(parameters.dataFrameId(), parameters.h2oFrameId());
        } else if (string.matches("/.*")) {
            DataFrameInfo.DataFrameInfoParameters parameters = DataFrameInfo$DataFrameInfoParameters$.MODULE$.parse(req);
            parameters.validate();
            object = this.getDataFrame(parameters.dataFrameId());
        } else {
            throw new H2ONotFoundArgumentException(new StringBuilder(17).append("Invalid endpoint ").append(string).toString());
        }
        DataFrameToH2OFrame obj = object;
        this.sendResult(obj, resp);
    }

    public DataFrames list() {
        return new DataFrames(this.fetchAll());
    }

    public DataFrameInfo[] fetchAll() {
        String[] names = this.sqlContext().tableNames();
        return (DataFrameInfo[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])names)).map((Function1 & Serializable & scala.Serializable)name -> this.getDataFrame((String)name), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataFrameInfo.class)));
    }

    public DataFrameInfo getDataFrame(String dataFrameId) {
        Dataset dataFrame = this.sqlContext().table(dataFrameId);
        return new DataFrameInfo(dataFrameId, dataFrame.rdd().partitions().length, dataFrame.schema().json());
    }

    public DataFrameToH2OFrame toH2OFrame(String dataFrameId, Option<String> h2oFrameId) {
        Dataset dataFrame = this.sqlContext().table(dataFrameId);
        H2OContext qual$1 = H2OContext$.MODULE$.ensure((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> H2OContext$.MODULE$.ensure$default$1());
        Dataset x$1 = dataFrame;
        Option<String> x$2 = h2oFrameId;
        Option<Seq<String>> x$3 = qual$1.asH2OFrame$default$3();
        H2OFrame h2oFrame = qual$1.asH2OFrame((Dataset<Row>)x$1, x$2, x$3);
        return new DataFrameToH2OFrame(dataFrameId, h2oFrame.frameId());
    }

    public DataFramesServlet() {
        ServletBase.$init$(this);
    }
}

