/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling;

import ai.h2o.sparkling.H2OContext;
import ai.h2o.sparkling.H2OContext$;
import ai.h2o.sparkling.H2OFrame;
import ai.h2o.sparkling.H2OFrame$;
import ai.h2o.sparkling.backend.H2OFrameRelation;
import java.io.Serializable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.CreatableRelationProvider;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.RelationProvider;
import org.apache.spark.sql.sources.SchemaRelationProvider;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.MatchError;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001m4Aa\u0002\u0005\u0001\u001f!)Q\u0006\u0001C\u0001]!)\u0011\u0007\u0001C!e!)a\b\u0001C\u0005\u007f!)Q\t\u0001C!\r\")Q\t\u0001C!#\")Q\t\u0001C!E\niA)\u001a4bk2$8k\\;sG\u0016T!!\u0003\u0006\u0002\u0013M\u0004\u0018M]6mS:<'BA\u0006\r\u0003\rA'g\u001c\u0006\u0002\u001b\u0005\u0011\u0011-[\u0002\u0001'\u0019\u0001\u0001C\u0006\u0013(UA\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001a\u0004\"a\u0006\u0012\u000e\u0003aQ!!\u0007\u000e\u0002\u000fM|WO]2fg*\u00111\u0004H\u0001\u0004gFd'BA\u000f\u001f\u0003\u0015\u0019\b/\u0019:l\u0015\ty\u0002%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002C\u0005\u0019qN]4\n\u0005\rB\"\u0001\u0005*fY\u0006$\u0018n\u001c8Qe>4\u0018\u000eZ3s!\t9R%\u0003\u0002'1\t12k\u00195f[\u0006\u0014V\r\\1uS>t\u0007K]8wS\u0012,'\u000f\u0005\u0002\u0018Q%\u0011\u0011\u0006\u0007\u0002\u001a\u0007J,\u0017\r^1cY\u0016\u0014V\r\\1uS>t\u0007K]8wS\u0012,'\u000f\u0005\u0002\u0018W%\u0011A\u0006\u0007\u0002\u0013\t\u0006$\u0018mU8ve\u000e,'+Z4jgR,'/\u0001\u0004=S:LGO\u0010\u000b\u0002_A\u0011\u0001\u0007A\u0007\u0002\u0011\u0005I1\u000f[8si:\u000bW.\u001a\u000b\u0002gA\u0011Ag\u000f\b\u0003ke\u0002\"A\u000e\n\u000e\u0003]R!\u0001\u000f\b\u0002\rq\u0012xn\u001c;?\u0013\tQ$#\u0001\u0004Qe\u0016$WMZ\u0005\u0003yu\u0012aa\u0015;sS:<'B\u0001\u001e\u0013\u0003!\u0019\u0007.Z2l\u0017\u0016LHCA\u001aA\u0011\u0015\t5\u00011\u0001C\u0003)\u0001\u0018M]1nKR,'o\u001d\t\u0005i\r\u001b4'\u0003\u0002E{\t\u0019Q*\u00199\u0002\u001d\r\u0014X-\u0019;f%\u0016d\u0017\r^5p]R\u0019qI\u0013)\u0011\u0005]A\u0015BA%\u0019\u00051\u0011\u0015m]3SK2\fG/[8o\u0011\u0015YE\u00011\u0001M\u0003)\u0019\u0018\u000f\\\"p]R,\u0007\u0010\u001e\t\u0003\u001b:k\u0011AG\u0005\u0003\u001fj\u0011!bU)M\u0007>tG/\u001a=u\u0011\u0015\tE\u00011\u0001C)\u0011\u0011\u0006,\u0017.\u0011\u0005M3V\"\u0001+\u000b\u0005UC\u0011a\u00022bG.,g\u000eZ\u0005\u0003/R\u0013\u0001\u0003\u0013\u001aP\rJ\fW.\u001a*fY\u0006$\u0018n\u001c8\t\u000b-+\u0001\u0019\u0001'\t\u000b\u0005+\u0001\u0019\u0001\"\t\u000bm+\u0001\u0019\u0001/\u0002\rM\u001c\u0007.Z7b!\ti\u0006-D\u0001_\u0015\ty&$A\u0003usB,7/\u0003\u0002b=\nQ1\u000b\u001e:vGR$\u0016\u0010]3\u0015\u000b\u001d\u001bG-\u001b6\t\u000b-3\u0001\u0019\u0001'\t\u000b\u00154\u0001\u0019\u00014\u0002\t5|G-\u001a\t\u0003\u001b\u001eL!\u0001\u001b\u000e\u0003\u0011M\u000bg/Z'pI\u0016DQ!\u0011\u0004A\u0002\tCQa\u001b\u0004A\u00021\fA\u0001Z1uCB\u0011Q\u000e\u001f\b\u0003]Zt!a\\;\u000f\u0005A$hBA9t\u001d\t1$/C\u0001\"\u0013\ty\u0002%\u0003\u0002\u001e=%\u00111\u0004H\u0005\u0003oj\tq\u0001]1dW\u0006<W-\u0003\u0002zu\nIA)\u0019;b\rJ\fW.\u001a\u0006\u0003oj\u0001")
public class DefaultSource
implements RelationProvider,
SchemaRelationProvider,
CreatableRelationProvider,
DataSourceRegister {
    public String shortName() {
        return "h2o";
    }

    private String checkKey(Map<String, String> parameters) {
        return (String)parameters.getOrElse((Object)"key", (Function0 & Serializable & scala.Serializable)() -> (String)parameters.getOrElse((Object)"path", (Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.error("'key' must be specified for H2O Frame.")));
    }

    public BaseRelation createRelation(SQLContext sqlContext, Map<String, String> parameters) {
        return this.createRelation(sqlContext, (Map)parameters, (StructType)null);
    }

    public H2OFrameRelation createRelation(SQLContext sqlContext, Map<String, String> parameters, StructType schema) {
        String key = this.checkKey(parameters);
        return new H2OFrameRelation(H2OFrame$.MODULE$.apply(key), true, sqlContext);
    }

    public BaseRelation createRelation(SQLContext sqlContext, SaveMode mode, Map<String, String> parameters, Dataset<Row> data) {
        H2OFrame h2OFrame;
        String key = this.checkKey(parameters);
        H2OContext hc = H2OContext$.MODULE$.ensure((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "H2OContext has to be started in order to save/load data using H2O Data source.");
        if (H2OFrame$.MODULE$.exists(key)) {
            H2OFrame h2OFrame2;
            H2OFrame originalFrame = H2OFrame$.MODULE$.apply(key);
            SaveMode saveMode = mode;
            if (SaveMode.Append.equals(saveMode)) {
                throw package$.MODULE$.error("Appending to H2O Frame is not supported.");
            }
            if (SaveMode.Overwrite.equals(saveMode)) {
                originalFrame.delete();
                h2OFrame2 = hc.asH2OFrame(data, key);
            } else {
                if (SaveMode.ErrorIfExists.equals(saveMode)) {
                    throw package$.MODULE$.error(new StringBuilder(91).append("Frame with key '").append(key).append("' already exists, if you want to override it set the save mode to override.").toString());
                }
                if (SaveMode.Ignore.equals(saveMode)) {
                    h2OFrame2 = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)saveMode);
                }
            }
            h2OFrame = h2OFrame2;
        } else {
            h2OFrame = hc.asH2OFrame(data, key);
        }
        return this.createRelation(sqlContext, (Map)parameters, data.schema());
    }
}

