/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.eclipse.jetty.websocket.client;

import ai.h2o.org.eclipse.jetty.client.HttpClient;
import ai.h2o.org.eclipse.jetty.io.ByteBufferPool;
import ai.h2o.org.eclipse.jetty.io.MappedByteBufferPool;
import ai.h2o.org.eclipse.jetty.util.DecoratedObjectFactory;
import ai.h2o.org.eclipse.jetty.util.StringUtil;
import ai.h2o.org.eclipse.jetty.util.component.ContainerLifeCycle;
import ai.h2o.org.eclipse.jetty.util.log.Log;
import ai.h2o.org.eclipse.jetty.util.log.Logger;
import ai.h2o.org.eclipse.jetty.util.ssl.SslContextFactory;
import ai.h2o.org.eclipse.jetty.util.thread.Scheduler;
import ai.h2o.org.eclipse.jetty.util.thread.ShutdownThread;
import ai.h2o.org.eclipse.jetty.websocket.api.Session;
import ai.h2o.org.eclipse.jetty.websocket.api.WebSocketBehavior;
import ai.h2o.org.eclipse.jetty.websocket.api.WebSocketPolicy;
import ai.h2o.org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import ai.h2o.org.eclipse.jetty.websocket.api.extensions.ExtensionFactory;
import ai.h2o.org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import ai.h2o.org.eclipse.jetty.websocket.client.HttpClientProvider;
import ai.h2o.org.eclipse.jetty.websocket.client.WebSocketUpgradeRequest;
import ai.h2o.org.eclipse.jetty.websocket.client.io.ConnectionManager;
import ai.h2o.org.eclipse.jetty.websocket.client.io.UpgradeListener;
import ai.h2o.org.eclipse.jetty.websocket.client.masks.Masker;
import ai.h2o.org.eclipse.jetty.websocket.client.masks.RandomMasker;
import ai.h2o.org.eclipse.jetty.websocket.common.SessionFactory;
import ai.h2o.org.eclipse.jetty.websocket.common.WebSocketSession;
import ai.h2o.org.eclipse.jetty.websocket.common.WebSocketSessionFactory;
import ai.h2o.org.eclipse.jetty.websocket.common.events.EventDriverFactory;
import ai.h2o.org.eclipse.jetty.websocket.common.extensions.WebSocketExtensionFactory;
import ai.h2o.org.eclipse.jetty.websocket.common.scopes.DelegatedContainerScope;
import ai.h2o.org.eclipse.jetty.websocket.common.scopes.SimpleContainerScope;
import ai.h2o.org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;
import java.io.IOException;
import java.net.CookieStore;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;

public class WebSocketClient
extends ContainerLifeCycle
implements WebSocketContainerScope {
    private static final Logger LOG = Log.getLogger(WebSocketClient.class);
    private final HttpClient httpClient;
    private final WebSocketContainerScope containerScope;
    private final WebSocketExtensionFactory extensionRegistry;
    private final EventDriverFactory eventDriverFactory;
    private final SessionFactory sessionFactory;
    private final int id = ThreadLocalRandom.current().nextInt();
    private boolean stopAtShutdown = true;

    public WebSocketClient() {
        this(HttpClientProvider.get(null));
        this.addBean(this.httpClient);
    }

    public WebSocketClient(HttpClient httpClient) {
        this(httpClient, new DecoratedObjectFactory());
    }

    public WebSocketClient(HttpClient httpClient, DecoratedObjectFactory objectFactory) {
        this.containerScope = new SimpleContainerScope(WebSocketPolicy.newClientPolicy(), new MappedByteBufferPool(), objectFactory);
        this.httpClient = httpClient;
        this.extensionRegistry = new WebSocketExtensionFactory(this.containerScope);
        this.eventDriverFactory = new EventDriverFactory(this.containerScope);
        this.sessionFactory = new WebSocketSessionFactory(this.containerScope);
    }

    @Deprecated
    public WebSocketClient(Executor executor) {
        this(null, executor);
    }

    public WebSocketClient(ByteBufferPool bufferPool) {
        this(null, null, bufferPool);
    }

    public WebSocketClient(SslContextFactory sslContextFactory) {
        this(sslContextFactory, null);
    }

    @Deprecated
    public WebSocketClient(SslContextFactory sslContextFactory, Executor executor) {
        this(sslContextFactory, executor, new MappedByteBufferPool());
    }

    public WebSocketClient(WebSocketContainerScope scope) {
        this(scope.getSslContextFactory(), scope.getExecutor(), scope.getBufferPool(), scope.getObjectFactory());
    }

    public WebSocketClient(WebSocketContainerScope scope, SslContextFactory sslContextFactory) {
        this(sslContextFactory, scope.getExecutor(), scope.getBufferPool(), scope.getObjectFactory());
    }

    public WebSocketClient(SslContextFactory sslContextFactory, Executor executor, ByteBufferPool bufferPool) {
        this(sslContextFactory, executor, bufferPool, new DecoratedObjectFactory());
    }

    private WebSocketClient(SslContextFactory sslContextFactory, Executor executor, ByteBufferPool bufferPool, DecoratedObjectFactory objectFactory) {
        this.httpClient = new HttpClient(sslContextFactory);
        this.httpClient.setExecutor(executor);
        this.httpClient.setByteBufferPool(bufferPool);
        this.addBean(this.httpClient);
        this.containerScope = new SimpleContainerScope(WebSocketPolicy.newClientPolicy(), bufferPool, objectFactory);
        this.extensionRegistry = new WebSocketExtensionFactory(this.containerScope);
        this.eventDriverFactory = new EventDriverFactory(this.containerScope);
        this.sessionFactory = new WebSocketSessionFactory(this.containerScope);
    }

    public WebSocketClient(WebSocketContainerScope scope, EventDriverFactory eventDriverFactory, SessionFactory sessionFactory) {
        this(scope, eventDriverFactory, sessionFactory, null);
    }

    public WebSocketClient(WebSocketContainerScope scope, EventDriverFactory eventDriverFactory, SessionFactory sessionFactory, HttpClient httpClient) {
        WebSocketContainerScope clientScope = scope.getPolicy().getBehavior() == WebSocketBehavior.CLIENT ? scope : new DelegatedContainerScope(WebSocketPolicy.newClientPolicy(), scope);
        this.containerScope = clientScope;
        if (httpClient == null) {
            this.httpClient = HttpClientProvider.get(scope);
            this.addBean(this.httpClient);
        } else {
            this.httpClient = httpClient;
        }
        this.extensionRegistry = new WebSocketExtensionFactory(this.containerScope);
        this.eventDriverFactory = eventDriverFactory;
        this.sessionFactory = sessionFactory;
    }

    public Future<Session> connect(Object websocket, URI toUri) throws IOException {
        ClientUpgradeRequest request = new ClientUpgradeRequest(toUri);
        request.setRequestURI(toUri);
        request.setLocalEndpoint(websocket);
        return this.connect(websocket, toUri, request);
    }

    public Future<Session> connect(Object websocket, URI toUri, ClientUpgradeRequest request) throws IOException {
        return this.connect(websocket, toUri, request, null);
    }

    public Future<Session> connect(Object websocket, URI toUri, ClientUpgradeRequest request, UpgradeListener upgradeListener) throws IOException {
        if (!this.isStarted()) {
            throw new IllegalStateException(WebSocketClient.class.getSimpleName() + "@" + this.hashCode() + " is not started");
        }
        if (!toUri.isAbsolute()) {
            throw new IllegalArgumentException("WebSocket URI must be absolute");
        }
        if (StringUtil.isBlank(toUri.getScheme())) {
            throw new IllegalArgumentException("WebSocket URI must include a scheme");
        }
        String scheme = toUri.getScheme().toLowerCase(Locale.ENGLISH);
        if (!"ws".equals(scheme) && !"wss".equals(scheme)) {
            throw new IllegalArgumentException("WebSocket URI scheme only supports [ws] and [wss], not [" + scheme + "]");
        }
        if ("wss".equals(scheme) && this.httpClient.getSslContextFactory() == null) {
            throw new IllegalStateException("HttpClient has no SslContextFactory, wss:// URI's are not supported in this configuration");
        }
        request.setRequestURI(toUri);
        request.setLocalEndpoint(websocket);
        for (ExtensionConfig reqExt : request.getExtensions()) {
            if (this.extensionRegistry.isAvailable(reqExt.getName())) continue;
            throw new IllegalArgumentException("Requested extension [" + reqExt.getName() + "] is not installed");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("connect websocket {} to {}", websocket, toUri);
        }
        this.init();
        WebSocketUpgradeRequest wsReq = new WebSocketUpgradeRequest(this, this.httpClient, request);
        wsReq.setUpgradeListener(upgradeListener);
        return wsReq.sendAsync();
    }

    @Override
    protected void doStart() throws Exception {
        Objects.requireNonNull(this.httpClient, "Provided HttpClient is null");
        super.doStart();
        if (!this.httpClient.isRunning()) {
            throw new IllegalStateException("HttpClient is not running (did you forget to start it?): " + this.httpClient);
        }
    }

    @Override
    protected void doStop() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stopping {}", this);
        }
        ShutdownThread.deregister(this);
        super.doStop();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stopped {}", this);
        }
    }

    @Deprecated
    public boolean isDispatchIO() {
        return this.httpClient.isDispatchIO();
    }

    public long getAsyncWriteTimeout() {
        return this.containerScope.getPolicy().getAsyncWriteTimeout();
    }

    public SocketAddress getBindAddress() {
        return this.httpClient.getBindAddress();
    }

    @Override
    public ByteBufferPool getBufferPool() {
        return this.httpClient.getByteBufferPool();
    }

    @Deprecated
    public ConnectionManager getConnectionManager() {
        throw new UnsupportedOperationException("ConnectionManager is no longer supported");
    }

    public long getConnectTimeout() {
        return this.httpClient.getConnectTimeout();
    }

    public CookieStore getCookieStore() {
        return this.httpClient.getCookieStore();
    }

    public EventDriverFactory getEventDriverFactory() {
        return this.eventDriverFactory;
    }

    @Override
    public Executor getExecutor() {
        return this.httpClient.getExecutor();
    }

    public ExtensionFactory getExtensionFactory() {
        return this.extensionRegistry;
    }

    @Deprecated
    public Masker getMasker() {
        return new RandomMasker();
    }

    public int getMaxBinaryMessageBufferSize() {
        return this.getPolicy().getMaxBinaryMessageBufferSize();
    }

    public long getMaxBinaryMessageSize() {
        return this.getPolicy().getMaxBinaryMessageSize();
    }

    public long getMaxIdleTimeout() {
        return this.getPolicy().getIdleTimeout();
    }

    public int getMaxTextMessageBufferSize() {
        return this.getPolicy().getMaxTextMessageBufferSize();
    }

    public long getMaxTextMessageSize() {
        return this.getPolicy().getMaxTextMessageSize();
    }

    @Override
    public DecoratedObjectFactory getObjectFactory() {
        return this.containerScope.getObjectFactory();
    }

    public Set<WebSocketSession> getOpenSessions() {
        return Collections.unmodifiableSet(new HashSet<WebSocketSession>(this.getBeans(WebSocketSession.class)));
    }

    @Override
    public WebSocketPolicy getPolicy() {
        return this.containerScope.getPolicy();
    }

    public Scheduler getScheduler() {
        return this.httpClient.getScheduler();
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public SslContextFactory getSslContextFactory() {
        return this.httpClient.getSslContextFactory();
    }

    private synchronized void init() throws IOException {
        if (this.isStopAtShutdown() && !ShutdownThread.isRegistered(this)) {
            ShutdownThread.register(this);
        }
    }

    @Deprecated
    protected ConnectionManager newConnectionManager() {
        throw new UnsupportedOperationException("ConnectionManager is no longer supported");
    }

    @Override
    public void onSessionClosed(WebSocketSession session) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Session Closed: {}", session);
        }
        this.removeBean(session);
    }

    @Override
    public void onSessionOpened(WebSocketSession session) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Session Opened: {}", session);
        }
        this.addManaged(session);
        LOG.debug("post-onSessionOpened() - {}", this);
    }

    public void setAsyncWriteTimeout(long ms) {
        this.getPolicy().setAsyncWriteTimeout(ms);
    }

    @Deprecated
    public void setBindAdddress(SocketAddress bindAddress) {
        this.setBindAddress(bindAddress);
    }

    public void setBindAddress(SocketAddress bindAddress) {
        this.httpClient.setBindAddress(bindAddress);
    }

    public void setBufferPool(ByteBufferPool bufferPool) {
        this.httpClient.setByteBufferPool(bufferPool);
    }

    public void setConnectTimeout(long ms) {
        this.httpClient.setConnectTimeout(ms);
    }

    public void setCookieStore(CookieStore cookieStore) {
        this.httpClient.setCookieStore(cookieStore);
    }

    @Deprecated
    public void setDaemon(boolean daemon) {
    }

    @Deprecated
    public void setDispatchIO(boolean dispatchIO) {
        this.httpClient.setDispatchIO(dispatchIO);
    }

    public void setExecutor(Executor executor) {
        this.httpClient.setExecutor(executor);
    }

    @Deprecated
    public void setMasker(Masker masker) {
    }

    public void setMaxBinaryMessageBufferSize(int max) {
        this.getPolicy().setMaxBinaryMessageBufferSize(max);
    }

    public void setMaxIdleTimeout(long ms) {
        this.getPolicy().setIdleTimeout(ms);
        this.httpClient.setIdleTimeout(ms);
    }

    public void setMaxTextMessageBufferSize(int max) {
        this.getPolicy().setMaxTextMessageBufferSize(max);
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        this.dumpThis(out);
        WebSocketClient.dump(out, indent, this.getOpenSessions());
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public synchronized void setStopAtShutdown(boolean stop) {
        if (stop) {
            if (!this.stopAtShutdown && this.isStarted() && !ShutdownThread.isRegistered(this)) {
                ShutdownThread.register(this);
            }
        } else {
            ShutdownThread.deregister(this);
        }
        this.stopAtShutdown = stop;
    }

    public boolean isStopAtShutdown() {
        return this.stopAtShutdown;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WebSocketClient@");
        sb.append(Integer.toHexString(this.id));
        sb.append("[httpClient=").append(this.httpClient);
        sb.append(",openSessions.size=");
        sb.append(this.getOpenSessions().size());
        sb.append(']');
        return sb.toString();
    }
}

