/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.eclipse.jetty.util.component;

import ai.h2o.org.eclipse.jetty.util.MultiException;
import ai.h2o.org.eclipse.jetty.util.annotation.ManagedObject;
import ai.h2o.org.eclipse.jetty.util.annotation.ManagedOperation;
import ai.h2o.org.eclipse.jetty.util.component.AbstractLifeCycle;
import ai.h2o.org.eclipse.jetty.util.component.Container;
import ai.h2o.org.eclipse.jetty.util.component.Destroyable;
import ai.h2o.org.eclipse.jetty.util.component.Dumpable;
import ai.h2o.org.eclipse.jetty.util.component.LifeCycle;
import ai.h2o.org.eclipse.jetty.util.log.Log;
import ai.h2o.org.eclipse.jetty.util.log.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

@ManagedObject(value="Implementation of Container and LifeCycle")
public class ContainerLifeCycle
extends AbstractLifeCycle
implements Container,
Destroyable,
Dumpable {
    private static final Logger LOG = Log.getLogger(ContainerLifeCycle.class);
    private final List<Bean> _beans = new CopyOnWriteArrayList<Bean>();
    private final List<Container.Listener> _listeners = new CopyOnWriteArrayList<Container.Listener>();
    private boolean _doStarted;
    private boolean _destroyed;

    @Override
    protected void doStart() throws Exception {
        if (this._destroyed) {
            throw new IllegalStateException("Destroyed container cannot be restarted");
        }
        this._doStarted = true;
        for (Bean b2 : this._beans) {
            if (!(b2._bean instanceof LifeCycle)) continue;
            LifeCycle l2 = (LifeCycle)b2._bean;
            switch (b2._managed) {
                case MANAGED: {
                    if (l2.isRunning()) break;
                    this.start(l2);
                    break;
                }
                case AUTO: {
                    if (l2.isRunning()) {
                        this.unmanage(b2);
                        break;
                    }
                    this.manage(b2);
                    this.start(l2);
                    break;
                }
            }
        }
        super.doStart();
    }

    protected void start(LifeCycle l2) throws Exception {
        l2.start();
    }

    protected void stop(LifeCycle l2) throws Exception {
        l2.stop();
    }

    @Override
    protected void doStop() throws Exception {
        this._doStarted = false;
        super.doStop();
        ArrayList<Bean> reverse = new ArrayList<Bean>(this._beans);
        Collections.reverse(reverse);
        MultiException mex = new MultiException();
        for (Bean b2 : reverse) {
            if (b2._managed != Managed.MANAGED || !(b2._bean instanceof LifeCycle)) continue;
            LifeCycle l2 = (LifeCycle)b2._bean;
            try {
                this.stop(l2);
            }
            catch (Throwable th) {
                mex.add(th);
            }
        }
        mex.ifExceptionThrow();
    }

    @Override
    public void destroy() {
        this._destroyed = true;
        ArrayList<Bean> reverse = new ArrayList<Bean>(this._beans);
        Collections.reverse(reverse);
        for (Bean b2 : reverse) {
            if (!(b2._bean instanceof Destroyable) || b2._managed != Managed.MANAGED && b2._managed != Managed.POJO) continue;
            Destroyable d2 = (Destroyable)b2._bean;
            try {
                d2.destroy();
            }
            catch (Throwable th) {
                LOG.warn(th);
            }
        }
        this._beans.clear();
    }

    public boolean contains(Object bean) {
        for (Bean b2 : this._beans) {
            if (b2._bean != bean) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isManaged(Object bean) {
        for (Bean b2 : this._beans) {
            if (b2._bean != bean) continue;
            return b2.isManaged();
        }
        return false;
    }

    @Override
    public boolean addBean(Object o2) {
        if (o2 instanceof LifeCycle) {
            LifeCycle l2 = (LifeCycle)o2;
            return this.addBean(o2, l2.isRunning() ? Managed.UNMANAGED : Managed.AUTO);
        }
        return this.addBean(o2, Managed.POJO);
    }

    @Override
    public boolean addBean(Object o2, boolean managed) {
        if (o2 instanceof LifeCycle) {
            return this.addBean(o2, managed ? Managed.MANAGED : Managed.UNMANAGED);
        }
        return this.addBean(o2, managed ? Managed.POJO : Managed.UNMANAGED);
    }

    public boolean addBean(Object o2, Managed managed) {
        if (o2 == null || this.contains(o2)) {
            return false;
        }
        Bean new_bean = new Bean(o2);
        if (o2 instanceof Container.Listener) {
            this.addEventListener((Container.Listener)o2);
        }
        this._beans.add(new_bean);
        for (Container.Listener l2 : this._listeners) {
            l2.beanAdded(this, o2);
        }
        try {
            switch (managed) {
                case UNMANAGED: {
                    this.unmanage(new_bean);
                    break;
                }
                case MANAGED: {
                    this.manage(new_bean);
                    if (!this.isStarting() || !this._doStarted) break;
                    LifeCycle l3 = (LifeCycle)o2;
                    if (!l3.isRunning()) {
                        this.start(l3);
                    }
                    break;
                }
                case AUTO: {
                    LifeCycle l3;
                    if (o2 instanceof LifeCycle) {
                        l3 = (LifeCycle)o2;
                        if (this.isStarting()) {
                            if (l3.isRunning()) {
                                this.unmanage(new_bean);
                                break;
                            }
                            if (this._doStarted) {
                                this.manage(new_bean);
                                this.start(l3);
                                break;
                            }
                            new_bean._managed = Managed.AUTO;
                            break;
                        }
                        if (this.isStarted()) {
                            this.unmanage(new_bean);
                            break;
                        }
                        new_bean._managed = Managed.AUTO;
                        break;
                    }
                    new_bean._managed = Managed.POJO;
                    break;
                }
                case POJO: {
                    new_bean._managed = Managed.POJO;
                }
            }
        }
        catch (Error | RuntimeException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new RuntimeException(e3);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} added {}", this, new_bean);
        }
        return true;
    }

    public void addManaged(LifeCycle lifecycle) {
        this.addBean((Object)lifecycle, true);
        try {
            if (this.isRunning() && !lifecycle.isRunning()) {
                this.start(lifecycle);
            }
        }
        catch (Error | RuntimeException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new RuntimeException(e3);
        }
    }

    @Override
    public void addEventListener(Container.Listener listener) {
        if (this._listeners.contains(listener)) {
            return;
        }
        this._listeners.add(listener);
        for (Bean b2 : this._beans) {
            listener.beanAdded(this, b2._bean);
            if (!(listener instanceof Container.InheritedListener) || !b2.isManaged() || !(b2._bean instanceof Container)) continue;
            if (b2._bean instanceof ContainerLifeCycle) {
                ((ContainerLifeCycle)b2._bean).addBean((Object)listener, false);
                continue;
            }
            ((Container)b2._bean).addBean(listener);
        }
    }

    @Override
    public void manage(Object bean) {
        for (Bean b2 : this._beans) {
            if (b2._bean != bean) continue;
            this.manage(b2);
            return;
        }
        throw new IllegalArgumentException("Unknown bean " + bean);
    }

    private void manage(Bean bean) {
        if (bean._managed != Managed.MANAGED) {
            bean._managed = Managed.MANAGED;
            if (bean._bean instanceof Container) {
                for (Container.Listener l2 : this._listeners) {
                    if (!(l2 instanceof Container.InheritedListener)) continue;
                    if (bean._bean instanceof ContainerLifeCycle) {
                        ((ContainerLifeCycle)bean._bean).addBean((Object)l2, false);
                        continue;
                    }
                    ((Container)bean._bean).addBean(l2);
                }
            }
            if (bean._bean instanceof AbstractLifeCycle) {
                ((AbstractLifeCycle)bean._bean).setStopTimeout(this.getStopTimeout());
            }
        }
    }

    @Override
    public void unmanage(Object bean) {
        for (Bean b2 : this._beans) {
            if (b2._bean != bean) continue;
            this.unmanage(b2);
            return;
        }
        throw new IllegalArgumentException("Unknown bean " + bean);
    }

    private void unmanage(Bean bean) {
        if (bean._managed != Managed.UNMANAGED) {
            if (bean._managed == Managed.MANAGED && bean._bean instanceof Container) {
                for (Container.Listener l2 : this._listeners) {
                    if (!(l2 instanceof Container.InheritedListener)) continue;
                    ((Container)bean._bean).removeBean(l2);
                }
            }
            bean._managed = Managed.UNMANAGED;
        }
    }

    @Override
    public Collection<Object> getBeans() {
        return this.getBeans(Object.class);
    }

    public void setBeans(Collection<Object> beans) {
        for (Object bean : beans) {
            this.addBean(bean);
        }
    }

    @Override
    public <T> Collection<T> getBeans(Class<T> clazz) {
        ArrayList<T> beans = new ArrayList<T>();
        for (Bean b2 : this._beans) {
            if (!clazz.isInstance(b2._bean)) continue;
            beans.add(clazz.cast(b2._bean));
        }
        return beans;
    }

    @Override
    public <T> T getBean(Class<T> clazz) {
        for (Bean b2 : this._beans) {
            if (!clazz.isInstance(b2._bean)) continue;
            return clazz.cast(b2._bean);
        }
        return null;
    }

    public void removeBeans() {
        ArrayList<Bean> beans = new ArrayList<Bean>(this._beans);
        for (Bean b2 : beans) {
            this.remove(b2);
        }
    }

    private Bean getBean(Object o2) {
        for (Bean b2 : this._beans) {
            if (b2._bean != o2) continue;
            return b2;
        }
        return null;
    }

    @Override
    public boolean removeBean(Object o2) {
        Bean b2 = this.getBean(o2);
        return b2 != null && this.remove(b2);
    }

    private boolean remove(Bean bean) {
        if (this._beans.remove(bean)) {
            boolean wasManaged = bean.isManaged();
            this.unmanage(bean);
            for (Container.Listener l2 : this._listeners) {
                l2.beanRemoved(this, bean._bean);
            }
            if (bean._bean instanceof Container.Listener) {
                this.removeEventListener((Container.Listener)bean._bean);
            }
            if (wasManaged && bean._bean instanceof LifeCycle) {
                try {
                    this.stop((LifeCycle)bean._bean);
                }
                catch (Error | RuntimeException e2) {
                    throw e2;
                }
                catch (Exception e3) {
                    throw new RuntimeException(e3);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void removeEventListener(Container.Listener listener) {
        if (this._listeners.remove(listener)) {
            for (Bean b2 : this._beans) {
                listener.beanRemoved(this, b2._bean);
                if (!(listener instanceof Container.InheritedListener) || !b2.isManaged() || !(b2._bean instanceof Container)) continue;
                ((Container)b2._bean).removeBean(listener);
            }
        }
    }

    @Override
    public void setStopTimeout(long stopTimeout) {
        super.setStopTimeout(stopTimeout);
        for (Bean bean : this._beans) {
            if (!bean.isManaged() || !(bean._bean instanceof AbstractLifeCycle)) continue;
            ((AbstractLifeCycle)bean._bean).setStopTimeout(stopTimeout);
        }
    }

    @ManagedOperation(value="Dump the object to stderr")
    public void dumpStdErr() {
        try {
            this.dump(System.err, "");
        }
        catch (IOException e2) {
            LOG.warn(e2);
        }
    }

    @Override
    @ManagedOperation(value="Dump the object to a string")
    public String dump() {
        return ContainerLifeCycle.dump(this);
    }

    public static String dump(Dumpable dumpable) {
        StringBuilder b2 = new StringBuilder();
        try {
            dumpable.dump(b2, "");
        }
        catch (IOException e2) {
            LOG.warn(e2);
        }
        return b2.toString();
    }

    public void dump(Appendable out) throws IOException {
        this.dump(out, "");
    }

    protected void dumpThis(Appendable out) throws IOException {
        out.append(String.valueOf(this)).append(" - ").append(this.getState()).append("\n");
    }

    public static void dumpObject(Appendable out, Object o2) throws IOException {
        try {
            if (o2 instanceof LifeCycle) {
                out.append(String.valueOf(o2)).append(" - ").append(AbstractLifeCycle.getState((LifeCycle)o2)).append("\n");
            } else {
                out.append(String.valueOf(o2)).append("\n");
            }
        }
        catch (Throwable th) {
            out.append(" => ").append(th.toString()).append('\n');
        }
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        this.dumpBeans(out, indent, new Collection[0]);
    }

    protected void dumpBeans(Appendable out, String indent, Collection<?> ... collections) throws IOException {
        this.dumpThis(out);
        int size = this._beans.size();
        for (Collection<?> c2 : collections) {
            size += c2.size();
        }
        int i2 = 0;
        for (Bean b2 : this._beans) {
            ++i2;
            switch (b2._managed) {
                case POJO: {
                    out.append(indent).append(" +- ");
                    if (b2._bean instanceof Dumpable) {
                        ((Dumpable)b2._bean).dump(out, indent + (i2 == size ? "    " : " |  "));
                        break;
                    }
                    ContainerLifeCycle.dumpObject(out, b2._bean);
                    break;
                }
                case MANAGED: {
                    out.append(indent).append(" += ");
                    if (b2._bean instanceof Dumpable) {
                        ((Dumpable)b2._bean).dump(out, indent + (i2 == size ? "    " : " |  "));
                        break;
                    }
                    ContainerLifeCycle.dumpObject(out, b2._bean);
                    break;
                }
                case UNMANAGED: {
                    out.append(indent).append(" +~ ");
                    ContainerLifeCycle.dumpObject(out, b2._bean);
                    break;
                }
                case AUTO: {
                    out.append(indent).append(" +? ");
                    if (b2._bean instanceof Dumpable) {
                        ((Dumpable)b2._bean).dump(out, indent + (i2 == size ? "    " : " |  "));
                        break;
                    }
                    ContainerLifeCycle.dumpObject(out, b2._bean);
                }
            }
        }
        for (Collection<?> c3 : collections) {
            for (Object o2 : c3) {
                ++i2;
                out.append(indent).append(" +> ");
                if (o2 instanceof Dumpable) {
                    ((Dumpable)o2).dump(out, indent + (i2 == size ? "    " : " |  "));
                    continue;
                }
                ContainerLifeCycle.dumpObject(out, o2);
            }
        }
    }

    public static void dump(Appendable out, String indent, Collection<?> ... collections) throws IOException {
        if (collections.length == 0) {
            return;
        }
        int size = 0;
        for (Collection<?> c2 : collections) {
            size += c2.size();
        }
        if (size == 0) {
            return;
        }
        int i2 = 0;
        for (Collection<?> c3 : collections) {
            for (Object o2 : c3) {
                ++i2;
                out.append(indent).append(" +- ");
                if (o2 instanceof Dumpable) {
                    ((Dumpable)o2).dump(out, indent + (i2 == size ? "    " : " |  "));
                    continue;
                }
                ContainerLifeCycle.dumpObject(out, o2);
            }
        }
    }

    public void updateBean(Object oldBean, Object newBean) {
        if (newBean != oldBean) {
            if (oldBean != null) {
                this.removeBean(oldBean);
            }
            if (newBean != null) {
                this.addBean(newBean);
            }
        }
    }

    public void updateBean(Object oldBean, Object newBean, boolean managed) {
        if (newBean != oldBean) {
            if (oldBean != null) {
                this.removeBean(oldBean);
            }
            if (newBean != null) {
                this.addBean(newBean, managed);
            }
        }
    }

    public void updateBeans(Object[] oldBeans, Object[] newBeans) {
        if (oldBeans != null) {
            block0: for (Object o2 : oldBeans) {
                if (newBeans != null) {
                    for (Object n2 : newBeans) {
                        if (o2 == n2) continue block0;
                    }
                }
                this.removeBean(o2);
            }
        }
        if (newBeans != null) {
            block2: for (Object n3 : newBeans) {
                if (oldBeans != null) {
                    for (Object o3 : oldBeans) {
                        if (o3 == n3) continue block2;
                    }
                }
                this.addBean(n3);
            }
        }
    }

    @Override
    public <T> Collection<T> getContainedBeans(Class<T> clazz) {
        HashSet beans = new HashSet();
        this.getContainedBeans(clazz, beans);
        return beans;
    }

    protected <T> void getContainedBeans(Class<T> clazz, Collection<T> beans) {
        beans.addAll(this.getBeans(clazz));
        for (Container c2 : this.getBeans(Container.class)) {
            Bean bean = this.getBean(c2);
            if (bean == null || !bean.isManageable()) continue;
            if (c2 instanceof ContainerLifeCycle) {
                ((ContainerLifeCycle)c2).getContainedBeans(clazz, beans);
                continue;
            }
            beans.addAll(c2.getContainedBeans(clazz));
        }
    }

    private static class Bean {
        private final Object _bean;
        private volatile Managed _managed = Managed.POJO;

        private Bean(Object b2) {
            if (b2 == null) {
                throw new NullPointerException();
            }
            this._bean = b2;
        }

        public boolean isManaged() {
            return this._managed == Managed.MANAGED;
        }

        public boolean isManageable() {
            switch (this._managed) {
                case MANAGED: {
                    return true;
                }
                case AUTO: {
                    return this._bean instanceof LifeCycle && ((LifeCycle)this._bean).isStopped();
                }
            }
            return false;
        }

        public String toString() {
            return String.format("{%s,%s}", new Object[]{this._bean, this._managed});
        }
    }

    static enum Managed {
        POJO,
        MANAGED,
        UNMANAGED,
        AUTO;

    }
}

