/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.eclipse.jetty.util;

import ai.h2o.org.eclipse.jetty.util.AbstractTrie;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TreeTrie<V>
extends AbstractTrie<V> {
    private static final int[] __lookup = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 31, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26, -1, 27, 30, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 28, 29, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1};
    private static final int INDEX = 32;
    private final TreeTrie<V>[] _nextIndex;
    private final List<TreeTrie<V>> _nextOther = new ArrayList<TreeTrie<V>>();
    private final char _c;
    private String _key;
    private V _value;

    public TreeTrie() {
        super(true);
        this._nextIndex = new TreeTrie[32];
        this._c = '\u0000';
    }

    private TreeTrie(char c2) {
        super(true);
        this._nextIndex = new TreeTrie[32];
        this._c = c2;
    }

    @Override
    public void clear() {
        Arrays.fill(this._nextIndex, null);
        this._nextOther.clear();
        this._key = null;
        this._value = null;
    }

    @Override
    public boolean put(String s2, V v2) {
        TreeTrie<V> t2 = this;
        int limit = s2.length();
        for (int k2 = 0; k2 < limit; ++k2) {
            int index;
            char c2 = s2.charAt(k2);
            int n2 = index = c2 >= '\u0000' && c2 < '\u007f' ? __lookup[c2] : -1;
            if (index >= 0) {
                if (t2._nextIndex[index] == null) {
                    t2._nextIndex[index] = new TreeTrie<V>(c2);
                }
                t2 = t2._nextIndex[index];
                continue;
            }
            TreeTrie<V> n3 = null;
            int i2 = t2._nextOther.size();
            while (i2-- > 0) {
                n3 = t2._nextOther.get(i2);
                if (n3._c == c2) break;
                n3 = null;
            }
            if (n3 == null) {
                n3 = new TreeTrie<V>(c2);
                t2._nextOther.add(n3);
            }
            t2 = n3;
        }
        t2._key = v2 == null ? null : s2;
        t2._value = v2;
        return true;
    }

    @Override
    public V get(String s2, int offset, int len) {
        TreeTrie<V> t2 = this;
        for (int i2 = 0; i2 < len; ++i2) {
            int index;
            char c2 = s2.charAt(offset + i2);
            int n2 = index = c2 >= '\u0000' && c2 < '\u007f' ? __lookup[c2] : -1;
            if (index >= 0) {
                if (t2._nextIndex[index] == null) {
                    return null;
                }
                t2 = t2._nextIndex[index];
                continue;
            }
            TreeTrie<V> n3 = null;
            int j2 = t2._nextOther.size();
            while (j2-- > 0) {
                n3 = t2._nextOther.get(j2);
                if (n3._c == c2) break;
                n3 = null;
            }
            if (n3 == null) {
                return null;
            }
            t2 = n3;
        }
        return t2._value;
    }

    @Override
    public V get(ByteBuffer b2, int offset, int len) {
        TreeTrie<V> t2 = this;
        for (int i2 = 0; i2 < len; ++i2) {
            int index;
            byte c2 = b2.get(offset + i2);
            int n2 = index = c2 >= 0 && c2 < 127 ? __lookup[c2] : -1;
            if (index >= 0) {
                if (t2._nextIndex[index] == null) {
                    return null;
                }
                t2 = t2._nextIndex[index];
                continue;
            }
            TreeTrie<V> n3 = null;
            int j2 = t2._nextOther.size();
            while (j2-- > 0) {
                n3 = t2._nextOther.get(j2);
                if (n3._c == c2) break;
                n3 = null;
            }
            if (n3 == null) {
                return null;
            }
            t2 = n3;
        }
        return t2._value;
    }

    @Override
    public V getBest(byte[] b2, int offset, int len) {
        TreeTrie<V> t2 = this;
        for (int i2 = 0; i2 < len; ++i2) {
            int index;
            byte c2 = b2[offset + i2];
            int n2 = index = c2 >= 0 && c2 < 127 ? __lookup[c2] : -1;
            if (index >= 0) {
                if (t2._nextIndex[index] == null) break;
                t2 = t2._nextIndex[index];
            } else {
                TreeTrie<V> n3 = null;
                int j2 = t2._nextOther.size();
                while (j2-- > 0) {
                    n3 = t2._nextOther.get(j2);
                    if (n3._c == c2) break;
                    n3 = null;
                }
                if (n3 == null) break;
                t2 = n3;
            }
            if (t2._key == null) continue;
            V best = t2.getBest(b2, offset + i2 + 1, len - i2 - 1);
            if (best == null) break;
            return best;
        }
        return t2._value;
    }

    @Override
    public V getBest(String s2, int offset, int len) {
        TreeTrie<V> t2 = this;
        for (int i2 = 0; i2 < len; ++i2) {
            int index;
            byte c2 = (byte)(0xFF & s2.charAt(offset + i2));
            int n2 = index = c2 >= 0 && c2 < 127 ? __lookup[c2] : -1;
            if (index >= 0) {
                if (t2._nextIndex[index] == null) break;
                t2 = t2._nextIndex[index];
            } else {
                TreeTrie<V> n3 = null;
                int j2 = t2._nextOther.size();
                while (j2-- > 0) {
                    n3 = t2._nextOther.get(j2);
                    if (n3._c == c2) break;
                    n3 = null;
                }
                if (n3 == null) break;
                t2 = n3;
            }
            if (t2._key == null) continue;
            V best = t2.getBest(s2, offset + i2 + 1, len - i2 - 1);
            if (best == null) break;
            return best;
        }
        return t2._value;
    }

    @Override
    public V getBest(ByteBuffer b2, int offset, int len) {
        if (b2.hasArray()) {
            return this.getBest(b2.array(), b2.arrayOffset() + b2.position() + offset, len);
        }
        return this.getBestByteBuffer(b2, offset, len);
    }

    private V getBestByteBuffer(ByteBuffer b2, int offset, int len) {
        TreeTrie<V> t2 = this;
        int pos = b2.position() + offset;
        for (int i2 = 0; i2 < len; ++i2) {
            byte c2;
            int index;
            int n2 = index = (c2 = b2.get(pos++)) >= 0 && c2 < 127 ? __lookup[c2] : -1;
            if (index >= 0) {
                if (t2._nextIndex[index] == null) break;
                t2 = t2._nextIndex[index];
            } else {
                TreeTrie<V> n3 = null;
                int j2 = t2._nextOther.size();
                while (j2-- > 0) {
                    n3 = t2._nextOther.get(j2);
                    if (n3._c == c2) break;
                    n3 = null;
                }
                if (n3 == null) break;
                t2 = n3;
            }
            if (t2._key == null) continue;
            V best = t2.getBest(b2, offset + i2 + 1, len - i2 - 1);
            if (best == null) break;
            return best;
        }
        return t2._value;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        TreeTrie.toString(buf, this);
        if (buf.length() == 0) {
            return "{}";
        }
        buf.setCharAt(0, '{');
        buf.append('}');
        return buf.toString();
    }

    private static <V> void toString(Appendable out, TreeTrie<V> t2) {
        if (t2 != null) {
            int i2;
            if (t2._value != null) {
                try {
                    out.append(',');
                    out.append(t2._key);
                    out.append('=');
                    out.append(t2._value.toString());
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
            for (i2 = 0; i2 < 32; ++i2) {
                if (t2._nextIndex[i2] == null) continue;
                TreeTrie.toString(out, t2._nextIndex[i2]);
            }
            i2 = t2._nextOther.size();
            while (i2-- > 0) {
                TreeTrie.toString(out, t2._nextOther.get(i2));
            }
        }
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keys = new HashSet<String>();
        TreeTrie.keySet(keys, this);
        return keys;
    }

    private static <V> void keySet(Set<String> set, TreeTrie<V> t2) {
        if (t2 != null) {
            int i2;
            if (t2._key != null) {
                set.add(t2._key);
            }
            for (i2 = 0; i2 < 32; ++i2) {
                if (t2._nextIndex[i2] == null) continue;
                TreeTrie.keySet(set, t2._nextIndex[i2]);
            }
            i2 = t2._nextOther.size();
            while (i2-- > 0) {
                TreeTrie.keySet(set, t2._nextOther.get(i2));
            }
        }
    }

    @Override
    public boolean isFull() {
        return false;
    }
}

