/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.eclipse.jetty.util;

import ai.h2o.org.eclipse.jetty.util.AbstractTrie;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ArrayTrie<V>
extends AbstractTrie<V> {
    private static final int ROW_SIZE = 32;
    private static final int[] __lookup = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 31, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26, -1, 27, 30, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 28, 29, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1};
    private final char[] _rowIndex;
    private final String[] _key;
    private final V[] _value;
    private char[][] _bigIndex;
    private char _rows;

    public ArrayTrie() {
        this(128);
    }

    public ArrayTrie(int capacity) {
        super(true);
        this._value = new Object[capacity];
        this._rowIndex = new char[capacity * 32];
        this._key = new String[capacity];
    }

    @Override
    public void clear() {
        this._rows = '\u0000';
        Arrays.fill(this._value, null);
        Arrays.fill(this._rowIndex, '\u0000');
        Arrays.fill(this._key, null);
    }

    @Override
    public boolean put(String s2, V v2) {
        int t2 = 0;
        int limit = s2.length();
        for (int k2 = 0; k2 < limit; ++k2) {
            char c2 = s2.charAt(k2);
            int index = __lookup[c2 & 0x7F];
            if (index >= 0) {
                int idx = t2 * 32 + index;
                if ((t2 = this._rowIndex[idx]) != 0) continue;
                this._rows = (char)(this._rows + '\u0001');
                if (this._rows >= this._value.length) {
                    return false;
                }
                this._rowIndex[idx] = this._rows;
                t2 = this._rowIndex[idx];
                continue;
            }
            if (c2 > '\u007f') {
                throw new IllegalArgumentException("non ascii character");
            }
            if (this._bigIndex == null) {
                this._bigIndex = new char[this._value.length][];
            }
            if (t2 >= this._bigIndex.length) {
                return false;
            }
            char[] big = this._bigIndex[t2];
            if (big == null) {
                this._bigIndex[t2] = new char[128];
                big = this._bigIndex[t2];
            }
            if ((t2 = big[c2]) != 0) continue;
            if (this._rows == this._value.length) {
                return false;
            }
            big[c2] = this._rows = (char)(this._rows + '\u0001');
            t2 = this._rows;
        }
        if (t2 >= this._key.length) {
            this._rows = (char)this._key.length;
            return false;
        }
        this._key[t2] = v2 == null ? null : s2;
        this._value[t2] = v2;
        return true;
    }

    @Override
    public V get(String s2, int offset, int len) {
        int t2 = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            char[] big;
            char c2 = s2.charAt(offset + i2);
            int index = __lookup[c2 & 0x7F];
            if (index >= 0) {
                int idx = t2 * 32 + index;
                if ((t2 = this._rowIndex[idx]) != 0) continue;
                return null;
            }
            char[] cArray = big = this._bigIndex == null ? null : this._bigIndex[t2];
            if (big == null) {
                return null;
            }
            t2 = big[c2];
            if (t2 != 0) continue;
            return null;
        }
        return this._value[t2];
    }

    @Override
    public V get(ByteBuffer b2, int offset, int len) {
        int t2 = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            char[] big;
            byte c2 = b2.get(offset + i2);
            int index = __lookup[c2 & 0x7F];
            if (index >= 0) {
                int idx = t2 * 32 + index;
                if ((t2 = this._rowIndex[idx]) != 0) continue;
                return null;
            }
            char[] cArray = big = this._bigIndex == null ? null : this._bigIndex[t2];
            if (big == null) {
                return null;
            }
            t2 = big[c2];
            if (t2 != 0) continue;
            return null;
        }
        return this._value[t2];
    }

    @Override
    public V getBest(byte[] b2, int offset, int len) {
        return this.getBest(0, b2, offset, len);
    }

    @Override
    public V getBest(ByteBuffer b2, int offset, int len) {
        if (b2.hasArray()) {
            return this.getBest(0, b2.array(), b2.arrayOffset() + b2.position() + offset, len);
        }
        return this.getBest(0, b2, offset, len);
    }

    @Override
    public V getBest(String s2, int offset, int len) {
        return this.getBest(0, s2, offset, len);
    }

    private V getBest(int t2, String s2, int offset, int len) {
        int pos = offset;
        for (int i2 = 0; i2 < len; ++i2) {
            int nt;
            char c2;
            int index;
            if ((index = __lookup[(c2 = s2.charAt(pos++)) & 0x7F]) >= 0) {
                int idx = t2 * 32 + index;
                nt = this._rowIndex[idx];
                if (nt == 0) break;
                t2 = nt;
            } else {
                char[] big;
                char[] cArray = big = this._bigIndex == null ? null : this._bigIndex[t2];
                if (big == null) {
                    return null;
                }
                nt = big[c2];
                if (nt == 0) break;
                t2 = nt;
            }
            if (this._key[t2] == null) continue;
            V best = this.getBest(t2, s2, offset + i2 + 1, len - i2 - 1);
            if (best != null) {
                return best;
            }
            return this._value[t2];
        }
        return this._value[t2];
    }

    private V getBest(int t2, byte[] b2, int offset, int len) {
        for (int i2 = 0; i2 < len; ++i2) {
            int nt;
            byte c2 = b2[offset + i2];
            int index = __lookup[c2 & 0x7F];
            if (index >= 0) {
                int idx = t2 * 32 + index;
                nt = this._rowIndex[idx];
                if (nt == 0) break;
                t2 = nt;
            } else {
                char[] big;
                char[] cArray = big = this._bigIndex == null ? null : this._bigIndex[t2];
                if (big == null) {
                    return null;
                }
                nt = big[c2];
                if (nt == 0) break;
                t2 = nt;
            }
            if (this._key[t2] == null) continue;
            V best = this.getBest(t2, b2, offset + i2 + 1, len - i2 - 1);
            if (best == null) break;
            return best;
        }
        return this._value[t2];
    }

    private V getBest(int t2, ByteBuffer b2, int offset, int len) {
        int pos = b2.position() + offset;
        for (int i2 = 0; i2 < len; ++i2) {
            int nt;
            byte c2;
            int index;
            if ((index = __lookup[(c2 = b2.get(pos++)) & 0x7F]) >= 0) {
                int idx = t2 * 32 + index;
                nt = this._rowIndex[idx];
                if (nt == 0) break;
                t2 = nt;
            } else {
                char[] big;
                char[] cArray = big = this._bigIndex == null ? null : this._bigIndex[t2];
                if (big == null) {
                    return null;
                }
                nt = big[c2];
                if (nt == 0) break;
                t2 = nt;
            }
            if (this._key[t2] == null) continue;
            V best = this.getBest(t2, b2, offset + i2 + 1, len - i2 - 1);
            if (best == null) break;
            return best;
        }
        return this._value[t2];
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.toString(buf, 0);
        if (buf.length() == 0) {
            return "{}";
        }
        buf.setCharAt(0, '{');
        buf.append('}');
        return buf.toString();
    }

    private void toString(Appendable out, int t2) {
        char[] big;
        if (this._value[t2] != null) {
            try {
                out.append(',');
                out.append(this._key[t2]);
                out.append('=');
                out.append(this._value[t2].toString());
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }
        for (int i2 = 0; i2 < 32; ++i2) {
            int idx = t2 * 32 + i2;
            if (this._rowIndex[idx] == '\u0000') continue;
            this.toString(out, this._rowIndex[idx]);
        }
        char[] cArray = big = this._bigIndex == null ? null : this._bigIndex[t2];
        if (big != null) {
            for (char i3 : big) {
                if (i3 == '\u0000') continue;
                this.toString(out, i3);
            }
        }
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keys = new HashSet<String>();
        this.keySet(keys, 0);
        return keys;
    }

    private void keySet(Set<String> set, int t2) {
        char[] big;
        if (t2 < this._value.length && this._value[t2] != null) {
            set.add(this._key[t2]);
        }
        for (int i2 = 0; i2 < 32; ++i2) {
            int idx = t2 * 32 + i2;
            if (idx >= this._rowIndex.length || this._rowIndex[idx] == '\u0000') continue;
            this.keySet(set, this._rowIndex[idx]);
        }
        char[] cArray = big = this._bigIndex == null || t2 >= this._bigIndex.length ? null : this._bigIndex[t2];
        if (big != null) {
            for (char i3 : big) {
                if (i3 == '\u0000') continue;
                this.keySet(set, i3);
            }
        }
    }

    @Override
    public boolean isFull() {
        return this._rows + '\u0001' >= this._key.length;
    }
}

