/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.apache.http.impl.cookie;

import ai.h2o.org.apache.http.annotation.Contract;
import ai.h2o.org.apache.http.annotation.ThreadingBehavior;
import ai.h2o.org.apache.http.cookie.CommonCookieAttributeHandler;
import ai.h2o.org.apache.http.cookie.Cookie;
import ai.h2o.org.apache.http.cookie.CookieOrigin;
import ai.h2o.org.apache.http.cookie.CookieRestrictionViolationException;
import ai.h2o.org.apache.http.cookie.MalformedCookieException;
import ai.h2o.org.apache.http.cookie.SetCookie;
import ai.h2o.org.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import ai.h2o.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RFC2109VersionHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        if (value.trim().isEmpty()) {
            throw new MalformedCookieException("Blank value for version attribute");
        }
        try {
            cookie.setVersion(Integer.parseInt(value));
        }
        catch (NumberFormatException e2) {
            throw new MalformedCookieException("Invalid version: " + e2.getMessage());
        }
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (cookie.getVersion() < 0) {
            throw new CookieRestrictionViolationException("Cookie version may not be negative");
        }
    }

    @Override
    public String getAttributeName() {
        return "version";
    }
}

