/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.apache.http.conn.util;

import ai.h2o.org.apache.http.annotation.Contract;
import ai.h2o.org.apache.http.annotation.ThreadingBehavior;
import ai.h2o.org.apache.http.conn.util.DomainType;
import ai.h2o.org.apache.http.conn.util.PublicSuffixList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public final class PublicSuffixListParser {
    public PublicSuffixList parse(Reader reader) throws IOException {
        String line;
        ArrayList<String> rules = new ArrayList<String>();
        ArrayList<String> exceptions2 = new ArrayList<String>();
        BufferedReader r2 = new BufferedReader(reader);
        while ((line = r2.readLine()) != null) {
            boolean isException;
            if (line.isEmpty() || line.startsWith("//")) continue;
            if (line.startsWith(".")) {
                line = line.substring(1);
            }
            if (isException = line.startsWith("!")) {
                line = line.substring(1);
            }
            if (isException) {
                exceptions2.add(line);
                continue;
            }
            rules.add(line);
        }
        return new PublicSuffixList(DomainType.UNKNOWN, rules, exceptions2);
    }

    public List<PublicSuffixList> parseByType(Reader reader) throws IOException {
        String line;
        ArrayList<PublicSuffixList> result = new ArrayList<PublicSuffixList>(2);
        BufferedReader r2 = new BufferedReader(reader);
        StringBuilder sb = new StringBuilder(256);
        DomainType domainType = null;
        ArrayList<String> rules = null;
        ArrayList<String> exceptions2 = null;
        while ((line = r2.readLine()) != null) {
            boolean isException;
            if (line.isEmpty()) continue;
            if (line.startsWith("//")) {
                if (domainType == null) {
                    if (line.contains("===BEGIN ICANN DOMAINS===")) {
                        domainType = DomainType.ICANN;
                        continue;
                    }
                    if (!line.contains("===BEGIN PRIVATE DOMAINS===")) continue;
                    domainType = DomainType.PRIVATE;
                    continue;
                }
                if (!line.contains("===END ICANN DOMAINS===") && !line.contains("===END PRIVATE DOMAINS===")) continue;
                if (rules != null) {
                    result.add(new PublicSuffixList(domainType, rules, exceptions2));
                }
                domainType = null;
                rules = null;
                exceptions2 = null;
                continue;
            }
            if (domainType == null) continue;
            if (line.startsWith(".")) {
                line = line.substring(1);
            }
            if (isException = line.startsWith("!")) {
                line = line.substring(1);
            }
            if (isException) {
                if (exceptions2 == null) {
                    exceptions2 = new ArrayList<String>();
                }
                exceptions2.add(line);
                continue;
            }
            if (rules == null) {
                rules = new ArrayList<String>();
            }
            rules.add(line);
        }
        return result;
    }
}

