/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.apache.http.client.protocol;

import ai.h2o.org.apache.http.HttpEntity;
import ai.h2o.org.apache.http.HttpEntityEnclosingRequest;
import ai.h2o.org.apache.http.HttpException;
import ai.h2o.org.apache.http.HttpRequest;
import ai.h2o.org.apache.http.HttpRequestInterceptor;
import ai.h2o.org.apache.http.HttpVersion;
import ai.h2o.org.apache.http.ProtocolVersion;
import ai.h2o.org.apache.http.annotation.Contract;
import ai.h2o.org.apache.http.annotation.ThreadingBehavior;
import ai.h2o.org.apache.http.client.config.RequestConfig;
import ai.h2o.org.apache.http.client.protocol.HttpClientContext;
import ai.h2o.org.apache.http.protocol.HttpContext;
import ai.h2o.org.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

