/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.apache.http.client.entity;

import ai.h2o.org.apache.http.HttpEntity;
import ai.h2o.org.apache.http.NameValuePair;
import ai.h2o.org.apache.http.client.entity.GzipCompressingEntity;
import ai.h2o.org.apache.http.client.entity.UrlEncodedFormEntity;
import ai.h2o.org.apache.http.entity.AbstractHttpEntity;
import ai.h2o.org.apache.http.entity.BasicHttpEntity;
import ai.h2o.org.apache.http.entity.ByteArrayEntity;
import ai.h2o.org.apache.http.entity.ContentType;
import ai.h2o.org.apache.http.entity.FileEntity;
import ai.h2o.org.apache.http.entity.InputStreamEntity;
import ai.h2o.org.apache.http.entity.SerializableEntity;
import ai.h2o.org.apache.http.entity.StringEntity;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

public class EntityBuilder {
    private String text;
    private byte[] binary;
    private InputStream stream;
    private List<NameValuePair> parameters;
    private Serializable serializable;
    private File file;
    private ContentType contentType;
    private String contentEncoding;
    private boolean chunked;
    private boolean gzipCompress;

    EntityBuilder() {
    }

    public static EntityBuilder create() {
        return new EntityBuilder();
    }

    private void clearContent() {
        this.text = null;
        this.binary = null;
        this.stream = null;
        this.parameters = null;
        this.serializable = null;
        this.file = null;
    }

    public String getText() {
        return this.text;
    }

    public EntityBuilder setText(String text) {
        this.clearContent();
        this.text = text;
        return this;
    }

    public byte[] getBinary() {
        return this.binary;
    }

    public EntityBuilder setBinary(byte[] binary) {
        this.clearContent();
        this.binary = binary;
        return this;
    }

    public InputStream getStream() {
        return this.stream;
    }

    public EntityBuilder setStream(InputStream stream) {
        this.clearContent();
        this.stream = stream;
        return this;
    }

    public List<NameValuePair> getParameters() {
        return this.parameters;
    }

    public EntityBuilder setParameters(List<NameValuePair> parameters) {
        this.clearContent();
        this.parameters = parameters;
        return this;
    }

    public EntityBuilder setParameters(NameValuePair ... parameters) {
        return this.setParameters(Arrays.asList(parameters));
    }

    public Serializable getSerializable() {
        return this.serializable;
    }

    public EntityBuilder setSerializable(Serializable serializable) {
        this.clearContent();
        this.serializable = serializable;
        return this;
    }

    public File getFile() {
        return this.file;
    }

    public EntityBuilder setFile(File file) {
        this.clearContent();
        this.file = file;
        return this;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public EntityBuilder setContentType(ContentType contentType) {
        this.contentType = contentType;
        return this;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public EntityBuilder setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
    }

    public boolean isChunked() {
        return this.chunked;
    }

    public EntityBuilder chunked() {
        this.chunked = true;
        return this;
    }

    public boolean isGzipCompress() {
        return this.gzipCompress;
    }

    public EntityBuilder gzipCompress() {
        this.gzipCompress = true;
        return this;
    }

    private ContentType getContentOrDefault(ContentType def) {
        return this.contentType != null ? this.contentType : def;
    }

    public HttpEntity build() {
        AbstractHttpEntity e2;
        if (this.text != null) {
            e2 = new StringEntity(this.text, this.getContentOrDefault(ContentType.DEFAULT_TEXT));
        } else if (this.binary != null) {
            e2 = new ByteArrayEntity(this.binary, this.getContentOrDefault(ContentType.DEFAULT_BINARY));
        } else if (this.stream != null) {
            e2 = new InputStreamEntity(this.stream, -1L, this.getContentOrDefault(ContentType.DEFAULT_BINARY));
        } else if (this.parameters != null) {
            e2 = new UrlEncodedFormEntity(this.parameters, this.contentType != null ? this.contentType.getCharset() : null);
        } else if (this.serializable != null) {
            e2 = new SerializableEntity(this.serializable);
            e2.setContentType(ContentType.DEFAULT_BINARY.toString());
        } else {
            e2 = this.file != null ? new FileEntity(this.file, this.getContentOrDefault(ContentType.DEFAULT_BINARY)) : new BasicHttpEntity();
        }
        if (e2.getContentType() != null && this.contentType != null) {
            e2.setContentType(this.contentType.toString());
        }
        e2.setContentEncoding(this.contentEncoding);
        e2.setChunked(this.chunked);
        if (this.gzipCompress) {
            return new GzipCompressingEntity(e2);
        }
        return e2;
    }
}

