/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.utils;

import ai.h2o.mojos.runtime.utils.Consts;
import ai.h2o.mojos.runtime.utils.MojoDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;

public class DateParser {
    private final DateTimeFormatter _dtf;
    static String[] USER_DEFINED_FORMATS = Consts.getSysProp("date.formats", "").split(",");
    public static final String[] SUPPORTED_FORMATS = new String[]{"M[M]/d[d]/yyyy[' ']['T'][' ']h[h]:mm:ss[' ']a", "M[M]/d[d]/yyyy[' ']['T'][' ']h[h]:mm:ss.SSS[' ']a", "M[M]/d[d]/yyyy[' ']['T'][' ']H[H]:mm:ss", "M[M]/d[d]/yyyy[' ']['T'][' ']H[H]:mm:ss.SSS", "M[M]/d[d]/yyyy", "M[M]-d[d]-yyyy[' ']['T'][' ']h[h]:mm:ss[' ']a", "M[M]-d[d]-yyyy[' ']['T'][' ']h[h]:mm:ss.SSS[' ']a", "M[M]-d[d]-yyyy[' ']['T'][' ']H[H]:mm:ss", "M[M]-d[d]-yyyy[' ']['T'][' ']H[H]:mm:ss.SSS", "M[M]-d[d]-yyyy", "d[d].M[M].yyyy[' ']['T'][' ']h[h]:mm:ss[' ']a", "d[d].M[M].yyyy[' ']['T'][' ']h[h]:mm:ss.SSS[' ']a", "d[d].M[M].yyyy[' ']['T'][' ']H[H]:mm:ss", "d[d].M[M].yyyy[' ']['T'][' ']H[H]:mm:ss.SSS", "d[d].M[M].yyyy", "yyyy/M[M]/d[d]' 'HH:mm:ss", "yyyy/M[M]/d[d]' 'HH:mm:ss.SSS", "yyyy/M[M]/d[d]", "yyyy-M[M]-d[d]' 'HH:mm:ss", "yyyy-M[M]-d[d]' 'HH:mm:ss.SSS", "yyyy-M[M]-d[d]'T'HH:mm:ss.SSSSSSSSS", "yyyyMMdd", "yyyy-M[M]-d[d]", "h[h]:mm:ss[' ']a", "h[h]:mm:ss.SSS[' ']a", "H[H]:mm:ss", "H[H]:mm:ss.SSS", "h[h]:mm[' ']a", "H[H]:mm"};
    public static DateTimeFormatter DTF;

    public DateParser(DateTimeParser dtp) {
        this(dtp, true);
    }

    public DateParser(DateTimeParser dtp, boolean useDefaultAsBackup) {
        this._dtf = useDefaultAsBackup ? new DateTimeFormatterBuilder().append(null, new DateTimeParser[]{dtp, DTF.getParser()}).toFormatter() : new DateTimeFormatter(null, dtp);
    }

    public MojoDateTime parse(String s2) {
        return MojoDateTime.create(this._dtf.withZone(MojoDateTime.TIMEZONE).parseDateTime(s2));
    }

    public MojoDateTime parseOrNull(String s2) {
        try {
            return this.parse(s2);
        }
        catch (IllegalArgumentException e2) {
            return null;
        }
    }

    static DateTimeParser[] toFormatter(List<String> formats) {
        List<String> expandedFormats = DateParser.expandFormats(formats);
        DateTimeParser[] result = new DateTimeParser[expandedFormats.size()];
        int i2 = 0;
        for (String f2 : expandedFormats) {
            result[i2++] = DateTimeFormat.forPattern(f2).getParser();
        }
        return result;
    }

    static List<String> expandFormats(List<String> formats) {
        ArrayList<String> expandedFormats = new ArrayList<String>();
        for (String format : formats) {
            DateParser.expandFormat(new StringBuilder(format), 0, expandedFormats);
        }
        return expandedFormats;
    }

    static void expandFormat(StringBuilder format, int startIdx, List<String> result) {
        StringBuilder prefix = new StringBuilder();
        String suffix = null;
        int openGroupIdx = -1;
        int closeGroupIdx = -1;
        int openingCnt = 0;
        for (int i2 = startIdx; i2 < format.length(); ++i2) {
            char c2 = format.charAt(i2);
            switch (c2) {
                case '[': {
                    if (openGroupIdx < 0) {
                        openGroupIdx = i2;
                        prefix.append(format, 0, i2);
                    }
                    ++openingCnt;
                    break;
                }
                case ']': {
                    if (openGroupIdx >= 0) {
                        --openingCnt;
                    }
                    if (openingCnt != 0) break;
                    closeGroupIdx = i2;
                    suffix = format.substring(i2 + 1);
                    break;
                }
            }
            if (closeGroupIdx > 0) break;
        }
        if (openGroupIdx >= 0) {
            String[] groups;
            for (String group2 : groups = format.substring(openGroupIdx + 1, closeGroupIdx).split(",")) {
                DateParser.expandFormat(new StringBuilder(prefix).append(group2).append(suffix), openGroupIdx, result);
            }
            DateParser.expandFormat(format.delete(openGroupIdx, closeGroupIdx + 1), closeGroupIdx - (closeGroupIdx - openGroupIdx), result);
        } else if (format.length() > 0) {
            result.add(format.toString());
        }
    }

    static {
        ArrayList<String> formats = new ArrayList<String>(Arrays.asList(SUPPORTED_FORMATS));
        formats.addAll(Arrays.asList(USER_DEFINED_FORMATS));
        DTF = new DateTimeFormatterBuilder().append(null, DateParser.toFormatter(formats)).toFormatter();
    }
}

