/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.tools.rmi;

import ai.h2o.javassist.CannotCompileException;
import ai.h2o.javassist.ClassPool;
import ai.h2o.javassist.CtClass;
import ai.h2o.javassist.CtConstructor;
import ai.h2o.javassist.CtField;
import ai.h2o.javassist.CtMethod;
import ai.h2o.javassist.CtNewConstructor;
import ai.h2o.javassist.CtNewMethod;
import ai.h2o.javassist.Modifier;
import ai.h2o.javassist.NotFoundException;
import ai.h2o.javassist.Translator;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Map;

public class StubGenerator
implements Translator {
    private static final String fieldImporter = "importer";
    private static final String fieldObjectId = "objectId";
    private static final String accessorObjectId = "_getObjectId";
    private static final String sampleClass = "ai.h2o.javassist.tools.rmi.Sample";
    private ClassPool classPool;
    private Map<String, CtClass> proxyClasses = new Hashtable<String, CtClass>();
    private CtMethod forwardMethod;
    private CtMethod forwardStaticMethod;
    private CtClass[] proxyConstructorParamTypes;
    private CtClass[] interfacesForProxy;
    private CtClass[] exceptionForProxy;

    @Override
    public void start(ClassPool pool) throws NotFoundException {
        this.classPool = pool;
        CtClass c2 = pool.get(sampleClass);
        this.forwardMethod = c2.getDeclaredMethod("forward");
        this.forwardStaticMethod = c2.getDeclaredMethod("forwardStatic");
        this.proxyConstructorParamTypes = pool.get(new String[]{"ai.h2o.javassist.tools.rmi.ObjectImporter", "int"});
        this.interfacesForProxy = pool.get(new String[]{"java.io.Serializable", "ai.h2o.javassist.tools.rmi.Proxy"});
        this.exceptionForProxy = new CtClass[]{pool.get("ai.h2o.javassist.tools.rmi.RemoteException")};
    }

    @Override
    public void onLoad(ClassPool pool, String classname) {
    }

    public boolean isProxyClass(String name) {
        return this.proxyClasses.get(name) != null;
    }

    public synchronized boolean makeProxyClass(Class<?> clazz) throws CannotCompileException, NotFoundException {
        String classname = clazz.getName();
        if (this.proxyClasses.get(classname) != null) {
            return false;
        }
        CtClass ctclazz = this.produceProxyClass(this.classPool.get(classname), clazz);
        this.proxyClasses.put(classname, ctclazz);
        this.modifySuperclass(ctclazz);
        return true;
    }

    private CtClass produceProxyClass(CtClass orgclass, Class<?> orgRtClass) throws CannotCompileException, NotFoundException {
        int modify = orgclass.getModifiers();
        if (Modifier.isAbstract(modify) || Modifier.isNative(modify) || !Modifier.isPublic(modify)) {
            throw new CannotCompileException(orgclass.getName() + " must be public, non-native, and non-abstract.");
        }
        CtClass proxy = this.classPool.makeClass(orgclass.getName(), orgclass.getSuperclass());
        proxy.setInterfaces(this.interfacesForProxy);
        CtField f2 = new CtField(this.classPool.get("ai.h2o.javassist.tools.rmi.ObjectImporter"), fieldImporter, proxy);
        f2.setModifiers(2);
        proxy.addField(f2, CtField.Initializer.byParameter(0));
        f2 = new CtField(CtClass.intType, fieldObjectId, proxy);
        f2.setModifiers(2);
        proxy.addField(f2, CtField.Initializer.byParameter(1));
        proxy.addMethod(CtNewMethod.getter(accessorObjectId, f2));
        proxy.addConstructor(CtNewConstructor.defaultConstructor(proxy));
        CtConstructor cons = CtNewConstructor.skeleton(this.proxyConstructorParamTypes, null, proxy);
        proxy.addConstructor(cons);
        try {
            this.addMethods(proxy, orgRtClass.getMethods());
            return proxy;
        }
        catch (SecurityException e2) {
            throw new CannotCompileException(e2);
        }
    }

    private CtClass toCtClass(Class<?> rtclass) throws NotFoundException {
        String name;
        if (!rtclass.isArray()) {
            name = rtclass.getName();
        } else {
            StringBuffer sbuf = new StringBuffer();
            do {
                sbuf.append("[]");
            } while ((rtclass = rtclass.getComponentType()).isArray());
            sbuf.insert(0, rtclass.getName());
            name = sbuf.toString();
        }
        return this.classPool.get(name);
    }

    private CtClass[] toCtClass(Class<?>[] rtclasses) throws NotFoundException {
        int n2 = rtclasses.length;
        CtClass[] ctclasses = new CtClass[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            ctclasses[i2] = this.toCtClass(rtclasses[i2]);
        }
        return ctclasses;
    }

    private void addMethods(CtClass proxy, Method[] ms) throws CannotCompileException, NotFoundException {
        for (int i2 = 0; i2 < ms.length; ++i2) {
            Method m4 = ms[i2];
            int mod2 = m4.getModifiers();
            if (m4.getDeclaringClass() == Object.class || Modifier.isFinal(mod2)) continue;
            if (Modifier.isPublic(mod2)) {
                CtMethod body = Modifier.isStatic(mod2) ? this.forwardStaticMethod : this.forwardMethod;
                CtMethod wmethod = CtNewMethod.wrapped(this.toCtClass(m4.getReturnType()), m4.getName(), this.toCtClass(m4.getParameterTypes()), this.exceptionForProxy, body, CtMethod.ConstParameter.integer(i2), proxy);
                wmethod.setModifiers(mod2);
                proxy.addMethod(wmethod);
                continue;
            }
            if (Modifier.isProtected(mod2) || Modifier.isPrivate(mod2)) continue;
            throw new CannotCompileException("the methods must be public, protected, or private.");
        }
    }

    private void modifySuperclass(CtClass orgclass) throws CannotCompileException, NotFoundException {
        CtClass superclazz;
        while ((superclazz = orgclass.getSuperclass()) != null) {
            try {
                superclazz.getDeclaredConstructor(null);
                break;
            }
            catch (NotFoundException notFoundException) {
                superclazz.addConstructor(CtNewConstructor.defaultConstructor(superclazz));
                orgclass = superclazz;
            }
        }
    }
}

