/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.google.protobuf;

import ai.h2o.com.google.protobuf.Android;
import ai.h2o.com.google.protobuf.ByteOutput;
import ai.h2o.com.google.protobuf.CodedInputStream;
import ai.h2o.com.google.protobuf.CodedOutputStream;
import ai.h2o.com.google.protobuf.Internal;
import ai.h2o.com.google.protobuf.NioByteString;
import ai.h2o.com.google.protobuf.RopeByteString;
import ai.h2o.com.google.protobuf.Utf8;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public abstract class ByteString
implements Serializable,
Iterable<Byte> {
    static final int CONCATENATE_BY_COPY_SIZE = 128;
    static final int MIN_READ_FROM_CHUNK_SIZE = 256;
    static final int MAX_READ_FROM_CHUNK_SIZE = 8192;
    public static final ByteString EMPTY = new LiteralByteString(Internal.EMPTY_BYTE_ARRAY);
    private static final ByteArrayCopier byteArrayCopier = Android.isOnAndroidDevice() ? new SystemByteArrayCopier() : new ArraysByteArrayCopier();
    private int hash = 0;
    private static final int UNSIGNED_BYTE_MASK = 255;
    private static final Comparator<ByteString> UNSIGNED_LEXICOGRAPHICAL_COMPARATOR = new Comparator<ByteString>(){

        @Override
        public final int compare(ByteString former, ByteString latter) {
            ByteIterator byteIterator = former.iterator();
            ByteIterator byteIterator2 = latter.iterator();
            while (byteIterator.hasNext() && byteIterator2.hasNext()) {
                int n2 = Integer.compare(ByteString.toInt(byteIterator.nextByte()), ByteString.toInt(byteIterator2.nextByte()));
                if (n2 == 0) continue;
                return n2;
            }
            return Integer.compare(former.size(), latter.size());
        }
    };

    ByteString() {
    }

    public abstract byte byteAt(int var1);

    abstract byte internalByteAt(int var1);

    public ByteIterator iterator() {
        return new AbstractByteIterator(){
            private int position = 0;
            private final int limit = ByteString.this.size();

            @Override
            public boolean hasNext() {
                return this.position < this.limit;
            }

            @Override
            public byte nextByte() {
                int n2 = this.position;
                if (n2 >= this.limit) {
                    throw new NoSuchElementException();
                }
                this.position = n2 + 1;
                return ByteString.this.internalByteAt(n2);
            }
        };
    }

    public abstract int size();

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    private static int toInt(byte value) {
        return value & 0xFF;
    }

    public static Comparator<ByteString> unsignedLexicographicalComparator() {
        return UNSIGNED_LEXICOGRAPHICAL_COMPARATOR;
    }

    public final ByteString substring(int beginIndex) {
        return this.substring(beginIndex, this.size());
    }

    public abstract ByteString substring(int var1, int var2);

    public final boolean startsWith(ByteString prefix) {
        return this.size() >= prefix.size() && this.substring(0, prefix.size()).equals(prefix);
    }

    public final boolean endsWith(ByteString suffix) {
        if (this.size() >= suffix.size()) {
            ByteString byteString = this;
            if (byteString.substring(byteString.size() - suffix.size()).equals(suffix)) {
                return true;
            }
        }
        return false;
    }

    public static ByteString copyFrom(byte[] bytes, int offset, int size) {
        int n2 = offset;
        ByteString.checkRange(n2, n2 + size, bytes.length);
        return new LiteralByteString(byteArrayCopier.copyFrom(bytes, offset, size));
    }

    public static ByteString copyFrom(byte[] bytes) {
        return ByteString.copyFrom(bytes, 0, bytes.length);
    }

    static ByteString wrap(ByteBuffer buffer) {
        if (buffer.hasArray()) {
            int n2 = buffer.arrayOffset();
            return ByteString.wrap(buffer.array(), n2 + buffer.position(), buffer.remaining());
        }
        return new NioByteString(buffer);
    }

    static ByteString wrap(byte[] bytes) {
        return new LiteralByteString(bytes);
    }

    static ByteString wrap(byte[] bytes, int offset, int length) {
        return new BoundedByteString(bytes, offset, length);
    }

    public static ByteString copyFrom(ByteBuffer bytes, int size) {
        ByteString.checkRange(0, size, bytes.remaining());
        byte[] byArray = new byte[size];
        bytes.get(byArray);
        return new LiteralByteString(byArray);
    }

    public static ByteString copyFrom(ByteBuffer bytes) {
        ByteBuffer byteBuffer = bytes;
        return ByteString.copyFrom(byteBuffer, byteBuffer.remaining());
    }

    public static ByteString copyFrom(String text, String charsetName) throws UnsupportedEncodingException {
        return new LiteralByteString(text.getBytes(charsetName));
    }

    public static ByteString copyFrom(String text, Charset charset) {
        return new LiteralByteString(text.getBytes(charset));
    }

    public static ByteString copyFromUtf8(String text) {
        return new LiteralByteString(text.getBytes(Internal.UTF_8));
    }

    public static ByteString readFrom(InputStream streamToDrain) throws IOException {
        return ByteString.readFrom(streamToDrain, 256, 8192);
    }

    public static ByteString readFrom(InputStream streamToDrain, int chunkSize) throws IOException {
        int n2 = chunkSize;
        return ByteString.readFrom(streamToDrain, n2, n2);
    }

    public static ByteString readFrom(InputStream streamToDrain, int minChunkSize, int maxChunkSize) throws IOException {
        ByteString byteString;
        ArrayList<ByteString> arrayList = new ArrayList<ByteString>();
        int n2 = minChunkSize;
        while ((byteString = ByteString.readChunk(streamToDrain, n2)) != null) {
            arrayList.add(byteString);
            n2 = Math.min(n2 << 1, maxChunkSize);
        }
        return ByteString.copyFrom(arrayList);
    }

    private static ByteString readChunk(InputStream in, int chunkSize) throws IOException {
        int n2;
        int n3;
        byte[] byArray = new byte[chunkSize];
        for (n2 = 0; n2 < chunkSize && (n3 = in.read(byArray, n2, chunkSize - n2)) != -1; n2 += n3) {
        }
        if (n2 == 0) {
            return null;
        }
        return ByteString.copyFrom(byArray, 0, n2);
    }

    public final ByteString concat(ByteString other) {
        if (Integer.MAX_VALUE - this.size() < other.size()) {
            throw new IllegalArgumentException("ByteString would be too long: " + this.size() + "+" + other.size());
        }
        return RopeByteString.concatenate(this, other);
    }

    public static ByteString copyFrom(Iterable<ByteString> byteStrings) {
        int n2;
        if (!(byteStrings instanceof Collection)) {
            int n3 = 0;
            Iterator<ByteString> iterator = byteStrings.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                ++n3;
            }
            n2 = n3;
        } else {
            n2 = ((Collection)byteStrings).size();
        }
        if (n2 == 0) {
            return EMPTY;
        }
        return ByteString.balancedConcat(byteStrings.iterator(), n2);
    }

    private static ByteString balancedConcat(Iterator<ByteString> iterator, int length) {
        ByteString byteString;
        if (length <= 0) {
            throw new IllegalArgumentException(String.format("length (%s) must be >= 1", length));
        }
        if (length == 1) {
            byteString = iterator.next();
        } else {
            int n2 = length >>> 1;
            ByteString byteString2 = ByteString.balancedConcat(iterator, n2);
            ByteString byteString3 = ByteString.balancedConcat(iterator, length - n2);
            byteString = byteString2.concat(byteString3);
        }
        return byteString;
    }

    public void copyTo(byte[] target, int offset) {
        this.copyTo(target, 0, offset, this.size());
    }

    @Deprecated
    public final void copyTo(byte[] target, int sourceOffset, int targetOffset, int numberToCopy) {
        int n2 = sourceOffset;
        ByteString.checkRange(n2, n2 + numberToCopy, this.size());
        int n3 = targetOffset;
        ByteString.checkRange(n3, n3 + numberToCopy, target.length);
        if (numberToCopy > 0) {
            this.copyToInternal(target, sourceOffset, targetOffset, numberToCopy);
        }
    }

    protected abstract void copyToInternal(byte[] var1, int var2, int var3, int var4);

    public abstract void copyTo(ByteBuffer var1);

    public final byte[] toByteArray() {
        int n2 = this.size();
        if (n2 == 0) {
            return Internal.EMPTY_BYTE_ARRAY;
        }
        byte[] byArray = new byte[n2];
        this.copyToInternal(byArray, 0, 0, n2);
        return byArray;
    }

    public abstract void writeTo(OutputStream var1) throws IOException;

    final void writeTo(OutputStream out, int sourceOffset, int numberToWrite) throws IOException {
        int n2 = sourceOffset;
        ByteString.checkRange(n2, n2 + numberToWrite, this.size());
        if (numberToWrite > 0) {
            this.writeToInternal(out, sourceOffset, numberToWrite);
        }
    }

    abstract void writeToInternal(OutputStream var1, int var2, int var3) throws IOException;

    abstract void writeTo(ByteOutput var1) throws IOException;

    public abstract ByteBuffer asReadOnlyByteBuffer();

    public abstract List<ByteBuffer> asReadOnlyByteBufferList();

    public final String toString(String charsetName) throws UnsupportedEncodingException {
        try {
            return this.toString(Charset.forName(charsetName));
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            UnsupportedEncodingException unsupportedEncodingException = new UnsupportedEncodingException(charsetName);
            unsupportedEncodingException.initCause(unsupportedCharsetException);
            throw unsupportedEncodingException;
        }
    }

    public final String toString(Charset charset) {
        if (this.size() == 0) {
            return "";
        }
        return this.toStringInternal(charset);
    }

    protected abstract String toStringInternal(Charset var1);

    public final String toStringUtf8() {
        return this.toString(Internal.UTF_8);
    }

    public abstract boolean isValidUtf8();

    protected abstract int partialIsValidUtf8(int var1, int var2, int var3);

    public abstract boolean equals(Object var1);

    public final int hashCode() {
        int n2 = this.hash;
        if (n2 == 0) {
            int n3 = this.size();
            n2 = this.partialHash(n3, 0, n3);
            if (n2 == 0) {
                n2 = 1;
            }
            this.hash = n2;
        }
        return n2;
    }

    public abstract InputStream newInput();

    public abstract CodedInputStream newCodedInput();

    public static Output newOutput(int initialCapacity) {
        return new Output(initialCapacity);
    }

    public static Output newOutput() {
        return new Output(128);
    }

    static CodedBuilder newCodedBuilder(int size) {
        return new CodedBuilder(size);
    }

    protected abstract int getTreeDepth();

    protected abstract boolean isBalanced();

    protected final int peekCachedHashCode() {
        return this.hash;
    }

    protected abstract int partialHash(int var1, int var2, int var3);

    static void checkIndex(int index, int size) {
        if ((index | size - (index + 1)) < 0) {
            if (index < 0) {
                throw new ArrayIndexOutOfBoundsException("Index < 0: " + index);
            }
            throw new ArrayIndexOutOfBoundsException("Index > length: " + index + ", " + size);
        }
    }

    static int checkRange(int startIndex, int endIndex, int size) {
        int n2 = endIndex - startIndex;
        if ((startIndex | endIndex | n2 | size - endIndex) < 0) {
            if (startIndex < 0) {
                throw new IndexOutOfBoundsException("Beginning index: " + startIndex + " < 0");
            }
            if (endIndex < startIndex) {
                throw new IndexOutOfBoundsException("Beginning index larger than ending index: " + startIndex + ", " + endIndex);
            }
            throw new IndexOutOfBoundsException("End index: " + endIndex + " >= " + size);
        }
        return n2;
    }

    public final String toString() {
        return String.format("<ByteString@%s size=%d>", Integer.toHexString(System.identityHashCode(this)), this.size());
    }

    private static final class BoundedByteString
    extends LiteralByteString {
        private final int bytesOffset;
        private final int bytesLength;
        private static final long serialVersionUID = 1L;

        BoundedByteString(byte[] bytes, int offset, int length) {
            super(bytes);
            int n2 = offset;
            BoundedByteString.checkRange(n2, n2 + length, bytes.length);
            this.bytesOffset = offset;
            this.bytesLength = length;
        }

        @Override
        public final byte byteAt(int index) {
            BoundedByteString.checkIndex(index, this.size());
            return this.bytes[this.bytesOffset + index];
        }

        @Override
        final byte internalByteAt(int index) {
            return this.bytes[this.bytesOffset + index];
        }

        @Override
        public final int size() {
            return this.bytesLength;
        }

        @Override
        protected final int getOffsetIntoBytes() {
            return this.bytesOffset;
        }

        @Override
        protected final void copyToInternal(byte[] target, int sourceOffset, int targetOffset, int numberToCopy) {
            System.arraycopy(this.bytes, this.getOffsetIntoBytes() + sourceOffset, target, targetOffset, numberToCopy);
        }

        final Object writeReplace() {
            return ByteString.wrap(this.toByteArray());
        }

        private void readObject(ObjectInputStream in) throws IOException {
            throw new InvalidObjectException("BoundedByteStream instances are not to be serialized directly");
        }
    }

    private static class LiteralByteString
    extends LeafByteString {
        private static final long serialVersionUID = 1L;
        protected final byte[] bytes;

        LiteralByteString(byte[] bytes) {
            if (bytes == null) {
                throw new NullPointerException();
            }
            this.bytes = bytes;
        }

        @Override
        public byte byteAt(int index) {
            return this.bytes[index];
        }

        @Override
        byte internalByteAt(int index) {
            return this.bytes[index];
        }

        @Override
        public int size() {
            return this.bytes.length;
        }

        @Override
        public final ByteString substring(int beginIndex, int endIndex) {
            int n2 = LiteralByteString.checkRange(beginIndex, endIndex, this.size());
            if (n2 == 0) {
                return EMPTY;
            }
            return new BoundedByteString(this.bytes, this.getOffsetIntoBytes() + beginIndex, n2);
        }

        @Override
        protected void copyToInternal(byte[] target, int sourceOffset, int targetOffset, int numberToCopy) {
            System.arraycopy(this.bytes, sourceOffset, target, targetOffset, numberToCopy);
        }

        @Override
        public final void copyTo(ByteBuffer target) {
            target.put(this.bytes, this.getOffsetIntoBytes(), this.size());
        }

        @Override
        public final ByteBuffer asReadOnlyByteBuffer() {
            return ByteBuffer.wrap(this.bytes, this.getOffsetIntoBytes(), this.size()).asReadOnlyBuffer();
        }

        @Override
        public final List<ByteBuffer> asReadOnlyByteBufferList() {
            return Collections.singletonList(this.asReadOnlyByteBuffer());
        }

        @Override
        public final void writeTo(OutputStream outputStream) throws IOException {
            outputStream.write(this.toByteArray());
        }

        @Override
        final void writeToInternal(OutputStream outputStream, int sourceOffset, int numberToWrite) throws IOException {
            outputStream.write(this.bytes, this.getOffsetIntoBytes() + sourceOffset, numberToWrite);
        }

        @Override
        final void writeTo(ByteOutput output) throws IOException {
            output.writeLazy(this.bytes, this.getOffsetIntoBytes(), this.size());
        }

        @Override
        protected final String toStringInternal(Charset charset) {
            return new String(this.bytes, this.getOffsetIntoBytes(), this.size(), charset);
        }

        @Override
        public final boolean isValidUtf8() {
            int n2;
            int n3 = n2 = this.getOffsetIntoBytes();
            return Utf8.isValidUtf8(this.bytes, n3, n3 + this.size());
        }

        @Override
        protected final int partialIsValidUtf8(int state, int offset, int length) {
            int n2;
            int n3 = n2 = this.getOffsetIntoBytes() + offset;
            return Utf8.partialIsValidUtf8(state, this.bytes, n3, n3 + length);
        }

        @Override
        public final boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof ByteString)) {
                return false;
            }
            if (this.size() != ((ByteString)other).size()) {
                return false;
            }
            if (this.size() == 0) {
                return true;
            }
            if (other instanceof LiteralByteString) {
                LiteralByteString literalByteString = (LiteralByteString)other;
                int n2 = this.peekCachedHashCode();
                int n3 = literalByteString.peekCachedHashCode();
                if (n2 != 0 && n3 != 0 && n2 != n3) {
                    return false;
                }
                return this.equalsRange((LiteralByteString)other, 0, this.size());
            }
            return other.equals(this);
        }

        @Override
        final boolean equalsRange(ByteString other, int offset, int length) {
            if (length > other.size()) {
                throw new IllegalArgumentException("Length too large: " + length + this.size());
            }
            if (offset + length > other.size()) {
                throw new IllegalArgumentException("Ran off end of other: " + offset + ", " + length + ", " + other.size());
            }
            if (other instanceof LiteralByteString) {
                LiteralByteString literalByteString = (LiteralByteString)other;
                byte[] byArray = this.bytes;
                byte[] byArray2 = literalByteString.bytes;
                int n2 = this.getOffsetIntoBytes() + length;
                int n3 = this.getOffsetIntoBytes();
                int n4 = literalByteString.getOffsetIntoBytes() + offset;
                while (n3 < n2) {
                    if (byArray[n3] != byArray2[n4]) {
                        return false;
                    }
                    ++n3;
                    ++n4;
                }
                return true;
            }
            int n5 = offset;
            return other.substring(n5, n5 + length).equals(this.substring(0, length));
        }

        @Override
        protected final int partialHash(int h2, int offset, int length) {
            return Internal.partialHash(h2, this.bytes, this.getOffsetIntoBytes() + offset, length);
        }

        @Override
        public final InputStream newInput() {
            return new ByteArrayInputStream(this.bytes, this.getOffsetIntoBytes(), this.size());
        }

        @Override
        public final CodedInputStream newCodedInput() {
            return CodedInputStream.newInstance(this.bytes, this.getOffsetIntoBytes(), this.size(), true);
        }

        protected int getOffsetIntoBytes() {
            return 0;
        }
    }

    static final class CodedBuilder {
        private final CodedOutputStream output;
        private final byte[] buffer;

        private CodedBuilder(int size) {
            this.buffer = new byte[size];
            this.output = CodedOutputStream.newInstance(this.buffer);
        }

        public final ByteString build() {
            this.output.checkNoSpaceLeft();
            return new LiteralByteString(this.buffer);
        }

        public final CodedOutputStream getCodedOutput() {
            return this.output;
        }
    }

    public static final class Output
    extends OutputStream {
        private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
        private final int initialCapacity;
        private final ArrayList<ByteString> flushedBuffers;
        private int flushedBuffersTotalBytes;
        private byte[] buffer;
        private int bufferPos;

        Output(int initialCapacity) {
            if (initialCapacity < 0) {
                throw new IllegalArgumentException("Buffer size < 0");
            }
            this.initialCapacity = initialCapacity;
            this.flushedBuffers = new ArrayList();
            this.buffer = new byte[initialCapacity];
        }

        @Override
        public final synchronized void write(int b2) {
            if (this.bufferPos == this.buffer.length) {
                this.flushFullBuffer(1);
            }
            this.buffer[this.bufferPos++] = (byte)b2;
        }

        @Override
        public final synchronized void write(byte[] b2, int offset, int length) {
            if (length <= this.buffer.length - this.bufferPos) {
                System.arraycopy(b2, offset, this.buffer, this.bufferPos, length);
                this.bufferPos += length;
                return;
            }
            int n2 = this.buffer.length - this.bufferPos;
            System.arraycopy(b2, offset, this.buffer, this.bufferPos, n2);
            this.flushFullBuffer(length -= n2);
            System.arraycopy(b2, offset += n2, this.buffer, 0, length);
            this.bufferPos = length;
        }

        public final synchronized ByteString toByteString() {
            this.flushLastBuffer();
            return ByteString.copyFrom(this.flushedBuffers);
        }

        private byte[] copyArray(byte[] buffer, int length) {
            byte[] byArray = new byte[length];
            System.arraycopy(buffer, 0, byArray, 0, Math.min(buffer.length, length));
            return byArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void writeTo(OutputStream out) throws IOException {
            ByteString[] byteStringArray = this;
            synchronized (this) {
                ByteString[] byteStringArray2 = this.flushedBuffers.toArray(new ByteString[this.flushedBuffers.size()]);
                byte[] byArray = this.buffer;
                int n2 = this.bufferPos;
                // ** MonitorExit[var5_2] (shouldn't be in output)
                byteStringArray = byteStringArray2;
                int n3 = byteStringArray2.length;
                for (int i2 = 0; i2 < n3; ++i2) {
                    ByteString byteString = byteStringArray[i2];
                    byteString.writeTo(out);
                }
                out.write(super.copyArray(byArray, n2));
                return;
            }
        }

        public final synchronized int size() {
            return this.flushedBuffersTotalBytes + this.bufferPos;
        }

        public final synchronized void reset() {
            this.flushedBuffers.clear();
            this.flushedBuffersTotalBytes = 0;
            this.bufferPos = 0;
        }

        public final String toString() {
            return String.format("<ByteString.Output@%s size=%d>", Integer.toHexString(System.identityHashCode(this)), this.size());
        }

        private void flushFullBuffer(int minSize) {
            this.flushedBuffers.add(new LiteralByteString(this.buffer));
            this.flushedBuffersTotalBytes += this.buffer.length;
            int n2 = Math.max(this.initialCapacity, Math.max(minSize, this.flushedBuffersTotalBytes >>> 1));
            this.buffer = new byte[n2];
            this.bufferPos = 0;
        }

        private void flushLastBuffer() {
            if (this.bufferPos < this.buffer.length) {
                if (this.bufferPos > 0) {
                    Output output = this;
                    byte[] byArray = output.copyArray(output.buffer, this.bufferPos);
                    this.flushedBuffers.add(new LiteralByteString(byArray));
                }
            } else {
                this.flushedBuffers.add(new LiteralByteString(this.buffer));
                this.buffer = EMPTY_BYTE_ARRAY;
            }
            this.flushedBuffersTotalBytes += this.bufferPos;
            this.bufferPos = 0;
        }
    }

    static abstract class LeafByteString
    extends ByteString {
        LeafByteString() {
        }

        @Override
        protected final int getTreeDepth() {
            return 0;
        }

        @Override
        protected final boolean isBalanced() {
            return true;
        }

        abstract boolean equalsRange(ByteString var1, int var2, int var3);
    }

    static abstract class AbstractByteIterator
    implements ByteIterator {
        AbstractByteIterator() {
        }

        @Override
        public final Byte next() {
            return this.nextByte();
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static interface ByteIterator
    extends Iterator<Byte> {
        public byte nextByte();
    }

    private static final class ArraysByteArrayCopier
    implements ByteArrayCopier {
        private ArraysByteArrayCopier() {
        }

        @Override
        public final byte[] copyFrom(byte[] bytes, int offset, int size) {
            int n2 = offset;
            return Arrays.copyOfRange(bytes, n2, n2 + size);
        }
    }

    private static final class SystemByteArrayCopier
    implements ByteArrayCopier {
        private SystemByteArrayCopier() {
        }

        @Override
        public final byte[] copyFrom(byte[] bytes, int offset, int size) {
            byte[] byArray = new byte[size];
            System.arraycopy(bytes, offset, byArray, 0, size);
            return byArray;
        }
    }

    private static interface ByteArrayCopier {
        public byte[] copyFrom(byte[] var1, int var2, int var3);
    }
}

