/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.google.common.cache;

import ai.h2o.com.google.common.annotations.GwtIncompatible;
import ai.h2o.com.google.common.base.Preconditions;
import ai.h2o.com.google.common.cache.ElementTypesAreNonnullByDefault;
import ai.h2o.com.google.common.cache.RemovalListener;
import ai.h2o.com.google.common.cache.RemovalNotification;
import java.util.concurrent.Executor;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public final class RemovalListeners {
    private RemovalListeners() {
    }

    public static <K, V> RemovalListener<K, V> asynchronous(final RemovalListener<K, V> listener, final Executor executor) {
        Preconditions.checkNotNull(listener);
        Preconditions.checkNotNull(executor);
        return new RemovalListener<K, V>(){

            @Override
            public void onRemoval(final RemovalNotification<K, V> notification) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        listener.onRemoval(notification);
                    }
                });
            }
        };
    }
}

