/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.amazonaws.util;

import ai.h2o.com.amazonaws.util.AbstractBase32Codec;
import ai.h2o.com.amazonaws.util.CodecUtils;

class Base32Codec
extends AbstractBase32Codec {
    private static final int OFFSET_OF_2 = 24;

    private static byte[] alphabets() {
        return CodecUtils.toBytesDirect("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567");
    }

    Base32Codec() {
        super(Base32Codec.alphabets());
    }

    @Override
    protected int pos(byte in) {
        byte pos = LazyHolder.DECODED[in];
        if (pos > -1) {
            return pos;
        }
        throw new IllegalArgumentException("Invalid base 32 character: '" + (char)in + "'");
    }

    private static class LazyHolder {
        private static final byte[] DECODED = LazyHolder.decodeTable();

        private LazyHolder() {
        }

        private static byte[] decodeTable() {
            byte[] dest = new byte[123];
            for (int i2 = 0; i2 <= 122; ++i2) {
                dest[i2] = i2 >= 65 && i2 <= 90 ? (int)(i2 - 65) : (i2 >= 50 && i2 <= 55 ? (int)(i2 - 24) : (i2 >= 97 && i2 <= 122 ? (int)(i2 - 97) : -1));
            }
            return dest;
        }
    }
}

