/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.amazonaws.services.s3.model.transform;

import ai.h2o.com.amazonaws.services.s3.internal.XmlWriter;
import ai.h2o.com.amazonaws.services.s3.model.intelligenttiering.IntelligentTieringAndOperator;
import ai.h2o.com.amazonaws.services.s3.model.intelligenttiering.IntelligentTieringFilterPredicate;
import ai.h2o.com.amazonaws.services.s3.model.intelligenttiering.IntelligentTieringPredicateVisitor;
import ai.h2o.com.amazonaws.services.s3.model.intelligenttiering.IntelligentTieringPrefixPredicate;
import ai.h2o.com.amazonaws.services.s3.model.intelligenttiering.IntelligentTieringTagPredicate;
import ai.h2o.com.amazonaws.services.s3.model.transform.BucketConfigurationXmlFactoryFunctions;

class XmlIntelligentTieringPredicateVisitor
implements IntelligentTieringPredicateVisitor {
    private final XmlWriter xml;

    public XmlIntelligentTieringPredicateVisitor(XmlWriter xml) {
        this.xml = xml;
    }

    @Override
    public void visit(IntelligentTieringPrefixPredicate prefixPredicate) {
        BucketConfigurationXmlFactoryFunctions.writePrefix(this.xml, prefixPredicate.getPrefix());
    }

    @Override
    public void visit(IntelligentTieringTagPredicate tagPredicate) {
        BucketConfigurationXmlFactoryFunctions.writeTag(this.xml, tagPredicate.getTag());
    }

    @Override
    public void visit(IntelligentTieringAndOperator andOperator) {
        this.xml.start("And");
        for (IntelligentTieringFilterPredicate predicate : andOperator.getOperands()) {
            predicate.accept(this);
        }
        this.xml.end();
    }
}

