/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.amazonaws.http.timers;

import ai.h2o.com.amazonaws.SdkClientException;
import ai.h2o.com.amazonaws.annotation.SdkInternalApi;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

@SdkInternalApi
public class TimeoutThreadPoolBuilder {
    public static ScheduledThreadPoolExecutor buildDefaultTimeoutThreadPool(String name) {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(5, TimeoutThreadPoolBuilder.getThreadFactory(name));
        TimeoutThreadPoolBuilder.safeSetRemoveOnCancel(executor);
        executor.setKeepAliveTime(5L, TimeUnit.SECONDS);
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    private static ThreadFactory getThreadFactory(final String name) {
        return new ThreadFactory(){
            private int threadCount = 1;

            @Override
            public Thread newThread(Runnable r2) {
                Thread thread2 = new Thread(r2);
                if (name != null) {
                    thread2.setName(name + "-" + this.threadCount++);
                }
                thread2.setPriority(10);
                return thread2;
            }
        };
    }

    private static void safeSetRemoveOnCancel(ScheduledThreadPoolExecutor executor) {
        try {
            executor.getClass().getMethod("setRemoveOnCancelPolicy", Boolean.TYPE).invoke((Object)executor, Boolean.TRUE);
        }
        catch (IllegalAccessException e2) {
            TimeoutThreadPoolBuilder.throwSetRemoveOnCancelException(e2);
        }
        catch (IllegalArgumentException e3) {
            TimeoutThreadPoolBuilder.throwSetRemoveOnCancelException(e3);
        }
        catch (InvocationTargetException e4) {
            TimeoutThreadPoolBuilder.throwSetRemoveOnCancelException(e4.getCause());
        }
        catch (NoSuchMethodException e5) {
            throw new SdkClientException("The request timeout feature is only available for Java 1.7 and above.");
        }
        catch (SecurityException e6) {
            throw new SdkClientException("The request timeout feature needs additional permissions to function.", e6);
        }
    }

    private static void throwSetRemoveOnCancelException(Throwable cause) {
        throw new SdkClientException("Unable to setRemoveOnCancelPolicy for request timeout thread pool", cause);
    }
}

