/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.amazonaws.http;

import ai.h2o.com.amazonaws.AmazonWebServiceResponse;
import ai.h2o.com.amazonaws.ResponseMetadata;
import ai.h2o.com.amazonaws.http.HttpResponse;
import ai.h2o.com.amazonaws.http.HttpResponseHandler;
import ai.h2o.com.amazonaws.internal.SdkFilterInputStream;
import ai.h2o.com.amazonaws.transform.StaxUnmarshallerContext;
import ai.h2o.com.amazonaws.transform.Unmarshaller;
import ai.h2o.com.amazonaws.transform.VoidStaxUnmarshaller;
import ai.h2o.com.amazonaws.util.StringUtils;
import ai.h2o.com.amazonaws.util.XmlUtils;
import ai.h2o.org.apache.http.impl.io.EmptyInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StaxResponseHandler<T>
implements HttpResponseHandler<AmazonWebServiceResponse<T>> {
    private Unmarshaller<T, StaxUnmarshallerContext> responseUnmarshaller;
    private final boolean needsConnectionLeftOpen;
    private final boolean isPayloadXML;
    private static final Log log = LogFactory.getLog((String)"ai.h2o.com.amazonaws.request");

    public StaxResponseHandler(Unmarshaller<T, StaxUnmarshallerContext> responseUnmarshaller, boolean needsConnectionLeftOpen, boolean isPayloadXML) {
        this.responseUnmarshaller = responseUnmarshaller;
        if (this.responseUnmarshaller == null) {
            this.responseUnmarshaller = new VoidStaxUnmarshaller();
        }
        this.needsConnectionLeftOpen = needsConnectionLeftOpen;
        this.isPayloadXML = isPayloadXML;
    }

    public StaxResponseHandler(Unmarshaller<T, StaxUnmarshallerContext> responseUnmarshaller) {
        this(responseUnmarshaller, false, true);
    }

    @Override
    public AmazonWebServiceResponse<T> handle(HttpResponse response) throws Exception {
        XMLEventReader eventReader;
        log.trace((Object)"Parsing service response XML");
        InputStream content = response.getContent();
        if (content == null || !this.shouldParsePayloadAsXml()) {
            content = new ByteArrayInputStream("<eof/>".getBytes(StringUtils.UTF8));
        } else if (content instanceof SdkFilterInputStream && ((SdkFilterInputStream)content).getDelegateStream() instanceof EmptyInputStream) {
            content = new ByteArrayInputStream("<eof/>".getBytes(StringUtils.UTF8));
        }
        try {
            eventReader = XmlUtils.getXmlInputFactory().createXMLEventReader(content);
        }
        catch (XMLStreamException e2) {
            throw this.handleXmlStreamException(e2);
        }
        try {
            AmazonWebServiceResponse<T> awsResponse = new AmazonWebServiceResponse<T>();
            StaxUnmarshallerContext unmarshallerContext = new StaxUnmarshallerContext(eventReader, response.getHeaders(), response);
            unmarshallerContext.registerMetadataExpression("ResponseMetadata/RequestId", 2, "AWS_REQUEST_ID");
            unmarshallerContext.registerMetadataExpression("requestId", 2, "AWS_REQUEST_ID");
            this.registerAdditionalMetadataExpressions(unmarshallerContext);
            T result = this.responseUnmarshaller.unmarshall(unmarshallerContext);
            awsResponse.setResult(result);
            Map<String, String> metadata = unmarshallerContext.getMetadata();
            Map<String, String> responseHeaders = response.getHeaders();
            if (responseHeaders != null) {
                if (responseHeaders.get("x-amzn-RequestId") != null) {
                    metadata.put("AWS_REQUEST_ID", responseHeaders.get("x-amzn-RequestId"));
                }
                if (responseHeaders.get("x-amz-id-2") != null) {
                    metadata.put("AWS_EXTENDED_REQUEST_ID", responseHeaders.get("x-amz-id-2"));
                }
            }
            awsResponse.setResponseMetadata(this.getResponseMetadata(metadata));
            log.trace((Object)"Done parsing service response");
            AmazonWebServiceResponse<T> amazonWebServiceResponse = awsResponse;
            return amazonWebServiceResponse;
        }
        catch (XMLStreamException e3) {
            throw this.handleXmlStreamException(e3);
        }
        finally {
            try {
                eventReader.close();
            }
            catch (XMLStreamException e4) {
                log.warn((Object)"Error closing xml parser", (Throwable)e4);
            }
        }
    }

    private Exception handleXmlStreamException(XMLStreamException e2) throws Exception {
        if (e2.getNestedException() instanceof IOException) {
            return new IOException(e2);
        }
        return e2;
    }

    protected ResponseMetadata getResponseMetadata(Map<String, String> metadata) {
        return new ResponseMetadata(metadata);
    }

    protected void registerAdditionalMetadataExpressions(StaxUnmarshallerContext unmarshallerContext) {
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return this.needsConnectionLeftOpen;
    }

    private boolean shouldParsePayloadAsXml() {
        return !this.needsConnectionLeftOpen && this.isPayloadXML;
    }
}

