/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.amazonaws.arn;

import ai.h2o.com.amazonaws.util.ValidationUtils;

public class ArnResource {
    private final String resourceType;
    private final String resource;
    private final String qualifier;

    private ArnResource(Builder b2) {
        this.resourceType = b2.resourceType;
        this.resource = ValidationUtils.assertStringNotEmpty(b2.resource, "resource");
        this.qualifier = b2.qualifier;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getResource() {
        return this.resource;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ArnResource fromString(String resource) {
        char ch;
        int i2;
        Integer resourceTypeBoundary = null;
        Integer resourceIdBoundary = null;
        for (i2 = 0; i2 < resource.length(); ++i2) {
            ch = resource.charAt(i2);
            if (ch != ':' && ch != '/') continue;
            resourceTypeBoundary = i2;
            break;
        }
        if (resourceTypeBoundary != null) {
            for (i2 = resource.length() - 1; i2 > resourceTypeBoundary; --i2) {
                ch = resource.charAt(i2);
                if (ch != ':') continue;
                resourceIdBoundary = i2;
                break;
            }
        }
        if (resourceTypeBoundary == null) {
            return ArnResource.builder().withResource(resource).build();
        }
        if (resourceIdBoundary == null) {
            String resourceType = resource.substring(0, resourceTypeBoundary);
            String resourceId = resource.substring(resourceTypeBoundary + 1);
            return ArnResource.builder().withResourceType(resourceType).withResource(resourceId).build();
        }
        String resourceType = resource.substring(0, resourceTypeBoundary);
        String resourceId = resource.substring(resourceTypeBoundary + 1, resourceIdBoundary);
        String qualifier = resource.substring(resourceIdBoundary + 1);
        return ArnResource.builder().withResourceType(resourceType).withResource(resourceId).withQualifier(qualifier).build();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.resourceType != null) {
            sb.append(this.resourceType);
            sb.append(":");
        }
        sb.append(this.resource);
        if (this.qualifier != null) {
            sb.append(":");
            sb.append(this.qualifier);
        }
        return sb.toString();
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        ArnResource that = (ArnResource)o2;
        if (this.resourceType != null ? !this.resourceType.equals(that.resourceType) : that.resourceType != null) {
            return false;
        }
        if (!this.resource.equals(that.resource)) {
            return false;
        }
        return this.qualifier != null ? this.qualifier.equals(that.qualifier) : that.qualifier == null;
    }

    public int hashCode() {
        int result = this.resourceType != null ? this.resourceType.hashCode() : 0;
        result = 31 * result + this.resource.hashCode();
        result = 31 * result + (this.qualifier != null ? this.qualifier.hashCode() : 0);
        return result;
    }

    public static final class Builder {
        private String resourceType;
        private String resource;
        private String qualifier;

        private Builder() {
        }

        public void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public Builder withResourceType(String resourceType) {
            this.setResourceType(resourceType);
            return this;
        }

        public void setResource(String resource) {
            this.resource = resource;
        }

        public Builder withResource(String resource) {
            this.setResource(resource);
            return this;
        }

        public void setQualifier(String qualifier) {
            this.qualifier = qualifier;
        }

        public Builder withQualifier(String qualifier) {
            this.setQualifier(qualifier);
            return this;
        }

        public ArnResource build() {
            return new ArnResource(this);
        }
    }
}

