/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.automl.leaderboard;

import ai.h2o.automl.leaderboard.LeaderboardCell;
import ai.h2o.automl.leaderboard.LeaderboardColumn;
import hex.Model;
import water.Iced;
import water.Key;
import water.fvec.Frame;

public class ScoringTimePerRow
extends Iced<ScoringTimePerRow>
implements LeaderboardCell<Double, ScoringTimePerRow> {
    public static final LeaderboardColumn COLUMN = new LeaderboardColumn("predict_time_per_row_ms", "double", "%.6f");
    private final Key<Model> _modelId;
    private final Key<Frame> _leaderboardFrameId;
    private final Key<Frame> _trainingFrameId;
    private Double _scoringTimePerRowMillis;

    public ScoringTimePerRow(Model model, Frame leaderboardFrame, Frame trainingFrame) {
        this(model._key, leaderboardFrame == null ? null : leaderboardFrame._key, trainingFrame == null ? null : trainingFrame._key);
    }

    public ScoringTimePerRow(Key<Model> modelId, Key<Frame> leaderboardFrameId, Key<Frame> trainingFrameId) {
        this._modelId = modelId;
        this._leaderboardFrameId = leaderboardFrameId;
        this._trainingFrameId = trainingFrameId;
    }

    @Override
    public LeaderboardColumn getColumn() {
        return COLUMN;
    }

    @Override
    public Key<Model> getModelId() {
        return this._modelId;
    }

    @Override
    public Double getValue() {
        return this._scoringTimePerRowMillis;
    }

    @Override
    public void setValue(Double value) {
        this._scoringTimePerRowMillis = value;
    }

    @Override
    public boolean isNA() {
        return this.getValue() == null || this.getValue() < 0.0;
    }

    @Override
    public Double fetch() {
        if (this.getValue() == null) {
            try {
                Frame scoringFrame;
                Model model = this._modelId.get();
                Frame frame = this._leaderboardFrameId != null ? this._leaderboardFrameId.get() : (scoringFrame = this._trainingFrameId != null ? this._trainingFrameId.get() : null);
                if (scoringFrame != null) {
                    long nrows = scoringFrame.numRows();
                    long start = System.nanoTime();
                    model.score(scoringFrame).delete();
                    long stop = System.nanoTime();
                    this.setValue((double)((stop - start) / nrows) / 1000000.0);
                } else {
                    this.setValue(-1.0);
                }
            }
            catch (Exception e2) {
                this.setValue(-1.0);
            }
        }
        return this.getValue();
    }
}

