/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.automl.leaderboard;

import ai.h2o.automl.events.EventLog;
import ai.h2o.automl.events.EventLogEntry;
import ai.h2o.automl.leaderboard.LeaderboardCell;
import ai.h2o.automl.leaderboard.LeaderboardColumn;
import ai.h2o.automl.leaderboard.LeaderboardExtensionsProvider;
import ai.h2o.automl.leaderboard.MetricScore;
import ai.h2o.automl.leaderboard.ModelId;
import ai.h2o.automl.leaderboard.ScoringTimePerRow;
import ai.h2o.automl.utils.DKVUtils;
import hex.Model;
import hex.ModelContainer;
import hex.ModelMetrics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import water.DKV;
import water.Futures;
import water.Job;
import water.Key;
import water.Keyed;
import water.Lockable;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.Frame;
import water.logging.Logger;
import water.logging.LoggerFactory;
import water.util.ArrayUtils;
import water.util.IcedHashMap;
import water.util.TwoDimTable;

public class Leaderboard
extends Lockable<Leaderboard>
implements ModelContainer<Model> {
    private static final Logger log = LoggerFactory.getLogger(Leaderboard.class);
    private final String _project_name;
    private Key<Model>[] _model_keys = new Key[0];
    private final IcedHashMap<Key<ModelMetrics>, ModelMetrics> _leaderboard_model_metrics = new IcedHashMap();
    private IcedHashMap<String, double[]> _metric_values = new IcedHashMap();
    private LeaderboardExtensionsProvider _extensionsProvider;
    private LeaderboardCell[] _extensions_cells = new LeaderboardCell[0];
    private String _sort_metric;
    private String[] _metrics;
    private final Key<EventLog> _eventlog_key;
    private final Key<Frame> _leaderboard_frame_key;
    private final long _leaderboard_frame_checksum;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public static String idForProject(String project_name) {
        return "Leaderboard_" + project_name;
    }

    public static boolean isLossFunction(String metric) {
        return metric != null && !Arrays.asList("auc", "aucpr").contains(metric.toLowerCase());
    }

    public static Leaderboard getOrMake(String projectName, EventLog eventLog, Frame leaderboardFrame, String sortMetric) {
        Leaderboard leaderboard = (Leaderboard)DKV.getGet(Key.make(Leaderboard.idForProject(projectName)));
        if (null != leaderboard) {
            if (!(leaderboardFrame == null || leaderboardFrame._key.equals(leaderboard._leaderboard_frame_key) && leaderboardFrame.checksum() == leaderboard._leaderboard_frame_checksum)) {
                throw new H2OIllegalArgumentException("Cannot use leaderboard " + projectName + " with a new leaderboard frame (existing leaderboard frame: " + leaderboard._leaderboard_frame_key + ").");
            }
            eventLog.warn(EventLogEntry.Stage.Workflow, "New models will be added to existing leaderboard " + projectName + " (leaderboard frame=" + leaderboard._leaderboard_frame_key + ") with already " + leaderboard.getModelKeys().length + " models.");
            if (sortMetric != null && !sortMetric.equals(leaderboard._sort_metric)) {
                leaderboard._sort_metric = sortMetric.toLowerCase();
                if (leaderboard.getLeader() != null) {
                    leaderboard.setDefaultMetrics(leaderboard.getLeader());
                }
            }
        } else {
            leaderboard = new Leaderboard(projectName, eventLog, leaderboardFrame, sortMetric);
        }
        DKV.put(leaderboard);
        return leaderboard;
    }

    public Leaderboard(String projectName, EventLog eventLog, Frame leaderboardFrame, String sortMetric) {
        super(Key.make(Leaderboard.idForProject(projectName)));
        this._project_name = projectName;
        this._eventlog_key = eventLog._key;
        this._leaderboard_frame_key = leaderboardFrame == null ? null : leaderboardFrame._key;
        this._leaderboard_frame_checksum = leaderboardFrame == null ? 0L : leaderboardFrame.checksum();
        this._sort_metric = sortMetric == null ? null : sortMetric.toLowerCase();
    }

    public void setExtensionsProvider(LeaderboardExtensionsProvider provider) {
        this._extensionsProvider = provider;
    }

    public String getProject() {
        return this._project_name;
    }

    public String getSortMetric() {
        return this._sort_metric;
    }

    public String[] getMetrics() {
        String[] stringArray;
        if (this._metrics == null) {
            if (this._sort_metric == null) {
                stringArray = new String[]{};
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = this._sort_metric;
            }
        } else {
            stringArray = this._metrics;
        }
        return stringArray;
    }

    public Frame leaderboardFrame() {
        return this._leaderboard_frame_key == null ? null : this._leaderboard_frame_key.get();
    }

    @Override
    public Key<Model>[] getModelKeys() {
        return this._model_keys;
    }

    @Override
    public int getModelCount() {
        return this.getModelKeys() == null ? 0 : this.getModelKeys().length;
    }

    public Model[] getModels() {
        if (this.getModelCount() == 0) {
            return new Model[0];
        }
        return Leaderboard.getModelsFromKeys(this.getModelKeys());
    }

    public Model[] getModelsSortedByMetric(String metric) {
        if (this.getModelCount() == 0) {
            return new Model[0];
        }
        return Leaderboard.getModelsFromKeys(this.sortModels(metric));
    }

    public Model getLeader() {
        if (this.getModelCount() == 0) {
            return null;
        }
        return this.getModelKeys()[0].get();
    }

    public int getModelRank(Key<Model> modelKey) {
        return ArrayUtils.find(this.getModelKeys(), modelKey) + 1;
    }

    public double[] getSortMetricValues() {
        return this._sort_metric == null ? null : (double[])this._metric_values.get(this._sort_metric);
    }

    public double[] getMetricValues(String metricName) {
        return (double[])this._metric_values.get(metricName);
    }

    private EventLog eventLog() {
        return this._eventlog_key.get();
    }

    private void setDefaultMetrics(Model m4) {
        int sortMetricIdx;
        this.write_lock();
        String[] metrics = Leaderboard.defaultMetricsForModel(m4);
        if (this._sort_metric == null) {
            String string = this._sort_metric = metrics.length > 0 ? metrics[0] : "mse";
        }
        if ((sortMetricIdx = ArrayUtils.find(metrics, this._sort_metric)) > 0) {
            metrics = ArrayUtils.remove(metrics, sortMetricIdx);
            metrics = ArrayUtils.prepend(metrics, this._sort_metric);
        } else if (sortMetricIdx < 0) {
            metrics = ArrayUtils.append(new String[]{this._sort_metric}, metrics);
        }
        this._metrics = metrics;
        this.update();
        this.unlock();
    }

    public ModelMetrics getOrCreateModelMetrics(Key<Model> modelKey) {
        return this.getOrCreateModelMetrics(modelKey, this.getExtensionsAsMap());
    }

    private ModelMetrics getOrCreateModelMetrics(Key<Model> modelKey, Map<Key<Model>, LeaderboardCell[]> extensions) {
        ModelMetrics mm4;
        Frame leaderboardFrame = this.leaderboardFrame();
        Model model = modelKey.get();
        if (leaderboardFrame == null) {
            mm4 = ModelMetrics.defaultModelMetrics(model);
        } else {
            LeaderboardCell scoringTimePerRow;
            mm4 = ModelMetrics.getFromDKV(model, leaderboardFrame);
            if (mm4 == null && (scoringTimePerRow = this.getExtension(modelKey, ScoringTimePerRow.COLUMN.getName(), extensions)) != null && scoringTimePerRow.getValue() == null) {
                scoringTimePerRow.fetch();
                mm4 = ModelMetrics.getFromDKV(model, leaderboardFrame);
            }
            if (mm4 == null) {
                model.score(leaderboardFrame).delete();
                mm4 = ModelMetrics.getFromDKV(model, leaderboardFrame);
            }
        }
        return mm4;
    }

    public void addModels(Key<Model>[] modelKeys) {
        if (modelKeys == null || modelKeys.length == 0) {
            return;
        }
        if (null == this._key) {
            throw new H2OIllegalArgumentException("Can't add models to a Leaderboard which isn't in the DKV.");
        }
        Key<Model>[] oldModelKeys = this._model_keys;
        Key<Model> oldLeaderKey = oldModelKeys == null || 0 == oldModelKeys.length ? null : oldModelKeys[0];
        HashSet<Key<Model>> uniques = new HashSet<Key<Model>>(Arrays.asList(ArrayUtils.append(oldModelKeys, modelKeys)));
        ArrayList<Key<Model>> allModelKeys = new ArrayList<Key<Model>>(uniques);
        HashSet<Key<Model>> newModelKeys = new HashSet<Key<Model>>(uniques);
        newModelKeys.removeAll(Arrays.asList(oldModelKeys));
        if (newModelKeys.isEmpty()) {
            return;
        }
        allModelKeys.forEach(DKV::prefetch);
        for (Key key : newModelKeys) {
            Model m4 = (Model)key.get();
            if (m4 == null) continue;
            this.eventLog().debug(EventLogEntry.Stage.ModelTraining, "Adding model " + key + " to leaderboard " + this._key + ". Training time: model=" + Math.round(((Model.Output)m4._output)._run_time / 1000L) + "s, total=" + Math.round(((Model.Output)m4._output)._total_run_time / 1000L) + "s");
        }
        ArrayList<ModelMetrics> modelMetrics = new ArrayList<ModelMetrics>();
        HashMap<Key<Model>, LeaderboardCell[]> hashMap = new HashMap<Key<Model>, LeaderboardCell[]>();
        ArrayList<Key> badKeys = new ArrayList<Key>();
        for (Key key : allModelKeys) {
            Model model = (Model)key.get();
            if (model == null) {
                badKeys.add(key);
                this.eventLog().warn(EventLogEntry.Stage.ModelTraining, "Model `" + key + "` has unexpectedly been deleted from H2O: ignoring the model and/or removing it from the leaderboard.");
                continue;
            }
            if (this._extensionsProvider != null) {
                hashMap.put(key, this._extensionsProvider.createExtensions(model));
            }
            ModelMetrics mm4 = this.getOrCreateModelMetrics(key, hashMap);
            assert (mm4 != null) : "Missing metrics for model " + key;
            if (mm4 == null) {
                badKeys.add(key);
                this.eventLog().warn(EventLogEntry.Stage.ModelTraining, "Metrics for model `" + key + "` are missing: ignoring the model and/or removing it from the leaderboard.");
                continue;
            }
            modelMetrics.add(mm4);
        }
        if (this._metrics == null) {
            this.setDefaultMetrics(modelKeys[0].get());
        }
        for (Key key : badKeys) {
            allModelKeys.remove(key);
            hashMap.remove(key);
        }
        this.atomicUpdate(() -> {
            this._leaderboard_model_metrics.clear();
            modelMetrics.forEach(this::addModelMetrics);
            this.updateModels(allModelKeys.toArray(new Key[0]));
            this._extensions_cells = new LeaderboardCell[0];
            extensions.forEach(this::addExtensions);
        }, null);
        if (oldLeaderKey == null || !oldLeaderKey.equals(this._model_keys[0])) {
            this.eventLog().info(EventLogEntry.Stage.ModelTraining, "New leader: " + this._model_keys[0] + ", " + this._sort_metric + ": " + ((double[])this._metric_values.get(this._sort_metric))[0]);
        }
    }

    public void removeModels(Key<Model>[] modelKeys, boolean cascade) {
        if (modelKeys == null || modelKeys.length == 0 || Arrays.stream(modelKeys).noneMatch(k2 -> ArrayUtils.contains(this._model_keys, k2))) {
            return;
        }
        Arrays.stream(modelKeys).filter(k2 -> ArrayUtils.contains(this._model_keys, k2)).forEach(k2 -> this.eventLog().debug(EventLogEntry.Stage.ModelTraining, "Removing model " + k2 + " from leaderboard " + this._key));
        Key[] remainingKeys = (Key[])Arrays.stream(this._model_keys).filter(k2 -> !ArrayUtils.contains(modelKeys, k2)).toArray(Key[]::new);
        this.atomicUpdate(() -> {
            this._model_keys = new Key[0];
            this.addModels(remainingKeys);
        }, null);
        if (cascade) {
            for (Key<Model> key : modelKeys) {
                Keyed.remove(key);
            }
        }
    }

    private void updateModels(Key<Model>[] modelKeys) {
        Key<Model>[] sortedModelKeys = this.sortModelKeys(modelKeys);
        Model[] sortedModels = Leaderboard.getModelsFromKeys(sortedModelKeys);
        IcedHashMap<String, double[]> metricValues = new IcedHashMap<String, double[]>();
        for (String metric : this._metrics) {
            metricValues.put(metric, this.getMetrics(metric, sortedModels));
        }
        this._metric_values = metricValues;
        this._model_keys = sortedModelKeys;
    }

    private void atomicUpdate(Runnable update, Key<Job> jobKey) {
        DKVUtils.atomicUpdate(this, update, jobKey, this.lock);
    }

    public <M extends Model> void addModel(Key<M> key) {
        if (key == null) {
            return;
        }
        this.addModels(new Key[]{key});
    }

    public <M extends Model> void removeModel(Key<M> key, boolean cascade) {
        if (key == null) {
            return;
        }
        this.removeModels(new Key[]{key}, cascade);
    }

    private void addModelMetrics(ModelMetrics modelMetrics) {
        if (modelMetrics != null) {
            this._leaderboard_model_metrics.put(modelMetrics._key, modelMetrics);
        }
    }

    private <M extends Model> void addExtensions(Key<M> key, LeaderboardCell ... extensions) {
        if (key == null) {
            return;
        }
        assert (ArrayUtils.contains(this._model_keys, key));
        LeaderboardCell[] toAdd = (LeaderboardCell[])Stream.of(extensions).filter(lc -> this.getExtension(key, lc.getColumn().getName()) == null).toArray(LeaderboardCell[]::new);
        this._extensions_cells = ArrayUtils.append(this._extensions_cells, toAdd);
    }

    /*
     * Exception decompiling
     */
    public Map<Key<Model>, LeaderboardCell[]> getExtensionsAsMap() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private <M extends Model> LeaderboardCell[] getExtensions(Key<M> key) {
        return (LeaderboardCell[])Stream.of(this._extensions_cells).filter(c2 -> c2.getModelId().equals(key)).toArray(LeaderboardCell[]::new);
    }

    private <M extends Model> LeaderboardCell getExtension(Key<M> key, String extName) {
        return this.getExtension(key, extName, Collections.singletonMap(key, this.getExtensions(key)));
    }

    private <M extends Model> LeaderboardCell getExtension(Key<M> key, String extName, Map<Key<Model>, LeaderboardCell[]> extensions) {
        if (extensions != null && extensions.containsKey(key)) {
            return Stream.of((Object[])extensions.get(key)).filter(le -> le.getColumn().getName().equals(extName)).findFirst().orElse(null);
        }
        return null;
    }

    private static Model[] getModelsFromKeys(Key<Model>[] modelKeys) {
        Model[] models = new Model[modelKeys.length];
        int i2 = 0;
        for (Key<Model> modelKey : modelKeys) {
            models[i2++] = (Model)DKV.getGet(modelKey);
        }
        return models;
    }

    private Key<Model>[] sortModels(String metric) {
        Key<Model>[] models = this.getModelKeys();
        boolean decreasing = !Leaderboard.isLossFunction(metric);
        List<Key<Model>> newModelsSorted = ModelMetrics.sortModelsByMetric(metric, decreasing, Arrays.asList(models));
        return newModelsSorted.toArray(new Key[0]);
    }

    private Key<Model>[] sortModelKeys(Key<Model>[] modelKeys) {
        List<Key<Model>> sortedModelKeys;
        boolean sortDecreasing = !Leaderboard.isLossFunction(this._sort_metric);
        Frame leaderboardFrame = this.leaderboardFrame();
        try {
            sortedModelKeys = leaderboardFrame == null ? ModelMetrics.sortModelsByMetric(this._sort_metric, sortDecreasing, Arrays.asList(modelKeys)) : ModelMetrics.sortModelsByMetric(leaderboardFrame, this._sort_metric, sortDecreasing, Arrays.asList(modelKeys));
        }
        catch (H2OIllegalArgumentException e2) {
            log.warn("ModelMetrics.sortModelsByMetric failed: " + e2);
            throw e2;
        }
        return sortedModelKeys.toArray(new Key[0]);
    }

    private double[] getMetrics(String metric, Model[] models) {
        double[] metrics = new double[models.length];
        int i2 = 0;
        Frame leaderboardFrame = this.leaderboardFrame();
        for (Model m4 : models) {
            if (leaderboardFrame != null) {
                metrics[i2++] = ModelMetrics.getMetricFromModelMetric((ModelMetrics)this._leaderboard_model_metrics.get(ModelMetrics.buildKey(m4, leaderboardFrame)), metric);
                continue;
            }
            Key model_key = m4._key;
            long model_checksum = m4.checksum();
            ModelMetrics mm4 = ModelMetrics.defaultModelMetrics(m4);
            metrics[i2++] = ModelMetrics.getMetricFromModelMetric((ModelMetrics)this._leaderboard_model_metrics.get(ModelMetrics.buildKey(model_key, model_checksum, mm4.frame()._key, mm4.frame().checksum())), metric);
        }
        return metrics;
    }

    @Override
    protected Futures remove_impl(Futures fs, boolean cascade) {
        log.debug("Cleaning up leaderboard from models " + Arrays.toString(this._model_keys));
        if (cascade) {
            for (Key<Model> m4 : this._model_keys) {
                Keyed.remove(m4, fs, true);
            }
        }
        for (Key k2 : this._leaderboard_model_metrics.keySet()) {
            Keyed.remove(k2, fs, true);
        }
        return super.remove_impl(fs, cascade);
    }

    private static String[] defaultMetricsForModel(Model m4) {
        if (((Model.Output)m4._output).isBinomialClassifier()) {
            return new String[]{"auc", "logloss", "aucpr", "mean_per_class_error", "rmse", "mse"};
        }
        if (((Model.Output)m4._output).isMultinomialClassifier()) {
            return new String[]{"mean_per_class_error", "logloss", "rmse", "mse"};
        }
        if (((Model.Output)m4._output).isSupervised()) {
            return new String[]{"rmse", "mse", "mae", "rmsle", "mean_residual_deviance"};
        }
        return new String[0];
    }

    private double[] getModelMetricValues(int rank) {
        assert (rank >= 0 && rank < this.getModelKeys().length) : "invalid rank";
        if (this._metrics == null) {
            return new double[0];
        }
        double[] values = new double[this._metrics.length];
        for (int i2 = 0; i2 < this._metrics.length; ++i2) {
            values[i2] = ((double[])this._metric_values.get(this._metrics[i2]))[rank];
        }
        return values;
    }

    String rankTsv() {
        String lineSeparator = "\n";
        StringBuilder sb = new StringBuilder();
        sb.append("Error").append(lineSeparator);
        for (int i2 = this.getModelKeys().length - 1; i2 >= 0; --i2) {
            sb.append(Arrays.toString(this.getModelMetricValues(i2)));
            sb.append(lineSeparator);
        }
        return sb.toString();
    }

    private TwoDimTable makeTwoDimTable(String tableHeader, int nrows, LeaderboardColumn ... columns) {
        assert (columns.length > 0);
        assert (this._sort_metric != null || nrows == 0) : "sort_metrics needs to be always not-null for non-empty array!";
        String description = nrows > 0 ? "models sorted in order of " + this._sort_metric + ", best first" : "no models in this leaderboard";
        String[] rowHeaders = new String[nrows];
        for (int i2 = 0; i2 < nrows; ++i2) {
            rowHeaders[i2] = "" + i2;
        }
        String[] colHeaders = (String[])Stream.of(columns).map(LeaderboardColumn::getName).toArray(String[]::new);
        String[] colTypes = (String[])Stream.of(columns).map(LeaderboardColumn::getType).toArray(String[]::new);
        String[] colFormats = (String[])Stream.of(columns).map(LeaderboardColumn::getFormat).toArray(String[]::new);
        String colHeaderForRowHeader = nrows > 0 ? "#" : "-";
        return new TwoDimTable(tableHeader, description, rowHeaders, colHeaders, colTypes, colFormats, colHeaderForRowHeader);
    }

    private void addTwoDimTableRow(TwoDimTable table, int row, String modelID, String[] metrics, LeaderboardCell[] extensions) {
        int col = 0;
        table.set(row, col++, modelID);
        for (String metric : metrics) {
            double value = ((double[])this._metric_values.get(metric))[row];
            table.set(row, col++, value);
        }
        for (LeaderboardCell extension : extensions) {
            if (extension != null) {
                Object value;
                Object v2 = value = extension.getValue() == null ? extension.fetch() : extension.getValue();
                if (!extension.isNA()) {
                    table.set(row, col, value);
                }
            }
            ++col;
        }
    }

    public TwoDimTable toTwoDimTable(String ... extensions) {
        return this.toTwoDimTable("Leaderboard for project " + this._project_name, false, extensions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TwoDimTable toTwoDimTable(String tableHeader, boolean leftJustifyModelIds, String ... extensions) {
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        if (readLock.tryLock()) {
            try {
                Key[] modelKeys = (Key[])this._model_keys.clone();
                List<LeaderboardColumn> columns = this.getDefaultTableColumns();
                ArrayList extColumns = new ArrayList();
                if (this.getModelCount() > 0) {
                    Key<Model> leader = this.getModelKeys()[0];
                    LeaderboardCell[] extCells = extensions.length > 0 && "ALL".equalsIgnoreCase(extensions[0]) ? (LeaderboardCell[])Stream.of(this.getExtensions(leader)).filter(cell -> !cell.getColumn().isHidden()).toArray(LeaderboardCell[]::new) : (LeaderboardCell[])Stream.of(extensions).map(e2 -> this.getExtension((Key)leader, (String)e2)).toArray(LeaderboardCell[]::new);
                    Stream.of(extCells).filter(Objects::nonNull).forEach(e2 -> extColumns.add(e2.getColumn()));
                }
                columns.addAll(extColumns);
                TwoDimTable table = this.makeTwoDimTable(tableHeader, modelKeys.length, columns.toArray(new LeaderboardColumn[0]));
                int maxModelIdLen = Stream.of(modelKeys).mapToInt(k2 -> k2.toString().length()).max().orElse(0);
                String[] modelIDsFormatted = new String[modelKeys.length];
                for (int i2 = 0; i2 < modelKeys.length; ++i2) {
                    Key key = modelKeys[i2];
                    modelIDsFormatted[i2] = leftJustifyModelIds ? StringUtils.rightPad((String)key.toString(), (int)maxModelIdLen) : key.toString();
                    this.addTwoDimTableRow(table, i2, modelIDsFormatted[i2], this.getMetrics(), (LeaderboardCell[])extColumns.stream().map(ext -> this.getExtension(key, ext.getName())).toArray(LeaderboardCell[]::new));
                }
                TwoDimTable twoDimTable = table;
                return twoDimTable;
            }
            finally {
                readLock.unlock();
            }
        }
        return this.makeTwoDimTable(tableHeader, 0, this.getDefaultTableColumns().toArray(new LeaderboardColumn[0]));
    }

    private List<LeaderboardColumn> getDefaultTableColumns() {
        ArrayList<LeaderboardColumn> columns = new ArrayList<LeaderboardColumn>();
        columns.add(ModelId.COLUMN);
        for (String metric : this.getMetrics()) {
            columns.add(MetricScore.getColumn(metric));
        }
        return columns;
    }

    private String toString(String fieldSeparator, String lineSeparator, boolean includeTitle, boolean includeHeader) {
        StringBuilder sb = new StringBuilder();
        if (includeTitle) {
            sb.append("Leaderboard for project \"").append(this._project_name).append("\": ");
            if (this._model_keys.length == 0) {
                sb.append("<empty>");
                return sb.toString();
            }
            sb.append(lineSeparator);
        }
        boolean printedHeader = false;
        for (int i2 = 0; i2 < this._model_keys.length; ++i2) {
            Key<Model> key = this._model_keys[i2];
            if (includeHeader && !printedHeader) {
                sb.append("model_id");
                sb.append(fieldSeparator);
                Object[] metrics = this._metrics != null ? this._metrics : new String[]{};
                sb.append(Arrays.toString(metrics));
                sb.append(lineSeparator);
                printedHeader = true;
            }
            sb.append(key.toString());
            sb.append(fieldSeparator);
            double[] values = this._metrics != null ? this.getModelMetricValues(i2) : new double[]{};
            sb.append(Arrays.toString(values));
            sb.append(lineSeparator);
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(" ; ", " | ", true, true);
    }

    public String toLogString() {
        return this.toTwoDimTable("Leaderboard for project " + this._project_name, true, new String[0]).toString();
    }

    private static /* synthetic */ LeaderboardCell[] lambda$getExtensionsAsMap$11(LeaderboardCell[] lhs, LeaderboardCell[] rhs) {
        return ArrayUtils.append(lhs, rhs);
    }
}

