/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.automl.events;

import ai.h2o.automl.events.EventLogEntry;
import java.io.Serializable;
import java.util.function.Predicate;
import java.util.stream.Stream;
import water.DKV;
import water.Futures;
import water.Key;
import water.Keyed;
import water.logging.Logger;
import water.logging.LoggerFactory;
import water.logging.LoggingLevel;
import water.util.TwoDimTable;

public class EventLog
extends Keyed<EventLog> {
    private static final Logger log = LoggerFactory.getLogger(EventLog.class);
    public final Key _runner_id;
    public EventLogEntry[] _events;

    public EventLog(Key runKey) {
        this._runner_id = runKey;
        this._key = Key.make(EventLog.idForRun(runKey));
        this._events = new EventLogEntry[0];
    }

    public static EventLog getOrMake(Key runKey) {
        EventLog eventLog = (EventLog)DKV.getGet(Key.make(EventLog.idForRun(runKey)));
        if (null == eventLog) {
            eventLog = new EventLog(runKey);
        }
        DKV.put(eventLog);
        return eventLog;
    }

    private static String idForRun(Key runKey) {
        if (null == runKey) {
            return "Events_dummy";
        }
        return "Events_" + runKey.toString();
    }

    public <V extends Serializable> EventLogEntry<V> debug(EventLogEntry.Stage stage, String message) {
        log.debug((Object)((Object)stage) + ": " + message);
        return this.addEvent(LoggingLevel.DEBUG, stage, message);
    }

    public <V extends Serializable> EventLogEntry<V> info(EventLogEntry.Stage stage, String message) {
        log.info((Object)((Object)stage) + ": " + message);
        return this.addEvent(LoggingLevel.INFO, stage, message);
    }

    public <V extends Serializable> EventLogEntry<V> warn(EventLogEntry.Stage stage, String message) {
        log.warn((Object)((Object)stage) + ": " + message);
        return this.addEvent(LoggingLevel.WARN, stage, message);
    }

    public <V extends Serializable> EventLogEntry<V> error(EventLogEntry.Stage stage, String message) {
        log.error((Object)((Object)stage) + ": " + message);
        return this.addEvent(LoggingLevel.ERROR, stage, message);
    }

    public <V extends Serializable> EventLogEntry<V> addEvent(LoggingLevel level, EventLogEntry.Stage stage, String message) {
        EventLogEntry entry = new EventLogEntry(this._runner_id, level, stage, message);
        this.addEvent(entry);
        return entry;
    }

    public void addEvent(EventLogEntry event) {
        EventLogEntry[] oldEvents = this._events;
        EventLogEntry[] newEvents = new EventLogEntry[this._events.length + 1];
        System.arraycopy(oldEvents, 0, newEvents, 0, oldEvents.length);
        newEvents[oldEvents.length] = event;
        this._events = newEvents;
    }

    @Override
    protected Futures remove_impl(Futures fs, boolean cascade) {
        this._events = new EventLogEntry[0];
        return super.remove_impl(fs, cascade);
    }

    public TwoDimTable toTwoDimTable() {
        return this.toTwoDimTable(null);
    }

    public TwoDimTable toTwoDimTable(Predicate<EventLogEntry> predicate) {
        String name = this._runner_id == null ? "(new)" : this._runner_id.toString();
        return this.toTwoDimTable("Event Log for:" + name, predicate);
    }

    public TwoDimTable toTwoDimTable(String tableHeader, Predicate<EventLogEntry> predicate) {
        EventLogEntry[] events = predicate == null ? (EventLogEntry[])this._events.clone() : (EventLogEntry[])Stream.of((Object[])this._events.clone()).filter(predicate).toArray(EventLogEntry[]::new);
        TwoDimTable table = EventLogEntry.makeTwoDimTable(tableHeader, events.length);
        for (int i2 = 0; i2 < events.length; ++i2) {
            events[i2].addTwoDimTableRow(table, i2);
        }
        return table;
    }

    public String toString() {
        return this.toTwoDimTable().toString();
    }
}

