/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.automl;

import ai.h2o.automl.H2ORunnable;
import water.H2O;
import water.Job;
import water.Key;
import water.Keyed;

public class H2OJob<T extends Keyed> {
    protected final T _target;
    protected Key<Job> _jobKey;
    Job<T> _job;

    public H2OJob(T runnable, long max_runtime_msecs) {
        this(runnable, Key.make(), max_runtime_msecs);
    }

    public H2OJob(T runnable, Key<T> key, long max_runtime_msecs) {
        this._target = runnable;
        this._job = new Job<T>(key, this._target.getClass().getName(), this._target.getClass().getSimpleName() + " build");
        this._jobKey = this._job._key;
        this._job._max_runtime_msecs = max_runtime_msecs;
    }

    public Job<T> start() {
        return this.start(1);
    }

    public Job<T> start(int work) {
        return this._job.start(new H2O.H2OCountedCompleter(){

            @Override
            public void compute2() {
                ((H2ORunnable)H2OJob.this._target).run();
                this.tryComplete();
            }
        }, work);
    }

    public void stop() {
        this._jobKey.get().stop();
    }
}

