/*
 * Decompiled with CFR 0.152.
 */
package Jama;

import Jama.Matrix;
import java.io.Serializable;

public class CholeskyDecomposition
implements Serializable {
    private double[][] L;
    private int n;
    private boolean isspd;
    private static final long serialVersionUID = 1L;

    public CholeskyDecomposition(Matrix matrix) {
        double[][] dArray = matrix.getArray();
        this.n = matrix.getRowDimension();
        this.L = new double[this.n][this.n];
        this.isspd = matrix.getColumnDimension() == this.n;
        for (int i2 = 0; i2 < this.n; ++i2) {
            int n2;
            double[] dArray2 = this.L[i2];
            double d2 = 0.0;
            for (n2 = 0; n2 < i2; ++n2) {
                double[] dArray3 = this.L[n2];
                double d3 = 0.0;
                for (int i3 = 0; i3 < n2; ++i3) {
                    d3 += dArray3[i3] * dArray2[i3];
                }
                dArray2[n2] = d3 = (dArray[i2][n2] - d3) / this.L[n2][n2];
                d2 += d3 * d3;
                this.isspd &= dArray[n2][i2] == dArray[i2][n2];
            }
            this.isspd &= (d2 = dArray[i2][i2] - d2) > 0.0;
            this.L[i2][i2] = Math.sqrt(Math.max(d2, 0.0));
            for (n2 = i2 + 1; n2 < this.n; ++n2) {
                this.L[i2][n2] = 0.0;
            }
        }
    }

    public boolean isSPD() {
        return this.isspd;
    }

    public Matrix getL() {
        return new Matrix(this.L, this.n, this.n);
    }

    public Matrix solve(Matrix matrix) {
        int n2;
        int n3;
        int n4;
        if (matrix.getRowDimension() != this.n) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isspd) {
            throw new RuntimeException("Matrix is not symmetric positive definite.");
        }
        double[][] dArray = matrix.getArrayCopy();
        int n5 = matrix.getColumnDimension();
        for (n4 = 0; n4 < this.n; ++n4) {
            n3 = 0;
            while (n3 < n5) {
                for (n2 = 0; n2 < n4; ++n2) {
                    double[] dArray2 = dArray[n4];
                    int n6 = n3;
                    dArray2[n6] = dArray2[n6] - dArray[n2][n3] * this.L[n4][n2];
                }
                double[] dArray3 = dArray[n4];
                int n7 = n3++;
                dArray3[n7] = dArray3[n7] / this.L[n4][n4];
            }
        }
        for (n4 = this.n - 1; n4 >= 0; --n4) {
            n3 = 0;
            while (n3 < n5) {
                for (n2 = n4 + 1; n2 < this.n; ++n2) {
                    double[] dArray4 = dArray[n4];
                    int n8 = n3;
                    dArray4[n8] = dArray4[n8] - dArray[n2][n3] * this.L[n2][n4];
                }
                double[] dArray5 = dArray[n4];
                int n9 = n3++;
                dArray5[n9] = dArray5[n9] / this.L[n4][n4];
            }
        }
        return new Matrix(dArray, this.n, n5);
    }
}

