from aws_cdk import ( 
    aws_iam as iam
)  


##
## IAM
def createIAMServiceRole(self, svc_role_dictionary): 
    svc_role_name = svc_role_dictionary["service_role_name"]
    svc_role_description = svc_role_dictionary["service_role_description"]
    svc_role_principal = svc_role_dictionary["service_role_principal"]
    svc_role_permissions = svc_role_dictionary["service_role_permissions"]
    role = iam.Role(self, svc_role_name,
        assumed_by=iam.ServicePrincipal(svc_role_principal),
        role_name=svc_role_name,
        description=svc_role_description
    )
    for policy_statement in svc_role_permissions:
        policy_sid = policy_statement["Sid"]
        policy_effect = policy_statement["Effect"]
        policy_actions = policy_statement["Action"]
        policy_resources = policy_statement["Resource"]
        if policy_effect == "Allow":
            policy_effect = iam.Effect.ALLOW
        if policy_effect == "Deny":
            policy_effect = iam.Effect.DENY
        role.add_to_policy(iam.PolicyStatement(
                sid=policy_sid,
                effect=policy_effect,
                resources=policy_resources,
                actions=policy_actions
            ))
    return role