# `dag-cbor`: A Python implementation of [DAG-CBOR](https://ipld.io/specs/codecs/dag-cbor/spec/)

[![Generic badge](https://img.shields.io/badge/python-3.7+-green.svg)](https://docs.python.org/3.7/)
![PyPI version shields.io](https://img.shields.io/pypi/v/dag-cbor.svg)
[![PyPI status](https://img.shields.io/pypi/status/dag-cbor.svg)](https://pypi.python.org/pypi/dag-cbor/)
[![Checked with Mypy](http://www.mypy-lang.org/static/mypy_badge.svg)](https://github.com/python/mypy)
[![Python package](https://github.com/hashberg-io/dag-cbor/actions/workflows/python-pytest.yml/badge.svg)](https://github.com/hashberg-io/dag-cbor/actions/workflows/python-pytest.yml)
[![standard-readme compliant](https://img.shields.io/badge/readme%20style-standard-brightgreen.svg?style=flat-square)](https://github.com/RichardLitt/standard-readme)


This is a fully compliant Python implementation of the [DAG-CBOR codec](https://ipld.io/specs/codecs/dag-cbor/spec/), a subset of the [Concise Binary Object Representation (CBOR)](https://cbor.io/) supporting the [IPLD Data Model](https://ipld.io/docs/data-model/) and enforcing a unique (strict) encoded representation of items.


## Table of Contents

- [Install](#install)
- [Usage](#usage)
- [API](#api)
- [Contributing](#contributing)
- [License](#license)


## Install

You can install the latest release from PyPI as follows:

```
pip install --upgrade dag-cbor
```


## Usage

The core functionality of the library is performed by the [`encode`](https://hashberg-io.github.io/dag-cbor/dag_cbor/encoding.html#dag_cbor.encoding.encode) and [`decode`](https://hashberg-io.github.io/dag-cbor/dag_cbor/decoding.html#dag_cbor.decoding.decode) functions:

```python
>>> import dag_cbor
>>> dag_cbor.encode({'a': 12, 'b': 'hello!'})
b'\xa2aa\x0cabfhello!'
>>> dag_cbor.decode(b'\xa2aa\x0cabfhello!')
{'a': 12, 'b': 'hello!'}
```

The [`random`](https://hashberg-io.github.io/dag-cbor/dag_cbor/random.html) module contains functions to generate random data compatible with DAG-CBOR encoding:

```python
>>> import pprint
>>> import dag_cbor
>>> options = dict(min_codepoint=0x41, max_codepoint=0x5a, include_cid=False)
>>> with dag_cbor.random.rand_options(**options):
...     for d in dag_cbor.random.rand_dict(3):
...             pprint.pp(d)
...
{'BIQPMZ': b'\x85\x1f\x07/\xcc\x00\xfc\xaa',
 'EJEYDTZI': {},
 'PLSG': {'G': 'JFG',
          'HZE': -61.278,
          'JWDRKRGZ': b'-',
          'OCCKQPDJ': True,
          'SJOCTZMK': False},
 'PRDLN': 39.129,
 'TUGRP': None,
 'WZTEJDXC': -69.933}
{'GHAXI': 39.12,
 'PVUWZLC': 4.523,
 'TDPSU': 'TVCADUGT',
 'ZHGVSNSI': [-57, 9, -78.312]}
{'': 11, 'B': True, 'FWD': {}, 'GXZBVAR': 'BTDWMGI', 'TDICHC': 87}
```

For further information, please refer to the [API documentation](https://hashberg-io.github.io/dag-cbor/dag_cbor/index.html).


## API

The [API documentation](https://hashberg-io.github.io/dag-cbor/dag_cbor/index.html) for this package is automatically generated by [pdoc](https://pdoc3.github.io/pdoc/).


## Contributing

Please see [the contributing file](./CONTRIBUTING.md).


## License

[MIT © Hashberg Ltd.](LICENSE)
