<p align="center">
<img src="https://user-images.githubusercontent.com/79968466/149683786-52ad7fc8-df64-4778-8381-35663c100c77.png" align="center" width="50%" alt="onepredict logo">

<!-- ALL-CONTRIBUTORS-BADGE:START - Do not remove or modify this section -->
[![All Contributors](https://img.shields.io/badge/all_contributors-9-orange.svg?style=flat-square)](#contributors-)
<!-- ALL-CONTRIBUTORS-BADGE:END -->

# Summary

`onebone` is an open-source software for signal analysis about predictive maintenance, being used for research activities at [ⓒ ONEPREDICT Corp.](https://onepredict.ai/). It includes modules for preprocessing, health feature, and more. If you need to analyze signals for industrial equipments like turbines, a rotary machinery or componets like gears, bearings, give onebone a try!.

The directory is as follows:

```text
.
├── docs
├── onebone
│ ├── feature
│ ├── math
│ ├── preprocessing
│ ├── signal
│ └── utils
├── tests
├── tools
├── README.md
├── Makefile
└── pyproject.toml
```

## Documentation

<!--TODO: Changes the documentation link to public accessible link.-->
<!--TODO: Add the reference for modules like this link(https://numpy.org/doc/stable/reference/index.html)-->

This reference manual details functions included in onebone, describing what they are and what they do. For learning how to use onebone, see the complete [documentation](http://10.10.30.16/).

# Contributors ✨

Thanks goes to these wonderful people ([emoji key](https://allcontributors.org/docs/en/emoji-key)):

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->
<table>
  <tr>
    <td align="center"><a href="https://github.com/kyunghwan-onepredict"><img src="https://avatars.githubusercontent.com/u/86699249?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Kyunghwan Kim</b></sub></a><br /><a href="https://github.com/Onepredict/onebone/commits?author=kyunghwan-onepredict" title="Code">💻</a> <a href="https://github.com/Onepredict/onebone/commits?author=kyunghwan-onepredict" title="Documentation">📖</a> <a href="https://github.com/Onepredict/onebone/pulls?q=is%3Apr+reviewed-by%3Akyunghwan-onepredict" title="Reviewed Pull Requests">👀</a></td>
    <td align="center"><a href="https://github.com/Kangwhi-Kim"><img src="https://avatars.githubusercontent.com/u/79968466?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Kangwhi Kim</b></sub></a><br /><a href="https://github.com/Onepredict/onebone/commits?author=Kangwhi-Kim" title="Code">💻</a> <a href="https://github.com/Onepredict/onebone/commits?author=Kangwhi-Kim" title="Documentation">📖</a> <a href="https://github.com/Onepredict/onebone/pulls?q=is%3Apr+reviewed-by%3AKangwhi-Kim" title="Reviewed Pull Requests">👀</a></td>
    <td align="center"><a href="https://github.com/DaeyeopN"><img src="https://avatars.githubusercontent.com/u/80095250?v=4?s=100" width="100px;" alt=""/><br /><sub><b>DaeyeopN</b></sub></a><br /><a href="https://github.com/Onepredict/onebone/commits?author=DaeyeopN" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/isingmodel"><img src="https://avatars.githubusercontent.com/u/31462012?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Kibum Fred Kim</b></sub></a><br /><a href="https://github.com/Onepredict/onebone/commits?author=isingmodel" title="Code">💻</a><a href="https://github.com/Onepredict/onebone/pulls?q=is%3Apr+reviewed-by%3Aisingmodel" title="Reviewed Pull Requests">👀</a></td>
    <td align="center"><a href="https://github.com/kbpark-onepredict"><img src="https://avatars.githubusercontent.com/u/67666211?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Kibum Park</b></sub></a><br /><a href="https://github.com/Onepredict/onebone/commits?author=kbpark-onepredict" title="Code">💻</a> <a href="https://github.com/Onepredict/onebone/pulls?q=is%3Apr+reviewed-by%3Akbpark-onepredict" title="Reviewed Pull Requests">👀</a></td>
    <td align="center"><a href="https://github.com/seone-kim"><img src="https://avatars.githubusercontent.com/u/91518385?v=4?s=100" width="100px;" alt=""/><br /><sub><b>sewon.kim</b></sub></a><br /><a href="https://github.com/Onepredict/onebone/commits?author=seone-kim" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/jeonjuna"><img src="https://avatars.githubusercontent.com/u/88358071?v=4?s=100" width="100px;" alt=""/><br /><sub><b>jeonjuna</b></sub></a><br /><a href="https://github.com/Onepredict/onebone/commits?author=jeonjuna" title="Code">💻</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/akangel0307"><img src="https://avatars.githubusercontent.com/u/92007351?v=4?s=100" width="100px;" alt=""/><br /><sub><b>SunjinKim</b></sub></a><br /><a href="https://github.com/Onepredict/onebone/commits?author=akangel0307" title="Code">💻</a></td>
    <td align="center"><a href="https://github.com/hjkim-onepredict"><img src="https://avatars.githubusercontent.com/u/67408278?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Hyunjae Kim</b></sub></a><br /><a href="https://github.com/Onepredict/onebone/commits?author=hjkim-onepredict" title="Code">💻</a></td>
  </tr>
</table>

<!-- markdownlint-restore -->
<!-- prettier-ignore-end -->

<!-- ALL-CONTRIBUTORS-LIST:END -->

This project follows the [all-contributors](https://github.com/all-contributors/all-contributors) specification. Contributions of any kind welcome!

# Getting started

## Prerequisite

onebone requires Python 3.6.5+.

## Installation

<!--TODO: Register onebone on the pypi server.-->

onebone can be installed via pip from [PyPI](https://pypi.org/)

```bash
$ pip install --extra-index-url http://10.10.30.16:8008 --trusted-host 10.10.30.16:8008 onebone
```

It can be checked as follows whether the onebone has been installed.

```python
>>> import onebone
>>> onebone.__version__
```

## Usage

It assumes that the user has already installed the onebone package.

You can import directly the function, for example:

```python
>>> from onebone.feature import tacho_to_rpm
```

# Call for contribute

We appreciate and welcome contributions. Small improvements or fixes are always appreciated; issues labeled as "good first issue" may be a good starting point.

Writing code isn't the only way to contribute to onebone. You can also:

- triage issues
- review pull requests
- help with outreach and onboard new contributors

If you're unsure where to start or how your skills fit in, reach out! You can ask here, on GitHub, by leaving a comment on a relevant issue that is already open.

If you want to use an code for signal analysis, but it's not in onebone, make a issue.

If you are new to contributing to open source, [this guide](https://opensource.guide/how-to-contribute/) helps explain why, what, and how to get involved.

If you want to contribute onebone, follow [this guide](https://github.com/Onepredict/onebone/blob/main/wiki/development_guide.md).

# References

- [Numpy](https://numpy.org/)
- [Scipy](https://scipy.org/)
- [Matlab](https://www.mathworks.com/help/index.html?s_tid=CRUX_lftnav)
