# coding: utf-8


"""
IGNORE:
    Nutanix Clustermgmt Versioned APIs

    Manage Hosts, Clusters and other Infrastructure.  # noqa: E501

    OpenAPI spec version: 4.0.2-alpha-2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ntnx_clustermgmt_py_client.api_client import ApiClient


class ClusterApi(object):
    """IGNORE:
    NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    IGNORE
    """ # noqa: E501

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_node(self, body, clusterExtId, **kwargs):  # noqa: E501
        """Add node on a cluster
        Add node on a cluster

        >>> response = api.add_node(body, clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_node(body, clusterExtId, async_req=True)
        >>> result = thread.get()

        :param clustermgmt.v4.config.ExpandClusterParams body: Property of the node to be added (required)
        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.AddNodeTaskResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_node_with_http_info(body, clusterExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.add_node_with_http_info(body, clusterExtId, **kwargs)  # noqa: E501
            return data

    def add_node_with_http_info(self, body, clusterExtId, **kwargs):  # noqa: E501
        """Add node on a cluster
        Add node on a cluster

        >>> response = api.add_node(body, clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_node_with_http_info(body, clusterExtId, async_req=True)
        >>> result = thread.get()

        :param clustermgmt.v4.config.ExpandClusterParams body: Property of the node to be added (required)
        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.AddNodeTaskResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'clusterExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_node" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_node`")  # noqa: E501
        # verify the required parameter 'clusterExtId' is set
        if ('clusterExtId' not in params or
                params['clusterExtId'] is None):
            raise ValueError("Missing the required parameter `clusterExtId` when calling `add_node`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'clusterExtId' in params:
            path_params['clusterExtId'] = params['clusterExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a2/config/clusters/{clusterExtId}/$actions/expand-cluster', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.AddNodeTaskResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_rsyslog_server(self, body, clusterExtId, **kwargs):  # noqa: E501
        """Add new RSYSLOG server configuration
        Add new RSYSLOG server configuration

        >>> response = api.add_rsyslog_server(body, clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_rsyslog_server(body, clusterExtId, async_req=True)
        >>> result = thread.get()

        :param clustermgmt.v4.config.RsyslogServer body: RSYSLOG server to add (required)
        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.AddRsyslogServerTaskApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_rsyslog_server_with_http_info(body, clusterExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.add_rsyslog_server_with_http_info(body, clusterExtId, **kwargs)  # noqa: E501
            return data

    def add_rsyslog_server_with_http_info(self, body, clusterExtId, **kwargs):  # noqa: E501
        """Add new RSYSLOG server configuration
        Add new RSYSLOG server configuration

        >>> response = api.add_rsyslog_server(body, clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_rsyslog_server_with_http_info(body, clusterExtId, async_req=True)
        >>> result = thread.get()

        :param clustermgmt.v4.config.RsyslogServer body: RSYSLOG server to add (required)
        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.AddRsyslogServerTaskApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'clusterExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_rsyslog_server" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_rsyslog_server`")  # noqa: E501
        # verify the required parameter 'clusterExtId' is set
        if ('clusterExtId' not in params or
                params['clusterExtId'] is None):
            raise ValueError("Missing the required parameter `clusterExtId` when calling `add_rsyslog_server`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'clusterExtId' in params:
            path_params['clusterExtId'] = params['clusterExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a2/config/clusters/{clusterExtId}/rsyslog-servers', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.AddRsyslogServerTaskApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_snmp_transport(self, body, clusterExtId, **kwargs):  # noqa: E501
        """Add SNMP transports
        Add SNMP transports

        >>> response = api.add_snmp_transport(body, clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_snmp_transport(body, clusterExtId, async_req=True)
        >>> result = thread.get()

        :param list[clustermgmt.v4.config.SnmpTransport] body: SNMP transports to add (required)
        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.AddSnmpTransportsTaskApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_snmp_transport_with_http_info(body, clusterExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.add_snmp_transport_with_http_info(body, clusterExtId, **kwargs)  # noqa: E501
            return data

    def add_snmp_transport_with_http_info(self, body, clusterExtId, **kwargs):  # noqa: E501
        """Add SNMP transports
        Add SNMP transports

        >>> response = api.add_snmp_transport(body, clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_snmp_transport_with_http_info(body, clusterExtId, async_req=True)
        >>> result = thread.get()

        :param list[clustermgmt.v4.config.SnmpTransport] body: SNMP transports to add (required)
        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.AddSnmpTransportsTaskApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'clusterExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_snmp_transport" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_snmp_transport`")  # noqa: E501
        # verify the required parameter 'clusterExtId' is set
        if ('clusterExtId' not in params or
                params['clusterExtId'] is None):
            raise ValueError("Missing the required parameter `clusterExtId` when calling `add_snmp_transport`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'clusterExtId' in params:
            path_params['clusterExtId'] = params['clusterExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a2/config/clusters/{clusterExtId}/snmp/$actions/add-transports', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.AddSnmpTransportsTaskApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_snmp_trap(self, body, clusterExtId, **kwargs):  # noqa: E501
        """Add SNMP trap
        Add SNMP trap

        >>> response = api.add_snmp_trap(body, clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_snmp_trap(body, clusterExtId, async_req=True)
        >>> result = thread.get()

        :param clustermgmt.v4.config.SnmpTrap body: SNMP trap to add (required)
        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.AddSnmpTrapTaskApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_snmp_trap_with_http_info(body, clusterExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.add_snmp_trap_with_http_info(body, clusterExtId, **kwargs)  # noqa: E501
            return data

    def add_snmp_trap_with_http_info(self, body, clusterExtId, **kwargs):  # noqa: E501
        """Add SNMP trap
        Add SNMP trap

        >>> response = api.add_snmp_trap(body, clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_snmp_trap_with_http_info(body, clusterExtId, async_req=True)
        >>> result = thread.get()

        :param clustermgmt.v4.config.SnmpTrap body: SNMP trap to add (required)
        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.AddSnmpTrapTaskApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'clusterExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_snmp_trap" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_snmp_trap`")  # noqa: E501
        # verify the required parameter 'clusterExtId' is set
        if ('clusterExtId' not in params or
                params['clusterExtId'] is None):
            raise ValueError("Missing the required parameter `clusterExtId` when calling `add_snmp_trap`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'clusterExtId' in params:
            path_params['clusterExtId'] = params['clusterExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a2/config/clusters/{clusterExtId}/snmp/traps', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.AddSnmpTrapTaskApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_snmp_user(self, body, clusterExtId, **kwargs):  # noqa: E501
        """Add SNMP user
        Add SNMP user

        >>> response = api.add_snmp_user(body, clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_snmp_user(body, clusterExtId, async_req=True)
        >>> result = thread.get()

        :param clustermgmt.v4.config.SnmpUser body: SNMP user to add (required)
        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.AddSnmpUserTaskApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_snmp_user_with_http_info(body, clusterExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.add_snmp_user_with_http_info(body, clusterExtId, **kwargs)  # noqa: E501
            return data

    def add_snmp_user_with_http_info(self, body, clusterExtId, **kwargs):  # noqa: E501
        """Add SNMP user
        Add SNMP user

        >>> response = api.add_snmp_user(body, clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_snmp_user_with_http_info(body, clusterExtId, async_req=True)
        >>> result = thread.get()

        :param clustermgmt.v4.config.SnmpUser body: SNMP user to add (required)
        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.AddSnmpUserTaskApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'clusterExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_snmp_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_snmp_user`")  # noqa: E501
        # verify the required parameter 'clusterExtId' is set
        if ('clusterExtId' not in params or
                params['clusterExtId'] is None):
            raise ValueError("Missing the required parameter `clusterExtId` when calling `add_snmp_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'clusterExtId' in params:
            path_params['clusterExtId'] = params['clusterExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a2/config/clusters/{clusterExtId}/snmp/users', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.AddSnmpUserTaskApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_rsyslog_server(self, clusterExtId, rsyslogServerExtId, **kwargs):  # noqa: E501
        """Delete RSYSLOG Server
        Delete RSYSLOG Server

        >>> response = api.delete_rsyslog_server(clusterExtId, rsyslogServerExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_rsyslog_server(clusterExtId, rsyslogServerExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param str rsyslogServerExtId: RSYSLOG server UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.DeleteRsyslogServerTaskApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_rsyslog_server_with_http_info(clusterExtId, rsyslogServerExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_rsyslog_server_with_http_info(clusterExtId, rsyslogServerExtId, **kwargs)  # noqa: E501
            return data

    def delete_rsyslog_server_with_http_info(self, clusterExtId, rsyslogServerExtId, **kwargs):  # noqa: E501
        """Delete RSYSLOG Server
        Delete RSYSLOG Server

        >>> response = api.delete_rsyslog_server(clusterExtId, rsyslogServerExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_rsyslog_server_with_http_info(clusterExtId, rsyslogServerExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param str rsyslogServerExtId: RSYSLOG server UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.DeleteRsyslogServerTaskApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['clusterExtId', 'rsyslogServerExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_rsyslog_server" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'clusterExtId' is set
        if ('clusterExtId' not in params or
                params['clusterExtId'] is None):
            raise ValueError("Missing the required parameter `clusterExtId` when calling `delete_rsyslog_server`")  # noqa: E501
        # verify the required parameter 'rsyslogServerExtId' is set
        if ('rsyslogServerExtId' not in params or
                params['rsyslogServerExtId'] is None):
            raise ValueError("Missing the required parameter `rsyslogServerExtId` when calling `delete_rsyslog_server`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'clusterExtId' in params:
            path_params['clusterExtId'] = params['clusterExtId']  # noqa: E501
        if 'rsyslogServerExtId' in params:
            path_params['rsyslogServerExtId'] = params['rsyslogServerExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a2/config/clusters/{clusterExtId}/rsyslog-servers/{rsyslogServerExtId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.DeleteRsyslogServerTaskApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_snmp_trap(self, clusterExtId, trapExtId, **kwargs):  # noqa: E501
        """Delete SNMP trap
        Delete SNMP trap

        >>> response = api.delete_snmp_trap(clusterExtId, trapExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_snmp_trap(clusterExtId, trapExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param str trapExtId: SNMP trap UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.DeleteSnmpTrapTaskApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_snmp_trap_with_http_info(clusterExtId, trapExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_snmp_trap_with_http_info(clusterExtId, trapExtId, **kwargs)  # noqa: E501
            return data

    def delete_snmp_trap_with_http_info(self, clusterExtId, trapExtId, **kwargs):  # noqa: E501
        """Delete SNMP trap
        Delete SNMP trap

        >>> response = api.delete_snmp_trap(clusterExtId, trapExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_snmp_trap_with_http_info(clusterExtId, trapExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param str trapExtId: SNMP trap UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.DeleteSnmpTrapTaskApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['clusterExtId', 'trapExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_snmp_trap" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'clusterExtId' is set
        if ('clusterExtId' not in params or
                params['clusterExtId'] is None):
            raise ValueError("Missing the required parameter `clusterExtId` when calling `delete_snmp_trap`")  # noqa: E501
        # verify the required parameter 'trapExtId' is set
        if ('trapExtId' not in params or
                params['trapExtId'] is None):
            raise ValueError("Missing the required parameter `trapExtId` when calling `delete_snmp_trap`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'clusterExtId' in params:
            path_params['clusterExtId'] = params['clusterExtId']  # noqa: E501
        if 'trapExtId' in params:
            path_params['trapExtId'] = params['trapExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a2/config/clusters/{clusterExtId}/snmp/traps/{trapExtId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.DeleteSnmpTrapTaskApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_snmp_user(self, clusterExtId, userExtId, **kwargs):  # noqa: E501
        """Delete SNMP user
        Delete SNMP user

        >>> response = api.delete_snmp_user(clusterExtId, userExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_snmp_user(clusterExtId, userExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param str userExtId: SNMP user UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.DeleteSnmpUserTaskApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_snmp_user_with_http_info(clusterExtId, userExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_snmp_user_with_http_info(clusterExtId, userExtId, **kwargs)  # noqa: E501
            return data

    def delete_snmp_user_with_http_info(self, clusterExtId, userExtId, **kwargs):  # noqa: E501
        """Delete SNMP user
        Delete SNMP user

        >>> response = api.delete_snmp_user(clusterExtId, userExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_snmp_user_with_http_info(clusterExtId, userExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param str userExtId: SNMP user UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.DeleteSnmpUserTaskApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['clusterExtId', 'userExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_snmp_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'clusterExtId' is set
        if ('clusterExtId' not in params or
                params['clusterExtId'] is None):
            raise ValueError("Missing the required parameter `clusterExtId` when calling `delete_snmp_user`")  # noqa: E501
        # verify the required parameter 'userExtId' is set
        if ('userExtId' not in params or
                params['userExtId'] is None):
            raise ValueError("Missing the required parameter `userExtId` when calling `delete_snmp_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'clusterExtId' in params:
            path_params['clusterExtId'] = params['clusterExtId']  # noqa: E501
        if 'userExtId' in params:
            path_params['userExtId'] = params['userExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a2/config/clusters/{clusterExtId}/snmp/users/{userExtId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.DeleteSnmpUserTaskApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def discover_unconfigured_nodes(self, body, clusterExtId, **kwargs):  # noqa: E501
        """Discover unconfigured nodes
        Get the unconfigured node details such as node UUID, node position, node IP, foundation version and more.

        >>> response = api.discover_unconfigured_nodes(body, clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.discover_unconfigured_nodes(body, clusterExtId, async_req=True)
        >>> result = thread.get()

        :param clustermgmt.v4.config.NodeDiscoveryParams body: Discover unconfigured node details (required)
        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.DiscoverNodeTaskApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.discover_unconfigured_nodes_with_http_info(body, clusterExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.discover_unconfigured_nodes_with_http_info(body, clusterExtId, **kwargs)  # noqa: E501
            return data

    def discover_unconfigured_nodes_with_http_info(self, body, clusterExtId, **kwargs):  # noqa: E501
        """Discover unconfigured nodes
        Get the unconfigured node details such as node UUID, node position, node IP, foundation version and more.

        >>> response = api.discover_unconfigured_nodes(body, clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.discover_unconfigured_nodes_with_http_info(body, clusterExtId, async_req=True)
        >>> result = thread.get()

        :param clustermgmt.v4.config.NodeDiscoveryParams body: Discover unconfigured node details (required)
        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.DiscoverNodeTaskApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'clusterExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method discover_unconfigured_nodes" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `discover_unconfigured_nodes`")  # noqa: E501
        # verify the required parameter 'clusterExtId' is set
        if ('clusterExtId' not in params or
                params['clusterExtId'] is None):
            raise ValueError("Missing the required parameter `clusterExtId` when calling `discover_unconfigured_nodes`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'clusterExtId' in params:
            path_params['clusterExtId'] = params['clusterExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a2/config/clusters/{clusterExtId}/$actions/discover-unconfigured-nodes', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.DiscoverNodeTaskApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_host_gpus(self, **kwargs):  # noqa: E501
        """Get all host GPUs
        Get all host GPUs

        >>> response = api.get_all_host_gpus((optional) _page, (optional) _limit, (optional) _filter, (optional) _orderby)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_host_gpus(async_req=True)
        >>> result = thread.get()

        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource. Any number out of this range will lead to no results being returned.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will lead to a validation error. If the limit is not provided a default value of 50 records will be returned in the result set.

        :param str _filter: A URL query parameter that allows clients to filter a collection of resources. The expression specified with $filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the $filter must conform to the OData V4.01 URL conventions.
        The filter can be applied on the following fields:
        
        - cluster/uuid
        - numberOfVgpusAllocated
        
        :param str _orderby: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified the resources will be sorted in ascending order by default. For example, 'orderby=templateName desc' would get all templates sorted by templateName in desc order.
        The orderby can be applied to the following fields:
        
        - numberOfVgpusAllocated
        
        :param bool async_req:
        :return: clustermgmt.v4.config.GetAllHostGpusResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_host_gpus_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_host_gpus_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_host_gpus_with_http_info(self, **kwargs):  # noqa: E501
        """Get all host GPUs
        Get all host GPUs

        >>> response = api.get_all_host_gpus((optional) _page, (optional) _limit, (optional) _filter, (optional) _orderby)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_host_gpus_with_http_info(async_req=True)
        >>> result = thread.get()

        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource. Any number out of this range will lead to no results being returned.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will lead to a validation error. If the limit is not provided a default value of 50 records will be returned in the result set.

        :param str _filter: A URL query parameter that allows clients to filter a collection of resources. The expression specified with $filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the $filter must conform to the OData V4.01 URL conventions.
        The filter can be applied on the following fields:
        
        - cluster/uuid
        - numberOfVgpusAllocated
        
        :param str _orderby: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified the resources will be sorted in ascending order by default. For example, 'orderby=templateName desc' would get all templates sorted by templateName in desc order.
        The orderby can be applied to the following fields:
        
        - numberOfVgpusAllocated
        
        :param bool async_req:
        :return: clustermgmt.v4.config.GetAllHostGpusResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['_page', '_limit', '_filter', '_orderby']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_host_gpus" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if '_page' in params:
            query_params.append(('$page', params['_page']))  # noqa: E501
        if '_limit' in params:
            query_params.append(('$limit', params['_limit']))  # noqa: E501
        if '_filter' in params:
            query_params.append(('$filter', params['_filter']))  # noqa: E501
        if '_orderby' in params:
            query_params.append(('$orderby', params['_orderby']))  # noqa: E501

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a2/config/host-gpus', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.GetAllHostGpusResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_hosts(self, **kwargs):  # noqa: E501
        """Get all host entities
        Get all host entities

        >>> response = api.get_all_hosts((optional) _page, (optional) _limit, (optional) _filter, (optional) _orderby)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_hosts(async_req=True)
        >>> result = thread.get()

        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource. Any number out of this range will lead to no results being returned.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will lead to a validation error. If the limit is not provided a default value of 50 records will be returned in the result set.

        :param str _filter: A URL query parameter that allows clients to filter a collection of resources. The expression specified with $filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the $filter must conform to the OData V4.01 URL conventions.
        The filter can be applied on the following fields:
        
        - bootTimeUsecs
        - cluster/uuid
        - cpuCapacityHz
        - cpuFrequencyHz
        - cpuModel
        - defaultVhdContainerId
        - defaultVhdContainerUuid
        - defaultVhdLocation
        - defaultVmContainerId
        - defaultVmContainerUuid
        - defaultVmLocation
        - gpuDriverVersion
        - hostName
        - memorySizeBytes
        - numberOfCpuCores
        - numberOfCpuSockets
        - numberOfCpuThreads
        
        :param str _orderby: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified the resources will be sorted in ascending order by default. For example, 'orderby=templateName desc' would get all templates sorted by templateName in desc order.
        The orderby can be applied to the following fields:
        
        - hostName
        
        :param bool async_req:
        :return: clustermgmt.v4.config.GetAllHostsResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_hosts_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_hosts_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_hosts_with_http_info(self, **kwargs):  # noqa: E501
        """Get all host entities
        Get all host entities

        >>> response = api.get_all_hosts((optional) _page, (optional) _limit, (optional) _filter, (optional) _orderby)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_hosts_with_http_info(async_req=True)
        >>> result = thread.get()

        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource. Any number out of this range will lead to no results being returned.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will lead to a validation error. If the limit is not provided a default value of 50 records will be returned in the result set.

        :param str _filter: A URL query parameter that allows clients to filter a collection of resources. The expression specified with $filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the $filter must conform to the OData V4.01 URL conventions.
        The filter can be applied on the following fields:
        
        - bootTimeUsecs
        - cluster/uuid
        - cpuCapacityHz
        - cpuFrequencyHz
        - cpuModel
        - defaultVhdContainerId
        - defaultVhdContainerUuid
        - defaultVhdLocation
        - defaultVmContainerId
        - defaultVmContainerUuid
        - defaultVmLocation
        - gpuDriverVersion
        - hostName
        - memorySizeBytes
        - numberOfCpuCores
        - numberOfCpuSockets
        - numberOfCpuThreads
        
        :param str _orderby: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified the resources will be sorted in ascending order by default. For example, 'orderby=templateName desc' would get all templates sorted by templateName in desc order.
        The orderby can be applied to the following fields:
        
        - hostName
        
        :param bool async_req:
        :return: clustermgmt.v4.config.GetAllHostsResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['_page', '_limit', '_filter', '_orderby']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_hosts" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if '_page' in params:
            query_params.append(('$page', params['_page']))  # noqa: E501
        if '_limit' in params:
            query_params.append(('$limit', params['_limit']))  # noqa: E501
        if '_filter' in params:
            query_params.append(('$filter', params['_filter']))  # noqa: E501
        if '_orderby' in params:
            query_params.append(('$orderby', params['_orderby']))  # noqa: E501

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a2/config/hosts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.GetAllHostsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cluster(self, clusterExtId, **kwargs):  # noqa: E501
        """Get cluster entity
        Get cluster entity

        >>> response = api.get_cluster(clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_cluster(clusterExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.GetClusterResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_cluster_with_http_info(clusterExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_cluster_with_http_info(clusterExtId, **kwargs)  # noqa: E501
            return data

    def get_cluster_with_http_info(self, clusterExtId, **kwargs):  # noqa: E501
        """Get cluster entity
        Get cluster entity

        >>> response = api.get_cluster(clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_cluster_with_http_info(clusterExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.GetClusterResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['clusterExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cluster" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'clusterExtId' is set
        if ('clusterExtId' not in params or
                params['clusterExtId'] is None):
            raise ValueError("Missing the required parameter `clusterExtId` when calling `get_cluster`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'clusterExtId' in params:
            path_params['clusterExtId'] = params['clusterExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a2/config/clusters/{clusterExtId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.GetClusterResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_clusters(self, **kwargs):  # noqa: E501
        """Get cluster entities
        Get cluster entities

        >>> response = api.get_clusters((optional) _page, (optional) _limit, (optional) _filter, (optional) _orderby)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_clusters(async_req=True)
        >>> result = thread.get()

        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource. Any number out of this range will lead to no results being returned.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will lead to a validation error. If the limit is not provided a default value of 50 records will be returned in the result set.

        :param str _filter: A URL query parameter that allows clients to filter a collection of resources. The expression specified with $filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the $filter must conform to the OData V4.01 URL conventions.
        The filter can be applied on the following fields:
        
        - extId
        - name
        
        :param str _orderby: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified the resources will be sorted in ascending order by default. For example, 'orderby=templateName desc' would get all templates sorted by templateName in desc order.
        The orderby can be applied to the following fields:
        
        - name
        
        :param bool async_req:
        :return: clustermgmt.v4.config.GetClustersResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_clusters_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_clusters_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_clusters_with_http_info(self, **kwargs):  # noqa: E501
        """Get cluster entities
        Get cluster entities

        >>> response = api.get_clusters((optional) _page, (optional) _limit, (optional) _filter, (optional) _orderby)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_clusters_with_http_info(async_req=True)
        >>> result = thread.get()

        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource. Any number out of this range will lead to no results being returned.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will lead to a validation error. If the limit is not provided a default value of 50 records will be returned in the result set.

        :param str _filter: A URL query parameter that allows clients to filter a collection of resources. The expression specified with $filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the $filter must conform to the OData V4.01 URL conventions.
        The filter can be applied on the following fields:
        
        - extId
        - name
        
        :param str _orderby: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified the resources will be sorted in ascending order by default. For example, 'orderby=templateName desc' would get all templates sorted by templateName in desc order.
        The orderby can be applied to the following fields:
        
        - name
        
        :param bool async_req:
        :return: clustermgmt.v4.config.GetClustersResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['_page', '_limit', '_filter', '_orderby']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_clusters" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if '_page' in params:
            query_params.append(('$page', params['_page']))  # noqa: E501
        if '_limit' in params:
            query_params.append(('$limit', params['_limit']))  # noqa: E501
        if '_filter' in params:
            query_params.append(('$filter', params['_filter']))  # noqa: E501
        if '_orderby' in params:
            query_params.append(('$orderby', params['_orderby']))  # noqa: E501

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a2/config/clusters', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.GetClustersResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_domain_fault_tolerance_status(self, clusterExtId, **kwargs):  # noqa: E501
        """Get domain fault tolerance status
        Get domain fault tolerance status

        >>> response = api.get_domain_fault_tolerance_status(clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_domain_fault_tolerance_status(clusterExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.GetDomainFaultToleranceResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_domain_fault_tolerance_status_with_http_info(clusterExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_domain_fault_tolerance_status_with_http_info(clusterExtId, **kwargs)  # noqa: E501
            return data

    def get_domain_fault_tolerance_status_with_http_info(self, clusterExtId, **kwargs):  # noqa: E501
        """Get domain fault tolerance status
        Get domain fault tolerance status

        >>> response = api.get_domain_fault_tolerance_status(clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_domain_fault_tolerance_status_with_http_info(clusterExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.GetDomainFaultToleranceResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['clusterExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_domain_fault_tolerance_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'clusterExtId' is set
        if ('clusterExtId' not in params or
                params['clusterExtId'] is None):
            raise ValueError("Missing the required parameter `clusterExtId` when calling `get_domain_fault_tolerance_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'clusterExtId' in params:
            path_params['clusterExtId'] = params['clusterExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a2/config/clusters/{clusterExtId}/domain-fault-tolerance-status', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.GetDomainFaultToleranceResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_gpu_profiles(self, clusterExtId, **kwargs):  # noqa: E501
        """Get GPU profiles
        Get GPU profiles

        >>> response = api.get_gpu_profiles(clusterExtId, (optional) _page, (optional) _limit)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_gpu_profiles(clusterExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource. Any number out of this range will lead to no results being returned.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will lead to a validation error. If the limit is not provided a default value of 50 records will be returned in the result set.

        :param bool async_req:
        :return: clustermgmt.v4.config.GetGpuProfilesResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_gpu_profiles_with_http_info(clusterExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_gpu_profiles_with_http_info(clusterExtId, **kwargs)  # noqa: E501
            return data

    def get_gpu_profiles_with_http_info(self, clusterExtId, **kwargs):  # noqa: E501
        """Get GPU profiles
        Get GPU profiles

        >>> response = api.get_gpu_profiles(clusterExtId, (optional) _page, (optional) _limit)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_gpu_profiles_with_http_info(clusterExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource. Any number out of this range will lead to no results being returned.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will lead to a validation error. If the limit is not provided a default value of 50 records will be returned in the result set.

        :param bool async_req:
        :return: clustermgmt.v4.config.GetGpuProfilesResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['clusterExtId', '_page', '_limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_gpu_profiles" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'clusterExtId' is set
        if ('clusterExtId' not in params or
                params['clusterExtId'] is None):
            raise ValueError("Missing the required parameter `clusterExtId` when calling `get_gpu_profiles`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'clusterExtId' in params:
            path_params['clusterExtId'] = params['clusterExtId']  # noqa: E501

        query_params = []
        if '_page' in params:
            query_params.append(('$page', params['_page']))  # noqa: E501
        if '_limit' in params:
            query_params.append(('$limit', params['_limit']))  # noqa: E501

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a2/config/clusters/{clusterExtId}/gpu-profiles', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.GetGpuProfilesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_host(self, clusterExtId, hostExtId, **kwargs):  # noqa: E501
        """Get host entity
        Get host entity

        >>> response = api.get_host(clusterExtId, hostExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_host(clusterExtId, hostExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param str hostExtId: Host UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.GetHostResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_host_with_http_info(clusterExtId, hostExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_host_with_http_info(clusterExtId, hostExtId, **kwargs)  # noqa: E501
            return data

    def get_host_with_http_info(self, clusterExtId, hostExtId, **kwargs):  # noqa: E501
        """Get host entity
        Get host entity

        >>> response = api.get_host(clusterExtId, hostExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_host_with_http_info(clusterExtId, hostExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param str hostExtId: Host UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.GetHostResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['clusterExtId', 'hostExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_host" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'clusterExtId' is set
        if ('clusterExtId' not in params or
                params['clusterExtId'] is None):
            raise ValueError("Missing the required parameter `clusterExtId` when calling `get_host`")  # noqa: E501
        # verify the required parameter 'hostExtId' is set
        if ('hostExtId' not in params or
                params['hostExtId'] is None):
            raise ValueError("Missing the required parameter `hostExtId` when calling `get_host`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'clusterExtId' in params:
            path_params['clusterExtId'] = params['clusterExtId']  # noqa: E501
        if 'hostExtId' in params:
            path_params['hostExtId'] = params['hostExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a2/config/clusters/{clusterExtId}/hosts/{hostExtId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.GetHostResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_host_gpu(self, clusterExtId, hostExtId, hostGpuExtId, **kwargs):  # noqa: E501
        """Get host GPU
        Get host GPU

        >>> response = api.get_host_gpu(clusterExtId, hostExtId, hostGpuExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_host_gpu(clusterExtId, hostExtId, hostGpuExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param str hostExtId: Host UUID (required)
        :param str hostGpuExtId: Host GPU UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.GetHostGpuResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_host_gpu_with_http_info(clusterExtId, hostExtId, hostGpuExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_host_gpu_with_http_info(clusterExtId, hostExtId, hostGpuExtId, **kwargs)  # noqa: E501
            return data

    def get_host_gpu_with_http_info(self, clusterExtId, hostExtId, hostGpuExtId, **kwargs):  # noqa: E501
        """Get host GPU
        Get host GPU

        >>> response = api.get_host_gpu(clusterExtId, hostExtId, hostGpuExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_host_gpu_with_http_info(clusterExtId, hostExtId, hostGpuExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param str hostExtId: Host UUID (required)
        :param str hostGpuExtId: Host GPU UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.GetHostGpuResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['clusterExtId', 'hostExtId', 'hostGpuExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_host_gpu" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'clusterExtId' is set
        if ('clusterExtId' not in params or
                params['clusterExtId'] is None):
            raise ValueError("Missing the required parameter `clusterExtId` when calling `get_host_gpu`")  # noqa: E501
        # verify the required parameter 'hostExtId' is set
        if ('hostExtId' not in params or
                params['hostExtId'] is None):
            raise ValueError("Missing the required parameter `hostExtId` when calling `get_host_gpu`")  # noqa: E501
        # verify the required parameter 'hostGpuExtId' is set
        if ('hostGpuExtId' not in params or
                params['hostGpuExtId'] is None):
            raise ValueError("Missing the required parameter `hostGpuExtId` when calling `get_host_gpu`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'clusterExtId' in params:
            path_params['clusterExtId'] = params['clusterExtId']  # noqa: E501
        if 'hostExtId' in params:
            path_params['hostExtId'] = params['hostExtId']  # noqa: E501
        if 'hostGpuExtId' in params:
            path_params['hostGpuExtId'] = params['hostGpuExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a2/config/clusters/{clusterExtId}/hosts/{hostExtId}/host-gpus/{hostGpuExtId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.GetHostGpuResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_host_gpus(self, clusterExtId, hostExtId, **kwargs):  # noqa: E501
        """Get host GPUs on a particular host
        Get host GPUs on a particular host

        >>> response = api.get_host_gpus(clusterExtId, hostExtId, (optional) _page, (optional) _limit, (optional) _filter, (optional) _orderby)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_host_gpus(clusterExtId, hostExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param str hostExtId: Host UUID (required)
        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource. Any number out of this range will lead to no results being returned.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will lead to a validation error. If the limit is not provided a default value of 50 records will be returned in the result set.

        :param str _filter: A URL query parameter that allows clients to filter a collection of resources. The expression specified with $filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the $filter must conform to the OData V4.01 URL conventions.
        The filter can be applied on the following fields:
        
        - cluster/uuid
        - numberOfVgpusAllocated
        
        :param str _orderby: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified the resources will be sorted in ascending order by default. For example, 'orderby=templateName desc' would get all templates sorted by templateName in desc order.
        The orderby can be applied to the following fields:
        
        - numberOfVgpusAllocated
        
        :param bool async_req:
        :return: clustermgmt.v4.config.GetHostGpusResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_host_gpus_with_http_info(clusterExtId, hostExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_host_gpus_with_http_info(clusterExtId, hostExtId, **kwargs)  # noqa: E501
            return data

    def get_host_gpus_with_http_info(self, clusterExtId, hostExtId, **kwargs):  # noqa: E501
        """Get host GPUs on a particular host
        Get host GPUs on a particular host

        >>> response = api.get_host_gpus(clusterExtId, hostExtId, (optional) _page, (optional) _limit, (optional) _filter, (optional) _orderby)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_host_gpus_with_http_info(clusterExtId, hostExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param str hostExtId: Host UUID (required)
        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource. Any number out of this range will lead to no results being returned.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will lead to a validation error. If the limit is not provided a default value of 50 records will be returned in the result set.

        :param str _filter: A URL query parameter that allows clients to filter a collection of resources. The expression specified with $filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the $filter must conform to the OData V4.01 URL conventions.
        The filter can be applied on the following fields:
        
        - cluster/uuid
        - numberOfVgpusAllocated
        
        :param str _orderby: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified the resources will be sorted in ascending order by default. For example, 'orderby=templateName desc' would get all templates sorted by templateName in desc order.
        The orderby can be applied to the following fields:
        
        - numberOfVgpusAllocated
        
        :param bool async_req:
        :return: clustermgmt.v4.config.GetHostGpusResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['clusterExtId', 'hostExtId', '_page', '_limit', '_filter', '_orderby']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_host_gpus" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'clusterExtId' is set
        if ('clusterExtId' not in params or
                params['clusterExtId'] is None):
            raise ValueError("Missing the required parameter `clusterExtId` when calling `get_host_gpus`")  # noqa: E501
        # verify the required parameter 'hostExtId' is set
        if ('hostExtId' not in params or
                params['hostExtId'] is None):
            raise ValueError("Missing the required parameter `hostExtId` when calling `get_host_gpus`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'clusterExtId' in params:
            path_params['clusterExtId'] = params['clusterExtId']  # noqa: E501
        if 'hostExtId' in params:
            path_params['hostExtId'] = params['hostExtId']  # noqa: E501

        query_params = []
        if '_page' in params:
            query_params.append(('$page', params['_page']))  # noqa: E501
        if '_limit' in params:
            query_params.append(('$limit', params['_limit']))  # noqa: E501
        if '_filter' in params:
            query_params.append(('$filter', params['_filter']))  # noqa: E501
        if '_orderby' in params:
            query_params.append(('$orderby', params['_orderby']))  # noqa: E501

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a2/config/clusters/{clusterExtId}/hosts/{hostExtId}/host-gpus', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.GetHostGpusResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_host_gpus_of_cluster(self, clusterExtId, **kwargs):  # noqa: E501
        """Get all host GPUs of a cluster
        Get all host GPUs of a cluster

        >>> response = api.get_host_gpus_of_cluster(clusterExtId, (optional) _page, (optional) _limit, (optional) _filter, (optional) _orderby)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_host_gpus_of_cluster(clusterExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource. Any number out of this range will lead to no results being returned.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will lead to a validation error. If the limit is not provided a default value of 50 records will be returned in the result set.

        :param str _filter: A URL query parameter that allows clients to filter a collection of resources. The expression specified with $filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the $filter must conform to the OData V4.01 URL conventions.
        The filter can be applied on the following fields:
        
        - cluster/uuid
        - numberOfVgpusAllocated
        
        :param str _orderby: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified the resources will be sorted in ascending order by default. For example, 'orderby=templateName desc' would get all templates sorted by templateName in desc order.
        The orderby can be applied to the following fields:
        
        - numberOfVgpusAllocated
        
        :param bool async_req:
        :return: clustermgmt.v4.config.GetClusterHostGpusResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_host_gpus_of_cluster_with_http_info(clusterExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_host_gpus_of_cluster_with_http_info(clusterExtId, **kwargs)  # noqa: E501
            return data

    def get_host_gpus_of_cluster_with_http_info(self, clusterExtId, **kwargs):  # noqa: E501
        """Get all host GPUs of a cluster
        Get all host GPUs of a cluster

        >>> response = api.get_host_gpus_of_cluster(clusterExtId, (optional) _page, (optional) _limit, (optional) _filter, (optional) _orderby)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_host_gpus_of_cluster_with_http_info(clusterExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource. Any number out of this range will lead to no results being returned.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will lead to a validation error. If the limit is not provided a default value of 50 records will be returned in the result set.

        :param str _filter: A URL query parameter that allows clients to filter a collection of resources. The expression specified with $filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the $filter must conform to the OData V4.01 URL conventions.
        The filter can be applied on the following fields:
        
        - cluster/uuid
        - numberOfVgpusAllocated
        
        :param str _orderby: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified the resources will be sorted in ascending order by default. For example, 'orderby=templateName desc' would get all templates sorted by templateName in desc order.
        The orderby can be applied to the following fields:
        
        - numberOfVgpusAllocated
        
        :param bool async_req:
        :return: clustermgmt.v4.config.GetClusterHostGpusResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['clusterExtId', '_page', '_limit', '_filter', '_orderby']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_host_gpus_of_cluster" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'clusterExtId' is set
        if ('clusterExtId' not in params or
                params['clusterExtId'] is None):
            raise ValueError("Missing the required parameter `clusterExtId` when calling `get_host_gpus_of_cluster`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'clusterExtId' in params:
            path_params['clusterExtId'] = params['clusterExtId']  # noqa: E501

        query_params = []
        if '_page' in params:
            query_params.append(('$page', params['_page']))  # noqa: E501
        if '_limit' in params:
            query_params.append(('$limit', params['_limit']))  # noqa: E501
        if '_filter' in params:
            query_params.append(('$filter', params['_filter']))  # noqa: E501
        if '_orderby' in params:
            query_params.append(('$orderby', params['_orderby']))  # noqa: E501

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a2/config/clusters/{clusterExtId}/host-gpus', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.GetClusterHostGpusResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_hosts(self, clusterExtId, **kwargs):  # noqa: E501
        """Get host entities of a cluster
        Get host entities of a cluster

        >>> response = api.get_hosts(clusterExtId, (optional) _page, (optional) _limit, (optional) _filter, (optional) _orderby)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_hosts(clusterExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource. Any number out of this range will lead to no results being returned.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will lead to a validation error. If the limit is not provided a default value of 50 records will be returned in the result set.

        :param str _filter: A URL query parameter that allows clients to filter a collection of resources. The expression specified with $filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the $filter must conform to the OData V4.01 URL conventions.
        The filter can be applied on the following fields:
        
        - bootTimeUsecs
        - cluster/uuid
        - cpuCapacityHz
        - cpuFrequencyHz
        - cpuModel
        - defaultVhdContainerId
        - defaultVhdContainerUuid
        - defaultVhdLocation
        - defaultVmContainerId
        - defaultVmContainerUuid
        - defaultVmLocation
        - gpuDriverVersion
        - hostName
        - memorySizeBytes
        - numberOfCpuCores
        - numberOfCpuSockets
        - numberOfCpuThreads
        
        :param str _orderby: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified the resources will be sorted in ascending order by default. For example, 'orderby=templateName desc' would get all templates sorted by templateName in desc order.
        The orderby can be applied to the following fields:
        
        - hostName
        
        :param bool async_req:
        :return: clustermgmt.v4.config.GetHostsResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_hosts_with_http_info(clusterExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_hosts_with_http_info(clusterExtId, **kwargs)  # noqa: E501
            return data

    def get_hosts_with_http_info(self, clusterExtId, **kwargs):  # noqa: E501
        """Get host entities of a cluster
        Get host entities of a cluster

        >>> response = api.get_hosts(clusterExtId, (optional) _page, (optional) _limit, (optional) _filter, (optional) _orderby)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_hosts_with_http_info(clusterExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource. Any number out of this range will lead to no results being returned.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will lead to a validation error. If the limit is not provided a default value of 50 records will be returned in the result set.

        :param str _filter: A URL query parameter that allows clients to filter a collection of resources. The expression specified with $filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the $filter must conform to the OData V4.01 URL conventions.
        The filter can be applied on the following fields:
        
        - bootTimeUsecs
        - cluster/uuid
        - cpuCapacityHz
        - cpuFrequencyHz
        - cpuModel
        - defaultVhdContainerId
        - defaultVhdContainerUuid
        - defaultVhdLocation
        - defaultVmContainerId
        - defaultVmContainerUuid
        - defaultVmLocation
        - gpuDriverVersion
        - hostName
        - memorySizeBytes
        - numberOfCpuCores
        - numberOfCpuSockets
        - numberOfCpuThreads
        
        :param str _orderby: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified the resources will be sorted in ascending order by default. For example, 'orderby=templateName desc' would get all templates sorted by templateName in desc order.
        The orderby can be applied to the following fields:
        
        - hostName
        
        :param bool async_req:
        :return: clustermgmt.v4.config.GetHostsResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['clusterExtId', '_page', '_limit', '_filter', '_orderby']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_hosts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'clusterExtId' is set
        if ('clusterExtId' not in params or
                params['clusterExtId'] is None):
            raise ValueError("Missing the required parameter `clusterExtId` when calling `get_hosts`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'clusterExtId' in params:
            path_params['clusterExtId'] = params['clusterExtId']  # noqa: E501

        query_params = []
        if '_page' in params:
            query_params.append(('$page', params['_page']))  # noqa: E501
        if '_limit' in params:
            query_params.append(('$limit', params['_limit']))  # noqa: E501
        if '_filter' in params:
            query_params.append(('$filter', params['_filter']))  # noqa: E501
        if '_orderby' in params:
            query_params.append(('$orderby', params['_orderby']))  # noqa: E501

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a2/config/clusters/{clusterExtId}/hosts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.GetHostsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_rackable_unit(self, clusterExtId, rackableUnitExtId, **kwargs):  # noqa: E501
        """Get rackable unit entity
        Get rackable unit entity

        >>> response = api.get_rackable_unit(clusterExtId, rackableUnitExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_rackable_unit(clusterExtId, rackableUnitExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param str rackableUnitExtId: Rackable unit UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.GetRackableUnitResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_rackable_unit_with_http_info(clusterExtId, rackableUnitExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_rackable_unit_with_http_info(clusterExtId, rackableUnitExtId, **kwargs)  # noqa: E501
            return data

    def get_rackable_unit_with_http_info(self, clusterExtId, rackableUnitExtId, **kwargs):  # noqa: E501
        """Get rackable unit entity
        Get rackable unit entity

        >>> response = api.get_rackable_unit(clusterExtId, rackableUnitExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_rackable_unit_with_http_info(clusterExtId, rackableUnitExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param str rackableUnitExtId: Rackable unit UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.GetRackableUnitResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['clusterExtId', 'rackableUnitExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_rackable_unit" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'clusterExtId' is set
        if ('clusterExtId' not in params or
                params['clusterExtId'] is None):
            raise ValueError("Missing the required parameter `clusterExtId` when calling `get_rackable_unit`")  # noqa: E501
        # verify the required parameter 'rackableUnitExtId' is set
        if ('rackableUnitExtId' not in params or
                params['rackableUnitExtId'] is None):
            raise ValueError("Missing the required parameter `rackableUnitExtId` when calling `get_rackable_unit`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'clusterExtId' in params:
            path_params['clusterExtId'] = params['clusterExtId']  # noqa: E501
        if 'rackableUnitExtId' in params:
            path_params['rackableUnitExtId'] = params['rackableUnitExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a2/config/clusters/{clusterExtId}/rackable-units/{rackableUnitExtId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.GetRackableUnitResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_rackable_units(self, clusterExtId, **kwargs):  # noqa: E501
        """Get rackable unit entities of a cluster
        Get rackable unit entities of a cluster

        >>> response = api.get_rackable_units(clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_rackable_units(clusterExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.GetRackableUnitsResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_rackable_units_with_http_info(clusterExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_rackable_units_with_http_info(clusterExtId, **kwargs)  # noqa: E501
            return data

    def get_rackable_units_with_http_info(self, clusterExtId, **kwargs):  # noqa: E501
        """Get rackable unit entities of a cluster
        Get rackable unit entities of a cluster

        >>> response = api.get_rackable_units(clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_rackable_units_with_http_info(clusterExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.GetRackableUnitsResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['clusterExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_rackable_units" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'clusterExtId' is set
        if ('clusterExtId' not in params or
                params['clusterExtId'] is None):
            raise ValueError("Missing the required parameter `clusterExtId` when calling `get_rackable_units`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'clusterExtId' in params:
            path_params['clusterExtId'] = params['clusterExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a2/config/clusters/{clusterExtId}/rackable-units', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.GetRackableUnitsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_rsyslog_server(self, clusterExtId, rsyslogServerExtId, **kwargs):  # noqa: E501
        """Get RSYSLOG server configuration
        Get RSYSLOG server configuration

        >>> response = api.get_rsyslog_server(clusterExtId, rsyslogServerExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_rsyslog_server(clusterExtId, rsyslogServerExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param str rsyslogServerExtId: RSYSLOG server UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.GetRsyslogServerResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_rsyslog_server_with_http_info(clusterExtId, rsyslogServerExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_rsyslog_server_with_http_info(clusterExtId, rsyslogServerExtId, **kwargs)  # noqa: E501
            return data

    def get_rsyslog_server_with_http_info(self, clusterExtId, rsyslogServerExtId, **kwargs):  # noqa: E501
        """Get RSYSLOG server configuration
        Get RSYSLOG server configuration

        >>> response = api.get_rsyslog_server(clusterExtId, rsyslogServerExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_rsyslog_server_with_http_info(clusterExtId, rsyslogServerExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param str rsyslogServerExtId: RSYSLOG server UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.GetRsyslogServerResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['clusterExtId', 'rsyslogServerExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_rsyslog_server" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'clusterExtId' is set
        if ('clusterExtId' not in params or
                params['clusterExtId'] is None):
            raise ValueError("Missing the required parameter `clusterExtId` when calling `get_rsyslog_server`")  # noqa: E501
        # verify the required parameter 'rsyslogServerExtId' is set
        if ('rsyslogServerExtId' not in params or
                params['rsyslogServerExtId'] is None):
            raise ValueError("Missing the required parameter `rsyslogServerExtId` when calling `get_rsyslog_server`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'clusterExtId' in params:
            path_params['clusterExtId'] = params['clusterExtId']  # noqa: E501
        if 'rsyslogServerExtId' in params:
            path_params['rsyslogServerExtId'] = params['rsyslogServerExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a2/config/clusters/{clusterExtId}/rsyslog-servers/{rsyslogServerExtId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.GetRsyslogServerResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_rsyslog_servers(self, clusterExtId, **kwargs):  # noqa: E501
        """Get RSYSLOG servers configuration details
        Get RSYSLOG servers configuration details

        >>> response = api.get_rsyslog_servers(clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_rsyslog_servers(clusterExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.GetRsyslogServersResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_rsyslog_servers_with_http_info(clusterExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_rsyslog_servers_with_http_info(clusterExtId, **kwargs)  # noqa: E501
            return data

    def get_rsyslog_servers_with_http_info(self, clusterExtId, **kwargs):  # noqa: E501
        """Get RSYSLOG servers configuration details
        Get RSYSLOG servers configuration details

        >>> response = api.get_rsyslog_servers(clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_rsyslog_servers_with_http_info(clusterExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.GetRsyslogServersResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['clusterExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_rsyslog_servers" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'clusterExtId' is set
        if ('clusterExtId' not in params or
                params['clusterExtId'] is None):
            raise ValueError("Missing the required parameter `clusterExtId` when calling `get_rsyslog_servers`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'clusterExtId' in params:
            path_params['clusterExtId'] = params['clusterExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a2/config/clusters/{clusterExtId}/rsyslog-servers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.GetRsyslogServersResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_snmp(self, clusterExtId, **kwargs):  # noqa: E501
        """Get SNMP information
        Get SNMP information

        >>> response = api.get_snmp(clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_snmp(clusterExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.GetSnmpResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_snmp_with_http_info(clusterExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_snmp_with_http_info(clusterExtId, **kwargs)  # noqa: E501
            return data

    def get_snmp_with_http_info(self, clusterExtId, **kwargs):  # noqa: E501
        """Get SNMP information
        Get SNMP information

        >>> response = api.get_snmp(clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_snmp_with_http_info(clusterExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.GetSnmpResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['clusterExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_snmp" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'clusterExtId' is set
        if ('clusterExtId' not in params or
                params['clusterExtId'] is None):
            raise ValueError("Missing the required parameter `clusterExtId` when calling `get_snmp`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'clusterExtId' in params:
            path_params['clusterExtId'] = params['clusterExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a2/config/clusters/{clusterExtId}/snmp', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.GetSnmpResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_snmp_trap(self, clusterExtId, trapExtId, **kwargs):  # noqa: E501
        """Get SNMP trap configuration
        Get SNMP trap configuration

        >>> response = api.get_snmp_trap(clusterExtId, trapExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_snmp_trap(clusterExtId, trapExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param str trapExtId: SNMP trap UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.GetSnmpTrapResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_snmp_trap_with_http_info(clusterExtId, trapExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_snmp_trap_with_http_info(clusterExtId, trapExtId, **kwargs)  # noqa: E501
            return data

    def get_snmp_trap_with_http_info(self, clusterExtId, trapExtId, **kwargs):  # noqa: E501
        """Get SNMP trap configuration
        Get SNMP trap configuration

        >>> response = api.get_snmp_trap(clusterExtId, trapExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_snmp_trap_with_http_info(clusterExtId, trapExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param str trapExtId: SNMP trap UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.GetSnmpTrapResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['clusterExtId', 'trapExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_snmp_trap" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'clusterExtId' is set
        if ('clusterExtId' not in params or
                params['clusterExtId'] is None):
            raise ValueError("Missing the required parameter `clusterExtId` when calling `get_snmp_trap`")  # noqa: E501
        # verify the required parameter 'trapExtId' is set
        if ('trapExtId' not in params or
                params['trapExtId'] is None):
            raise ValueError("Missing the required parameter `trapExtId` when calling `get_snmp_trap`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'clusterExtId' in params:
            path_params['clusterExtId'] = params['clusterExtId']  # noqa: E501
        if 'trapExtId' in params:
            path_params['trapExtId'] = params['trapExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a2/config/clusters/{clusterExtId}/snmp/traps/{trapExtId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.GetSnmpTrapResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_snmp_user(self, clusterExtId, userExtId, **kwargs):  # noqa: E501
        """Get SNMP user configuration
        Get SNMP user configuration

        >>> response = api.get_snmp_user(clusterExtId, userExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_snmp_user(clusterExtId, userExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param str userExtId: SNMP user UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.GetSnmpUserResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_snmp_user_with_http_info(clusterExtId, userExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_snmp_user_with_http_info(clusterExtId, userExtId, **kwargs)  # noqa: E501
            return data

    def get_snmp_user_with_http_info(self, clusterExtId, userExtId, **kwargs):  # noqa: E501
        """Get SNMP user configuration
        Get SNMP user configuration

        >>> response = api.get_snmp_user(clusterExtId, userExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_snmp_user_with_http_info(clusterExtId, userExtId, async_req=True)
        >>> result = thread.get()

        :param str clusterExtId: Cluster UUID (required)
        :param str userExtId: SNMP user UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.GetSnmpUserResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['clusterExtId', 'userExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_snmp_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'clusterExtId' is set
        if ('clusterExtId' not in params or
                params['clusterExtId'] is None):
            raise ValueError("Missing the required parameter `clusterExtId` when calling `get_snmp_user`")  # noqa: E501
        # verify the required parameter 'userExtId' is set
        if ('userExtId' not in params or
                params['userExtId'] is None):
            raise ValueError("Missing the required parameter `userExtId` when calling `get_snmp_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'clusterExtId' in params:
            path_params['clusterExtId'] = params['clusterExtId']  # noqa: E501
        if 'userExtId' in params:
            path_params['userExtId'] = params['userExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a2/config/clusters/{clusterExtId}/snmp/users/{userExtId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.GetSnmpUserResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def is_bundle_compatible(self, body, clusterExtId, **kwargs):  # noqa: E501
        """Get hypervisor bundle compatibility information
        Provides details on whether hypervisor bundle is compatible or not

        >>> response = api.is_bundle_compatible(body, clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.is_bundle_compatible(body, clusterExtId, async_req=True)
        >>> result = thread.get()

        :param clustermgmt.v4.config.BundleParam body: ISO attributes to validate compatibility (required)
        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.IsBundleCompatibleTaskResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.is_bundle_compatible_with_http_info(body, clusterExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.is_bundle_compatible_with_http_info(body, clusterExtId, **kwargs)  # noqa: E501
            return data

    def is_bundle_compatible_with_http_info(self, body, clusterExtId, **kwargs):  # noqa: E501
        """Get hypervisor bundle compatibility information
        Provides details on whether hypervisor bundle is compatible or not

        >>> response = api.is_bundle_compatible(body, clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.is_bundle_compatible_with_http_info(body, clusterExtId, async_req=True)
        >>> result = thread.get()

        :param clustermgmt.v4.config.BundleParam body: ISO attributes to validate compatibility (required)
        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.IsBundleCompatibleTaskResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'clusterExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method is_bundle_compatible" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `is_bundle_compatible`")  # noqa: E501
        # verify the required parameter 'clusterExtId' is set
        if ('clusterExtId' not in params or
                params['clusterExtId'] is None):
            raise ValueError("Missing the required parameter `clusterExtId` when calling `is_bundle_compatible`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'clusterExtId' in params:
            path_params['clusterExtId'] = params['clusterExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a2/config/clusters/{clusterExtId}/$actions/validate-bundle', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.IsBundleCompatibleTaskResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def is_hypervisor_upload_required(self, body, clusterExtId, **kwargs):  # noqa: E501
        """Get hypervisor ISO upload information
        Provides information on whether hypervisor ISO upload is required or not

        >>> response = api.is_hypervisor_upload_required(body, clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.is_hypervisor_upload_required(body, clusterExtId, async_req=True)
        >>> result = thread.get()

        :param clustermgmt.v4.config.HypervisorUploadParam body: Parameters to get information on whether hypervisor ISO upload is required or not (required)
        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.HypervisorUplpadRequiredTaskResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.is_hypervisor_upload_required_with_http_info(body, clusterExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.is_hypervisor_upload_required_with_http_info(body, clusterExtId, **kwargs)  # noqa: E501
            return data

    def is_hypervisor_upload_required_with_http_info(self, body, clusterExtId, **kwargs):  # noqa: E501
        """Get hypervisor ISO upload information
        Provides information on whether hypervisor ISO upload is required or not

        >>> response = api.is_hypervisor_upload_required(body, clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.is_hypervisor_upload_required_with_http_info(body, clusterExtId, async_req=True)
        >>> result = thread.get()

        :param clustermgmt.v4.config.HypervisorUploadParam body: Parameters to get information on whether hypervisor ISO upload is required or not (required)
        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.HypervisorUplpadRequiredTaskResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'clusterExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method is_hypervisor_upload_required" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `is_hypervisor_upload_required`")  # noqa: E501
        # verify the required parameter 'clusterExtId' is set
        if ('clusterExtId' not in params or
                params['clusterExtId'] is None):
            raise ValueError("Missing the required parameter `clusterExtId` when calling `is_hypervisor_upload_required`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'clusterExtId' in params:
            path_params['clusterExtId'] = params['clusterExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a2/config/clusters/{clusterExtId}/$actions/check-hypervisor-requirements', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.HypervisorUplpadRequiredTaskResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def nodes_networking_details(self, body, clusterExtId, **kwargs):  # noqa: E501
        """Get network information of unconfigured nodes
        Get a dictionary of cluster networks and available uplinks on the given nodes

        >>> response = api.nodes_networking_details(body, clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nodes_networking_details(body, clusterExtId, async_req=True)
        >>> result = thread.get()

        :param clustermgmt.v4.config.NodeDetails body: Node specific details required to fetch node networking information (required)
        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.GetNodeNetworkingTaskApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.nodes_networking_details_with_http_info(body, clusterExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.nodes_networking_details_with_http_info(body, clusterExtId, **kwargs)  # noqa: E501
            return data

    def nodes_networking_details_with_http_info(self, body, clusterExtId, **kwargs):  # noqa: E501
        """Get network information of unconfigured nodes
        Get a dictionary of cluster networks and available uplinks on the given nodes

        >>> response = api.nodes_networking_details(body, clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.nodes_networking_details_with_http_info(body, clusterExtId, async_req=True)
        >>> result = thread.get()

        :param clustermgmt.v4.config.NodeDetails body: Node specific details required to fetch node networking information (required)
        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.GetNodeNetworkingTaskApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'clusterExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method nodes_networking_details" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `nodes_networking_details`")  # noqa: E501
        # verify the required parameter 'clusterExtId' is set
        if ('clusterExtId' not in params or
                params['clusterExtId'] is None):
            raise ValueError("Missing the required parameter `clusterExtId` when calling `nodes_networking_details`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'clusterExtId' in params:
            path_params['clusterExtId'] = params['clusterExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a2/config/clusters/{clusterExtId}/$actions/fetch-node-networking-details', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.GetNodeNetworkingTaskApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_node(self, body, clusterExtId, **kwargs):  # noqa: E501
        """Removes nodes from cluster
        Removes nodes from cluster

        >>> response = api.remove_node(body, clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_node(body, clusterExtId, async_req=True)
        >>> result = thread.get()

        :param clustermgmt.v4.config.NodeRemovalParams body: Parameters to remove nodes from cluster (required)
        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.RemoveNodeTaskResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_node_with_http_info(body, clusterExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_node_with_http_info(body, clusterExtId, **kwargs)  # noqa: E501
            return data

    def remove_node_with_http_info(self, body, clusterExtId, **kwargs):  # noqa: E501
        """Removes nodes from cluster
        Removes nodes from cluster

        >>> response = api.remove_node(body, clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_node_with_http_info(body, clusterExtId, async_req=True)
        >>> result = thread.get()

        :param clustermgmt.v4.config.NodeRemovalParams body: Parameters to remove nodes from cluster (required)
        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.RemoveNodeTaskResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'clusterExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_node" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_node`")  # noqa: E501
        # verify the required parameter 'clusterExtId' is set
        if ('clusterExtId' not in params or
                params['clusterExtId'] is None):
            raise ValueError("Missing the required parameter `clusterExtId` when calling `remove_node`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'clusterExtId' in params:
            path_params['clusterExtId'] = params['clusterExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a2/config/clusters/{clusterExtId}/$actions/remove-node', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.RemoveNodeTaskResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_snmp_transport(self, body, clusterExtId, **kwargs):  # noqa: E501
        """Remove SNMP transports
        Remove SNMP transports

        >>> response = api.remove_snmp_transport(body, clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_snmp_transport(body, clusterExtId, async_req=True)
        >>> result = thread.get()

        :param list[clustermgmt.v4.config.SnmpTransport] body: SNMP transports to remove (required)
        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.RemoveSnmpTransportsTaskApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_snmp_transport_with_http_info(body, clusterExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_snmp_transport_with_http_info(body, clusterExtId, **kwargs)  # noqa: E501
            return data

    def remove_snmp_transport_with_http_info(self, body, clusterExtId, **kwargs):  # noqa: E501
        """Remove SNMP transports
        Remove SNMP transports

        >>> response = api.remove_snmp_transport(body, clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_snmp_transport_with_http_info(body, clusterExtId, async_req=True)
        >>> result = thread.get()

        :param list[clustermgmt.v4.config.SnmpTransport] body: SNMP transports to remove (required)
        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.RemoveSnmpTransportsTaskApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'clusterExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_snmp_transport" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_snmp_transport`")  # noqa: E501
        # verify the required parameter 'clusterExtId' is set
        if ('clusterExtId' not in params or
                params['clusterExtId'] is None):
            raise ValueError("Missing the required parameter `clusterExtId` when calling `remove_snmp_transport`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'clusterExtId' in params:
            path_params['clusterExtId'] = params['clusterExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a2/config/clusters/{clusterExtId}/snmp/$actions/remove-transports', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.RemoveSnmpTransportsTaskApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def rename_host(self, body, clusterExtId, hostExtId, **kwargs):  # noqa: E501
        """Rename AHV host in a cluster.
        Rename AHV host in a cluster. Requests are processed in parallel and if multiple rename requests are submitted they can be executed in random order.

        >>> response = api.rename_host(body, clusterExtId, hostExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.rename_host(body, clusterExtId, hostExtId, async_req=True)
        >>> result = thread.get()

        :param clustermgmt.v4.config.HostNameParam body: Host rename parameters (required)
        :param str clusterExtId: Cluster UUID (required)
        :param str hostExtId: Host UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.HostRenameResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.rename_host_with_http_info(body, clusterExtId, hostExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.rename_host_with_http_info(body, clusterExtId, hostExtId, **kwargs)  # noqa: E501
            return data

    def rename_host_with_http_info(self, body, clusterExtId, hostExtId, **kwargs):  # noqa: E501
        """Rename AHV host in a cluster.
        Rename AHV host in a cluster. Requests are processed in parallel and if multiple rename requests are submitted they can be executed in random order.

        >>> response = api.rename_host(body, clusterExtId, hostExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.rename_host_with_http_info(body, clusterExtId, hostExtId, async_req=True)
        >>> result = thread.get()

        :param clustermgmt.v4.config.HostNameParam body: Host rename parameters (required)
        :param str clusterExtId: Cluster UUID (required)
        :param str hostExtId: Host UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.HostRenameResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'clusterExtId', 'hostExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method rename_host" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `rename_host`")  # noqa: E501
        # verify the required parameter 'clusterExtId' is set
        if ('clusterExtId' not in params or
                params['clusterExtId'] is None):
            raise ValueError("Missing the required parameter `clusterExtId` when calling `rename_host`")  # noqa: E501
        # verify the required parameter 'hostExtId' is set
        if ('hostExtId' not in params or
                params['hostExtId'] is None):
            raise ValueError("Missing the required parameter `hostExtId` when calling `rename_host`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'clusterExtId' in params:
            path_params['clusterExtId'] = params['clusterExtId']  # noqa: E501
        if 'hostExtId' in params:
            path_params['hostExtId'] = params['hostExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a2/config/clusters/{clusterExtId}/hosts/{hostExtId}/$actions/rename-host', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.HostRenameResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_task(self, body, taskExtId, **kwargs):  # noqa: E501
        """Get task response based on the type of request
        Get task response based on the type of request

        >>> response = api.search_task(body, taskExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.search_task(body, taskExtId, async_req=True)
        >>> result = thread.get()

        :param clustermgmt.v4.config.SearchParams body: Search parameters (required)
        :param str taskExtId: The external identifier of the task. (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.GetSearchResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_task_with_http_info(body, taskExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.search_task_with_http_info(body, taskExtId, **kwargs)  # noqa: E501
            return data

    def search_task_with_http_info(self, body, taskExtId, **kwargs):  # noqa: E501
        """Get task response based on the type of request
        Get task response based on the type of request

        >>> response = api.search_task(body, taskExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.search_task_with_http_info(body, taskExtId, async_req=True)
        >>> result = thread.get()

        :param clustermgmt.v4.config.SearchParams body: Search parameters (required)
        :param str taskExtId: The external identifier of the task. (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.GetSearchResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'taskExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_task" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `search_task`")  # noqa: E501
        # verify the required parameter 'taskExtId' is set
        if ('taskExtId' not in params or
                params['taskExtId'] is None):
            raise ValueError("Missing the required parameter `taskExtId` when calling `search_task`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'taskExtId' in params:
            path_params['taskExtId'] = params['taskExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a2/config/tasks/{taskExtId}/$actions/fetch-task-response', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.GetSearchResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_cluster(self, body, clusterExtId, **kwargs):  # noqa: E501
        """Update cluster
        Update cluster

        >>> response = api.update_cluster(body, clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_cluster(body, clusterExtId, async_req=True)
        >>> result = thread.get()

        :param clustermgmt.v4.config.ClusterEntity body: Cluster resource to update (required)
        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.UpdateClusterTaskApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_cluster_with_http_info(body, clusterExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.update_cluster_with_http_info(body, clusterExtId, **kwargs)  # noqa: E501
            return data

    def update_cluster_with_http_info(self, body, clusterExtId, **kwargs):  # noqa: E501
        """Update cluster
        Update cluster

        >>> response = api.update_cluster(body, clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_cluster_with_http_info(body, clusterExtId, async_req=True)
        >>> result = thread.get()

        :param clustermgmt.v4.config.ClusterEntity body: Cluster resource to update (required)
        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.UpdateClusterTaskApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'clusterExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_cluster" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_cluster`")  # noqa: E501
        # verify the required parameter 'clusterExtId' is set
        if ('clusterExtId' not in params or
                params['clusterExtId'] is None):
            raise ValueError("Missing the required parameter `clusterExtId` when calling `update_cluster`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'clusterExtId' in params:
            path_params['clusterExtId'] = params['clusterExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a2/config/clusters/{clusterExtId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.UpdateClusterTaskApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_rsyslog_server(self, body, clusterExtId, rsyslogServerExtId, **kwargs):  # noqa: E501
        """Update RSYSLOG server configuration
        Update RSYSLOG server configuration

        >>> response = api.update_rsyslog_server(body, clusterExtId, rsyslogServerExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_rsyslog_server(body, clusterExtId, rsyslogServerExtId, async_req=True)
        >>> result = thread.get()

        :param clustermgmt.v4.config.RsyslogServer body: RSYSLOG server to update (required)
        :param str clusterExtId: Cluster UUID (required)
        :param str rsyslogServerExtId: RSYSLOG server UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.UpdateRsyslogServerTaskApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_rsyslog_server_with_http_info(body, clusterExtId, rsyslogServerExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.update_rsyslog_server_with_http_info(body, clusterExtId, rsyslogServerExtId, **kwargs)  # noqa: E501
            return data

    def update_rsyslog_server_with_http_info(self, body, clusterExtId, rsyslogServerExtId, **kwargs):  # noqa: E501
        """Update RSYSLOG server configuration
        Update RSYSLOG server configuration

        >>> response = api.update_rsyslog_server(body, clusterExtId, rsyslogServerExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_rsyslog_server_with_http_info(body, clusterExtId, rsyslogServerExtId, async_req=True)
        >>> result = thread.get()

        :param clustermgmt.v4.config.RsyslogServer body: RSYSLOG server to update (required)
        :param str clusterExtId: Cluster UUID (required)
        :param str rsyslogServerExtId: RSYSLOG server UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.UpdateRsyslogServerTaskApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'clusterExtId', 'rsyslogServerExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_rsyslog_server" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_rsyslog_server`")  # noqa: E501
        # verify the required parameter 'clusterExtId' is set
        if ('clusterExtId' not in params or
                params['clusterExtId'] is None):
            raise ValueError("Missing the required parameter `clusterExtId` when calling `update_rsyslog_server`")  # noqa: E501
        # verify the required parameter 'rsyslogServerExtId' is set
        if ('rsyslogServerExtId' not in params or
                params['rsyslogServerExtId'] is None):
            raise ValueError("Missing the required parameter `rsyslogServerExtId` when calling `update_rsyslog_server`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'clusterExtId' in params:
            path_params['clusterExtId'] = params['clusterExtId']  # noqa: E501
        if 'rsyslogServerExtId' in params:
            path_params['rsyslogServerExtId'] = params['rsyslogServerExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a2/config/clusters/{clusterExtId}/rsyslog-servers/{rsyslogServerExtId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.UpdateRsyslogServerTaskApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_snmp_status(self, body, clusterExtId, **kwargs):  # noqa: E501
        """Update SNMP status
        Update SNMP status

        >>> response = api.update_snmp_status(body, clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_snmp_status(body, clusterExtId, async_req=True)
        >>> result = thread.get()

        :param clustermgmt.v4.config.SnmpStatusParam body: SNMP status (required)
        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.UpdateSnmpStatusTaskApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_snmp_status_with_http_info(body, clusterExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.update_snmp_status_with_http_info(body, clusterExtId, **kwargs)  # noqa: E501
            return data

    def update_snmp_status_with_http_info(self, body, clusterExtId, **kwargs):  # noqa: E501
        """Update SNMP status
        Update SNMP status

        >>> response = api.update_snmp_status(body, clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_snmp_status_with_http_info(body, clusterExtId, async_req=True)
        >>> result = thread.get()

        :param clustermgmt.v4.config.SnmpStatusParam body: SNMP status (required)
        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.UpdateSnmpStatusTaskApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'clusterExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_snmp_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_snmp_status`")  # noqa: E501
        # verify the required parameter 'clusterExtId' is set
        if ('clusterExtId' not in params or
                params['clusterExtId'] is None):
            raise ValueError("Missing the required parameter `clusterExtId` when calling `update_snmp_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'clusterExtId' in params:
            path_params['clusterExtId'] = params['clusterExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a2/config/clusters/{clusterExtId}/snmp/$actions/update-status', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.UpdateSnmpStatusTaskApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_snmp_trap(self, body, clusterExtId, trapExtId, **kwargs):  # noqa: E501
        """Update SNMP trap
        Update SNMP trap

        >>> response = api.update_snmp_trap(body, clusterExtId, trapExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_snmp_trap(body, clusterExtId, trapExtId, async_req=True)
        >>> result = thread.get()

        :param clustermgmt.v4.config.SnmpTrap body: SNMP trap to update (required)
        :param str clusterExtId: Cluster UUID (required)
        :param str trapExtId: SNMP trap UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.UpdateSnmpTrapTaskApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_snmp_trap_with_http_info(body, clusterExtId, trapExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.update_snmp_trap_with_http_info(body, clusterExtId, trapExtId, **kwargs)  # noqa: E501
            return data

    def update_snmp_trap_with_http_info(self, body, clusterExtId, trapExtId, **kwargs):  # noqa: E501
        """Update SNMP trap
        Update SNMP trap

        >>> response = api.update_snmp_trap(body, clusterExtId, trapExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_snmp_trap_with_http_info(body, clusterExtId, trapExtId, async_req=True)
        >>> result = thread.get()

        :param clustermgmt.v4.config.SnmpTrap body: SNMP trap to update (required)
        :param str clusterExtId: Cluster UUID (required)
        :param str trapExtId: SNMP trap UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.UpdateSnmpTrapTaskApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'clusterExtId', 'trapExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_snmp_trap" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_snmp_trap`")  # noqa: E501
        # verify the required parameter 'clusterExtId' is set
        if ('clusterExtId' not in params or
                params['clusterExtId'] is None):
            raise ValueError("Missing the required parameter `clusterExtId` when calling `update_snmp_trap`")  # noqa: E501
        # verify the required parameter 'trapExtId' is set
        if ('trapExtId' not in params or
                params['trapExtId'] is None):
            raise ValueError("Missing the required parameter `trapExtId` when calling `update_snmp_trap`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'clusterExtId' in params:
            path_params['clusterExtId'] = params['clusterExtId']  # noqa: E501
        if 'trapExtId' in params:
            path_params['trapExtId'] = params['trapExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a2/config/clusters/{clusterExtId}/snmp/traps/{trapExtId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.UpdateSnmpTrapTaskApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_snmp_user(self, body, clusterExtId, userExtId, **kwargs):  # noqa: E501
        """Update SNMP user
        Update SNMP user

        >>> response = api.update_snmp_user(body, clusterExtId, userExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_snmp_user(body, clusterExtId, userExtId, async_req=True)
        >>> result = thread.get()

        :param clustermgmt.v4.config.SnmpUser body: SNMP user to update (required)
        :param str clusterExtId: Cluster UUID (required)
        :param str userExtId: SNMP user UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.UpdateSnmpUserTaskApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_snmp_user_with_http_info(body, clusterExtId, userExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.update_snmp_user_with_http_info(body, clusterExtId, userExtId, **kwargs)  # noqa: E501
            return data

    def update_snmp_user_with_http_info(self, body, clusterExtId, userExtId, **kwargs):  # noqa: E501
        """Update SNMP user
        Update SNMP user

        >>> response = api.update_snmp_user(body, clusterExtId, userExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_snmp_user_with_http_info(body, clusterExtId, userExtId, async_req=True)
        >>> result = thread.get()

        :param clustermgmt.v4.config.SnmpUser body: SNMP user to update (required)
        :param str clusterExtId: Cluster UUID (required)
        :param str userExtId: SNMP user UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.UpdateSnmpUserTaskApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'clusterExtId', 'userExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_snmp_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_snmp_user`")  # noqa: E501
        # verify the required parameter 'clusterExtId' is set
        if ('clusterExtId' not in params or
                params['clusterExtId'] is None):
            raise ValueError("Missing the required parameter `clusterExtId` when calling `update_snmp_user`")  # noqa: E501
        # verify the required parameter 'userExtId' is set
        if ('userExtId' not in params or
                params['userExtId'] is None):
            raise ValueError("Missing the required parameter `userExtId` when calling `update_snmp_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'clusterExtId' in params:
            path_params['clusterExtId'] = params['clusterExtId']  # noqa: E501
        if 'userExtId' in params:
            path_params['userExtId'] = params['userExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a2/config/clusters/{clusterExtId}/snmp/users/{userExtId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.UpdateSnmpUserTaskApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def validate_uplinks(self, body, clusterExtId, **kwargs):  # noqa: E501
        """Validates uplink information for the nodes
        Validates whether the uplink information for the given nodes can be used to add nodes to the cluster

        >>> response = api.validate_uplinks(body, clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.validate_uplinks(body, clusterExtId, async_req=True)
        >>> result = thread.get()

        :param list[clustermgmt.v4.config.UplinkNode] body: Parameters for validating uplinks (required)
        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.ValidateUplinksTaskApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.validate_uplinks_with_http_info(body, clusterExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.validate_uplinks_with_http_info(body, clusterExtId, **kwargs)  # noqa: E501
            return data

    def validate_uplinks_with_http_info(self, body, clusterExtId, **kwargs):  # noqa: E501
        """Validates uplink information for the nodes
        Validates whether the uplink information for the given nodes can be used to add nodes to the cluster

        >>> response = api.validate_uplinks(body, clusterExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.validate_uplinks_with_http_info(body, clusterExtId, async_req=True)
        >>> result = thread.get()

        :param list[clustermgmt.v4.config.UplinkNode] body: Parameters for validating uplinks (required)
        :param str clusterExtId: Cluster UUID (required)
        :param bool async_req:
        :return: clustermgmt.v4.config.ValidateUplinksTaskApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'clusterExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method validate_uplinks" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `validate_uplinks`")  # noqa: E501
        # verify the required parameter 'clusterExtId' is set
        if ('clusterExtId' not in params or
                params['clusterExtId'] is None):
            raise ValueError("Missing the required parameter `clusterExtId` when calling `validate_uplinks`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'clusterExtId' in params:
            path_params['clusterExtId'] = params['clusterExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/clustermgmt/v4.0.a2/config/clusters/{clusterExtId}/$actions/validate-uplinks', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='clustermgmt.v4.config.ValidateUplinksTaskApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
