# coding: utf-8


"""
IGNORE:
    Nutanix Clustermgmt Versioned APIs

    Manage Hosts, Clusters and other Infrastructure.  # noqa: E501

    OpenAPI spec version: 4.0.2-alpha-2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_clustermgmt_py_client.Ntnx.clustermgmt.v4.config.HypervisorType import HypervisorType  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class UploadInfoNodeItem(object):
    """UploadInfoNodeItem - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'hypervisor_upload_required': 'bool',
        'is_imaging_mandatory': 'bool',
        'node_uuid': 'str',
        'available_hypervisor_iso_error': 'str',
        'required_hypervisor_type': 'clustermgmt.v4.config.HypervisorType',
        'is_node_compatible': 'bool',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'hypervisor_upload_required': 'hypervisorUploadRequired',
        'is_imaging_mandatory': 'isImagingMandatory',
        'node_uuid': 'nodeUuid',
        'available_hypervisor_iso_error': 'availableHypervisorIsoError',
        'required_hypervisor_type': 'requiredHypervisorType',
        'is_node_compatible': 'isNodeCompatible',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, hypervisor_upload_required=None, is_imaging_mandatory=None, node_uuid=None, available_hypervisor_iso_error=None, required_hypervisor_type=None, is_node_compatible=None, *args, **kwargs):  # noqa: E501
        """UploadInfoNodeItem - a model defined in Swagger
            \nUpload information for a node
        """
        self.__hypervisor_upload_required = None
        self.__is_imaging_mandatory = None
        self.__node_uuid = None
        self.__available_hypervisor_iso_error = None
        self.__required_hypervisor_type = None
        self.__is_node_compatible = None
        self.discriminator = None
        if hypervisor_upload_required is not None:
            self.__hypervisor_upload_required = hypervisor_upload_required
        if is_imaging_mandatory is not None:
            self.__is_imaging_mandatory = is_imaging_mandatory
        if node_uuid is not None:
            self.__node_uuid = node_uuid
        if available_hypervisor_iso_error is not None:
            self.__available_hypervisor_iso_error = available_hypervisor_iso_error
        if required_hypervisor_type is not None:
            self.__required_hypervisor_type = required_hypervisor_type
        if is_node_compatible is not None:
            self.__is_node_compatible = is_node_compatible
        # populate hidden vars if not empty
        self._populate_hidden_vars(kwargs)

    def _initialize_object_type(self):
        return 'clustermgmt.v4.config.UploadInfoNodeItem'

    def _initialize_fq_object_type(self):
        return 'clustermgmt.v4.r0.a2.config.UploadInfoNodeItem'

    def _populate_hidden_vars(self, kwargs):
        if "_reserved" in kwargs and kwargs["_reserved"] is not None:
            self.__dollar_reserved = kwargs["_reserved"]
        elif "_reserved" in self.attribute_map and self.attribute_map["_reserved"] in kwargs and kwargs[self.attribute_map["_reserved"]] is not None:
            self.__dollar_reserved = kwargs[self.attribute_map["_reserved"]]
        else :
            self.__dollar_reserved = {"$fqObjectType": self._initialize_fq_object_type()}
        if "_unknown_fields" in kwargs and kwargs["_unknown_fields"] is not None:
            self.__dollar_unknown_fields = kwargs["_unknown_fields"]
        elif "_unknown_fields" in self.attribute_map and self.attribute_map["_unknown_fields"] in kwargs and kwargs[self.attribute_map["_unknown_fields"]] is not None:
            self.__dollar_unknown_fields = kwargs[self.attribute_map["_unknown_fields"]]
        else :
            self.__dollar_unknown_fields = {}
        if "_object_type" in kwargs and kwargs["_object_type"] is not None:
            self.__dollar_object_type = kwargs["_object_type"]
        elif "_object_type" in self.attribute_map and self.attribute_map["_object_type"] in kwargs and kwargs[self.attribute_map["_object_type"]] is not None:
            self.__dollar_object_type = kwargs[self.attribute_map["_object_type"]]
        else:
            self.__dollar_object_type = self._initialize_object_type()

    def get_object_type(self):
        return self.__dollar_object_type

    def get_reserved(self):
        return self.__dollar_reserved

    def get_unknown_fields(self):
        return self.__dollar_unknown_fields

    @property
    def hypervisor_upload_required(self):
        """`{ bool }`
            \nProvides information on whether hypervisor ISO upload is required or not
        """ # noqa: E501
        return self.__hypervisor_upload_required

    @hypervisor_upload_required.setter
    def hypervisor_upload_required(self, hypervisor_upload_required):

        self.__hypervisor_upload_required = hypervisor_upload_required

    @property
    def is_imaging_mandatory(self):
        """`{ bool }`
            \nIndicates if imaging is required or not
        """ # noqa: E501
        return self.__is_imaging_mandatory

    @is_imaging_mandatory.setter
    def is_imaging_mandatory(self, is_imaging_mandatory):

        self.__is_imaging_mandatory = is_imaging_mandatory

    @property
    def node_uuid(self):
        """`{ str }`
            \nUUID of a node
        """ # noqa: E501
        return self.__node_uuid

    @node_uuid.setter
    def node_uuid(self, node_uuid):
        if node_uuid is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', node_uuid):  # noqa: E501
            raise ValueError(r"Invalid value for `node_uuid`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__node_uuid = node_uuid

    @property
    def available_hypervisor_iso_error(self):
        """`{ str }`
            \nError message if any, for available hypervisor ISO
        """ # noqa: E501
        return self.__available_hypervisor_iso_error

    @available_hypervisor_iso_error.setter
    def available_hypervisor_iso_error(self, available_hypervisor_iso_error):

        self.__available_hypervisor_iso_error = available_hypervisor_iso_error

    @property
    def required_hypervisor_type(self):
        """`{ clustermgmt.v4.config.HypervisorType }`
            
        """ # noqa: E501
        return self.__required_hypervisor_type

    @required_hypervisor_type.setter
    def required_hypervisor_type(self, required_hypervisor_type):

        self.__required_hypervisor_type = required_hypervisor_type

    @property
    def is_node_compatible(self):
        """`{ bool }`
            \nIndicates if node is compatible or not
        """ # noqa: E501
        return self.__is_node_compatible

    @is_node_compatible.setter
    def is_node_compatible(self, is_node_compatible):

        self.__is_node_compatible = is_node_compatible

    @property
    def _reserved(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_reserved

    @property
    def _object_type(self):
        """`{ str }`
            
        """ # noqa: E501
        return self.__dollar_object_type

    @property
    def _unknown_fields(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_unknown_fields

    def _to_dict(self, sanitize):
        """
        Returns the model properties as a dict. Omits None properties based on the provided "sanitize" parameter.
        :param bool sanitize
        """

        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x._to_dict(sanitize) if hasattr(x, "_to_dict") else x,
                    value
                ))
            elif hasattr(value, "_to_dict"):
                result[attr] = value._to_dict(sanitize)
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1]._to_dict(sanitize))
                    if hasattr(item[1], "_to_dict") else item,
                    six.iteritems(value)
                ))
            else:
                if sanitize:
                    if value is not None:
                        result[attr] = value
                else:
                    result[attr] = value
        if issubclass(UploadInfoNodeItem, dict):
            for key, value in six.iteritems(self):
                result[key] = value

        return result

    def to_dict(self):
        """Returns the model properties as a dict"""
        return self._to_dict(False)

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self._to_dict(True))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UploadInfoNodeItem):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

