# coding: utf-8


"""
IGNORE:
    Nutanix Clustermgmt Versioned APIs

    Manage Hosts, Clusters and other Infrastructure.  # noqa: E501

    OpenAPI spec version: 4.0.2-alpha-2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_clustermgmt_py_client.Ntnx.clustermgmt.v4.config.HypervisorType import HypervisorType  # noqa: F401,E501
from ntnx_clustermgmt_py_client.Ntnx.clustermgmt.v4.config.UnconfiguredNodeAttributeMap import UnconfiguredNodeAttributeMap  # noqa: F401,E501
from ntnx_clustermgmt_py_client.Ntnx.common.v1.config.IPAddress import IPAddress  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class UnconfiguredNodeListItem(object):
    """UnconfiguredNodeListItem - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'foundation_version': 'str',
        'rackable_unit_serial': 'str',
        'node_uuid': 'str',
        'rackable_unit_max_nodes': 'int',
        'current_network_interface': 'str',
        'node_position': 'str',
        'cvm_ip': 'common.v1.config.IPAddress',
        'current_cvm_vlan_tag': 'str',
        'is_secure_booted': 'bool',
        'nos_version': 'str',
        'cpu_type': 'list[str]',
        'hypervisor_type': 'clustermgmt.v4.config.HypervisorType',
        'hypervisor_version': 'str',
        'interface_ipv6': 'str',
        'cluster_id': 'str',
        'attributes': 'clustermgmt.v4.config.UnconfiguredNodeAttributeMap',
        'rackable_unit_model': 'str',
        'arch': 'str',
        'hypervisor_ip': 'common.v1.config.IPAddress',
        'ipmi_ip': 'common.v1.config.IPAddress',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'foundation_version': 'foundationVersion',
        'rackable_unit_serial': 'rackableUnitSerial',
        'node_uuid': 'nodeUuid',
        'rackable_unit_max_nodes': 'rackableUnitMaxNodes',
        'current_network_interface': 'currentNetworkInterface',
        'node_position': 'nodePosition',
        'cvm_ip': 'cvmIp',
        'current_cvm_vlan_tag': 'currentCvmVlanTag',
        'is_secure_booted': 'isSecureBooted',
        'nos_version': 'nosVersion',
        'cpu_type': 'cpuType',
        'hypervisor_type': 'hypervisorType',
        'hypervisor_version': 'hypervisorVersion',
        'interface_ipv6': 'interfaceIpv6',
        'cluster_id': 'clusterId',
        'attributes': 'attributes',
        'rackable_unit_model': 'rackableUnitModel',
        'arch': 'arch',
        'hypervisor_ip': 'hypervisorIp',
        'ipmi_ip': 'ipmiIp',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, foundation_version=None, rackable_unit_serial=None, node_uuid=None, rackable_unit_max_nodes=None, current_network_interface=None, node_position=None, cvm_ip=None, current_cvm_vlan_tag=None, is_secure_booted=None, nos_version=None, cpu_type=None, hypervisor_type=None, hypervisor_version=None, interface_ipv6=None, cluster_id=None, attributes=None, rackable_unit_model=None, arch=None, hypervisor_ip=None, ipmi_ip=None, *args, **kwargs):  # noqa: E501
        """UnconfiguredNodeListItem - a model defined in Swagger
            \nUnconfigured node details
        """
        self.__foundation_version = None
        self.__rackable_unit_serial = None
        self.__node_uuid = None
        self.__rackable_unit_max_nodes = None
        self.__current_network_interface = None
        self.__node_position = None
        self.__cvm_ip = None
        self.__current_cvm_vlan_tag = None
        self.__is_secure_booted = None
        self.__nos_version = None
        self.__cpu_type = None
        self.__hypervisor_type = None
        self.__hypervisor_version = None
        self.__interface_ipv6 = None
        self.__cluster_id = None
        self.__attributes = None
        self.__rackable_unit_model = None
        self.__arch = None
        self.__hypervisor_ip = None
        self.__ipmi_ip = None
        self.discriminator = None
        if foundation_version is not None:
            self.__foundation_version = foundation_version
        if rackable_unit_serial is not None:
            self.__rackable_unit_serial = rackable_unit_serial
        if node_uuid is not None:
            self.__node_uuid = node_uuid
        if rackable_unit_max_nodes is not None:
            self.__rackable_unit_max_nodes = rackable_unit_max_nodes
        if current_network_interface is not None:
            self.__current_network_interface = current_network_interface
        if node_position is not None:
            self.__node_position = node_position
        if cvm_ip is not None:
            self.__cvm_ip = cvm_ip
        if current_cvm_vlan_tag is not None:
            self.__current_cvm_vlan_tag = current_cvm_vlan_tag
        if is_secure_booted is not None:
            self.__is_secure_booted = is_secure_booted
        if nos_version is not None:
            self.__nos_version = nos_version
        if cpu_type is not None:
            self.__cpu_type = cpu_type
        if hypervisor_type is not None:
            self.__hypervisor_type = hypervisor_type
        if hypervisor_version is not None:
            self.__hypervisor_version = hypervisor_version
        if interface_ipv6 is not None:
            self.__interface_ipv6 = interface_ipv6
        if cluster_id is not None:
            self.__cluster_id = cluster_id
        if attributes is not None:
            self.__attributes = attributes
        if rackable_unit_model is not None:
            self.__rackable_unit_model = rackable_unit_model
        if arch is not None:
            self.__arch = arch
        if hypervisor_ip is not None:
            self.__hypervisor_ip = hypervisor_ip
        if ipmi_ip is not None:
            self.__ipmi_ip = ipmi_ip
        # populate hidden vars if not empty
        self._populate_hidden_vars(kwargs)

    def _initialize_object_type(self):
        return 'clustermgmt.v4.config.UnconfiguredNodeListItem'

    def _initialize_fq_object_type(self):
        return 'clustermgmt.v4.r0.a2.config.UnconfiguredNodeListItem'

    def _populate_hidden_vars(self, kwargs):
        if "_reserved" in kwargs and kwargs["_reserved"] is not None:
            self.__dollar_reserved = kwargs["_reserved"]
        elif "_reserved" in self.attribute_map and self.attribute_map["_reserved"] in kwargs and kwargs[self.attribute_map["_reserved"]] is not None:
            self.__dollar_reserved = kwargs[self.attribute_map["_reserved"]]
        else :
            self.__dollar_reserved = {"$fqObjectType": self._initialize_fq_object_type()}
        if "_unknown_fields" in kwargs and kwargs["_unknown_fields"] is not None:
            self.__dollar_unknown_fields = kwargs["_unknown_fields"]
        elif "_unknown_fields" in self.attribute_map and self.attribute_map["_unknown_fields"] in kwargs and kwargs[self.attribute_map["_unknown_fields"]] is not None:
            self.__dollar_unknown_fields = kwargs[self.attribute_map["_unknown_fields"]]
        else :
            self.__dollar_unknown_fields = {}
        if "_object_type" in kwargs and kwargs["_object_type"] is not None:
            self.__dollar_object_type = kwargs["_object_type"]
        elif "_object_type" in self.attribute_map and self.attribute_map["_object_type"] in kwargs and kwargs[self.attribute_map["_object_type"]] is not None:
            self.__dollar_object_type = kwargs[self.attribute_map["_object_type"]]
        else:
            self.__dollar_object_type = self._initialize_object_type()

    def get_object_type(self):
        return self.__dollar_object_type

    def get_reserved(self):
        return self.__dollar_reserved

    def get_unknown_fields(self):
        return self.__dollar_unknown_fields

    @property
    def foundation_version(self):
        """`{ str }`
            \nFoundation version
        """ # noqa: E501
        return self.__foundation_version

    @foundation_version.setter
    def foundation_version(self, foundation_version):

        self.__foundation_version = foundation_version

    @property
    def rackable_unit_serial(self):
        """`{ str }`
            \nRackable unit serial name
        """ # noqa: E501
        return self.__rackable_unit_serial

    @rackable_unit_serial.setter
    def rackable_unit_serial(self, rackable_unit_serial):

        self.__rackable_unit_serial = rackable_unit_serial

    @property
    def node_uuid(self):
        """`{ str }`
            \nUUID of a node
        """ # noqa: E501
        return self.__node_uuid

    @node_uuid.setter
    def node_uuid(self, node_uuid):
        if node_uuid is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', node_uuid):  # noqa: E501
            raise ValueError(r"Invalid value for `node_uuid`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__node_uuid = node_uuid

    @property
    def rackable_unit_max_nodes(self):
        """`{ int }`
            \nMaximum number of nodes in rackable-unit
        """ # noqa: E501
        return self.__rackable_unit_max_nodes

    @rackable_unit_max_nodes.setter
    def rackable_unit_max_nodes(self, rackable_unit_max_nodes):

        self.__rackable_unit_max_nodes = rackable_unit_max_nodes

    @property
    def current_network_interface(self):
        """`{ str }`
            \nCurrent network interface of a node
        """ # noqa: E501
        return self.__current_network_interface

    @current_network_interface.setter
    def current_network_interface(self, current_network_interface):

        self.__current_network_interface = current_network_interface

    @property
    def node_position(self):
        """`{ str }`
            \nPosition of a node in a rackable unit
        """ # noqa: E501
        return self.__node_position

    @node_position.setter
    def node_position(self, node_position):

        self.__node_position = node_position

    @property
    def cvm_ip(self):
        """`{ common.v1.config.IPAddress }`
            
        """ # noqa: E501
        return self.__cvm_ip

    @cvm_ip.setter
    def cvm_ip(self, cvm_ip):

        self.__cvm_ip = cvm_ip

    @property
    def current_cvm_vlan_tag(self):
        """`{ str }`
            \nCurrent CVM VLAN tag
        """ # noqa: E501
        return self.__current_cvm_vlan_tag

    @current_cvm_vlan_tag.setter
    def current_cvm_vlan_tag(self, current_cvm_vlan_tag):

        self.__current_cvm_vlan_tag = current_cvm_vlan_tag

    @property
    def is_secure_booted(self):
        """`{ bool }`
            \nSecure boot status
        """ # noqa: E501
        return self.__is_secure_booted

    @is_secure_booted.setter
    def is_secure_booted(self, is_secure_booted):

        self.__is_secure_booted = is_secure_booted

    @property
    def nos_version(self):
        """`{ str }`
            \nNOS software version of a node
        """ # noqa: E501
        return self.__nos_version

    @nos_version.setter
    def nos_version(self, nos_version):

        self.__nos_version = nos_version

    @property
    def cpu_type(self):
        """`{ list[str] }`
            \nCPU type
        """ # noqa: E501
        return self.__cpu_type

    @cpu_type.setter
    def cpu_type(self, cpu_type):

        self.__cpu_type = cpu_type

    @property
    def hypervisor_type(self):
        """`{ clustermgmt.v4.config.HypervisorType }`
            
        """ # noqa: E501
        return self.__hypervisor_type

    @hypervisor_type.setter
    def hypervisor_type(self, hypervisor_type):

        self.__hypervisor_type = hypervisor_type

    @property
    def hypervisor_version(self):
        """`{ str }`
            \nHost version of the node
        """ # noqa: E501
        return self.__hypervisor_version

    @hypervisor_version.setter
    def hypervisor_version(self, hypervisor_version):

        self.__hypervisor_version = hypervisor_version

    @property
    def interface_ipv6(self):
        """`{ str }`
            \nInterface IPV6 address
        """ # noqa: E501
        return self.__interface_ipv6

    @interface_ipv6.setter
    def interface_ipv6(self, interface_ipv6):

        self.__interface_ipv6 = interface_ipv6

    @property
    def cluster_id(self):
        """`{ str }`
            \nCluster ID
        """ # noqa: E501
        return self.__cluster_id

    @cluster_id.setter
    def cluster_id(self, cluster_id):

        self.__cluster_id = cluster_id

    @property
    def attributes(self):
        """`{ clustermgmt.v4.config.UnconfiguredNodeAttributeMap }`
            
        """ # noqa: E501
        return self.__attributes

    @attributes.setter
    def attributes(self, attributes):

        self.__attributes = attributes

    @property
    def rackable_unit_model(self):
        """`{ str }`
            \nRackable unit model type
        """ # noqa: E501
        return self.__rackable_unit_model

    @rackable_unit_model.setter
    def rackable_unit_model(self, rackable_unit_model):

        self.__rackable_unit_model = rackable_unit_model

    @property
    def arch(self):
        """`{ str }`
            \nCluster arch
        """ # noqa: E501
        return self.__arch

    @arch.setter
    def arch(self, arch):

        self.__arch = arch

    @property
    def hypervisor_ip(self):
        """`{ common.v1.config.IPAddress }`
            
        """ # noqa: E501
        return self.__hypervisor_ip

    @hypervisor_ip.setter
    def hypervisor_ip(self, hypervisor_ip):

        self.__hypervisor_ip = hypervisor_ip

    @property
    def ipmi_ip(self):
        """`{ common.v1.config.IPAddress }`
            
        """ # noqa: E501
        return self.__ipmi_ip

    @ipmi_ip.setter
    def ipmi_ip(self, ipmi_ip):

        self.__ipmi_ip = ipmi_ip

    @property
    def _reserved(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_reserved

    @property
    def _object_type(self):
        """`{ str }`
            
        """ # noqa: E501
        return self.__dollar_object_type

    @property
    def _unknown_fields(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_unknown_fields

    def _to_dict(self, sanitize):
        """
        Returns the model properties as a dict. Omits None properties based on the provided "sanitize" parameter.
        :param bool sanitize
        """

        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x._to_dict(sanitize) if hasattr(x, "_to_dict") else x,
                    value
                ))
            elif hasattr(value, "_to_dict"):
                result[attr] = value._to_dict(sanitize)
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1]._to_dict(sanitize))
                    if hasattr(item[1], "_to_dict") else item,
                    six.iteritems(value)
                ))
            else:
                if sanitize:
                    if value is not None:
                        result[attr] = value
                else:
                    result[attr] = value
        if issubclass(UnconfiguredNodeListItem, dict):
            for key, value in six.iteritems(self):
                result[key] = value

        return result

    def to_dict(self):
        """Returns the model properties as a dict"""
        return self._to_dict(False)

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self._to_dict(True))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UnconfiguredNodeListItem):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

