# coding: utf-8


"""
IGNORE:
    Nutanix Clustermgmt Versioned APIs

    Manage Hosts, Clusters and other Infrastructure.  # noqa: E501

    OpenAPI spec version: 4.0.2-alpha-2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_clustermgmt_py_client.Ntnx.clustermgmt.v4.config.SnmpAuthType import SnmpAuthType  # noqa: F401,E501
from ntnx_clustermgmt_py_client.Ntnx.clustermgmt.v4.config.SnmpPrivType import SnmpPrivType  # noqa: F401,E501
from ntnx_clustermgmt_py_client.Ntnx.common.v1.response.ApiLink import ApiLink  # noqa: F401,E501
from ntnx_clustermgmt_py_client.Ntnx.common.v1.response.ExternalizableAbstractModel import ExternalizableAbstractModel  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class SnmpUser(ExternalizableAbstractModel):
    """SnmpUser - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'username': 'str',
        'auth_type': 'clustermgmt.v4.config.SnmpAuthType',
        'auth_key': 'str',
        'priv_type': 'clustermgmt.v4.config.SnmpPrivType',
        'priv_key': 'str',
        'ext_id': 'str',
        'links': 'list[common.v1.response.ApiLink]',
        'tenant_id': 'str',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'username': 'username',
        'auth_type': 'authType',
        'auth_key': 'authKey',
        'priv_type': 'privType',
        'priv_key': 'privKey',
        'ext_id': 'extId',
        'links': 'links',
        'tenant_id': 'tenantId',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, username=None, auth_type=None, auth_key=None, priv_type=None, priv_key=None, ext_id=None, links=None, tenant_id=None, *args, **kwargs):  # noqa: E501
        """SnmpUser - a model defined in Swagger
            \nSNMP user information
        """
        ExternalizableAbstractModel.__init__(self, ext_id, links, tenant_id, *args, **kwargs)
        self.__username = None
        self.__auth_type = None
        self.__auth_key = None
        self.__priv_type = None
        self.__priv_key = None
        self.discriminator = None
        self.__username = username
        self.__auth_type = auth_type
        self.__auth_key = auth_key
        if priv_type is not None:
            self.__priv_type = priv_type
        if priv_key is not None:
            self.__priv_key = priv_key

    def _initialize_object_type(self):
        return 'clustermgmt.v4.config.SnmpUser'

    def _initialize_fq_object_type(self):
        return 'clustermgmt.v4.r0.a2.config.SnmpUser'


    @property
    def username(self):
        """`{ str }`
            \nSNMP user name
        """ # noqa: E501
        return self.__username

    @username.setter
    def username(self, username):
        if username is None:
            raise ValueError("Invalid value for `username`, must not be `None`")  # noqa: E501

        self.__username = username

    @property
    def auth_type(self):
        """`{ clustermgmt.v4.config.SnmpAuthType }`
            
        """ # noqa: E501
        return self.__auth_type

    @auth_type.setter
    def auth_type(self, auth_type):
        if auth_type is None:
            raise ValueError("Invalid value for `auth_type`, must not be `None`")  # noqa: E501

        self.__auth_type = auth_type

    @property
    def auth_key(self):
        """`{ str }`
            \nSNMP user authentication key
        """ # noqa: E501
        return self.__auth_key

    @auth_key.setter
    def auth_key(self, auth_key):
        if auth_key is None:
            raise ValueError("Invalid value for `auth_key`, must not be `None`")  # noqa: E501
        if auth_key is not None and not re.search('^[^\']+$', auth_key):  # noqa: E501
            raise ValueError(r"Invalid value for `auth_key`, must be a follow pattern or equal to `/^[^']+$/`")  # noqa: E501

        self.__auth_key = auth_key

    @property
    def priv_type(self):
        """`{ clustermgmt.v4.config.SnmpPrivType }`
            
        """ # noqa: E501
        return self.__priv_type

    @priv_type.setter
    def priv_type(self, priv_type):

        self.__priv_type = priv_type

    @property
    def priv_key(self):
        """`{ str }`
            \nSNMP user encryption key
        """ # noqa: E501
        return self.__priv_key

    @priv_key.setter
    def priv_key(self, priv_key):
        if priv_key is not None and not re.search('^[^\']+$', priv_key):  # noqa: E501
            raise ValueError(r"Invalid value for `priv_key`, must be a follow pattern or equal to `/^[^']+$/`")  # noqa: E501

        self.__priv_key = priv_key

    def _to_dict(self, sanitize):
        """
        Returns the model properties as a dict. Omits None properties based on the provided "sanitize" parameter.
        :param bool sanitize
        """

        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x._to_dict(sanitize) if hasattr(x, "_to_dict") else x,
                    value
                ))
            elif hasattr(value, "_to_dict"):
                result[attr] = value._to_dict(sanitize)
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1]._to_dict(sanitize))
                    if hasattr(item[1], "_to_dict") else item,
                    six.iteritems(value)
                ))
            else:
                if sanitize:
                    if value is not None:
                        result[attr] = value
                else:
                    result[attr] = value
        if issubclass(SnmpUser, dict):
            for key, value in six.iteritems(self):
                result[key] = value

        return result

    def to_dict(self):
        """Returns the model properties as a dict"""
        return self._to_dict(False)

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self._to_dict(True))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SnmpUser):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

