# coding: utf-8


"""
IGNORE:
    Nutanix Clustermgmt Versioned APIs

    Manage Hosts, Clusters and other Infrastructure.  # noqa: E501

    OpenAPI spec version: 4.0.2-alpha-2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_clustermgmt_py_client.Ntnx.clustermgmt.v4.config.BlockItem import BlockItem  # noqa: F401,E501
from ntnx_clustermgmt_py_client.Ntnx.clustermgmt.v4.config.BundleInfo import BundleInfo  # noqa: F401,E501
from ntnx_clustermgmt_py_client.Ntnx.clustermgmt.v4.config.ComputeNodeItem import ComputeNodeItem  # noqa: F401,E501
from ntnx_clustermgmt_py_client.Ntnx.clustermgmt.v4.config.HypervisorIsoMap import HypervisorIsoMap  # noqa: F401,E501
from ntnx_clustermgmt_py_client.Ntnx.clustermgmt.v4.config.NodeItem import NodeItem  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class NodeParam(object):
    """NodeParam - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'block_list': 'list[clustermgmt.v4.config.BlockItem]',
        'node_list': 'list[clustermgmt.v4.config.NodeItem]',
        'compute_node_list': 'list[clustermgmt.v4.config.ComputeNodeItem]',
        'hypervisor_isos': 'list[clustermgmt.v4.config.HypervisorIsoMap]',
        'hyperv_sku': 'str',
        'bundle_info': 'clustermgmt.v4.config.BundleInfo',
        'skip_host_networking': 'bool',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'block_list': 'blockList',
        'node_list': 'nodeList',
        'compute_node_list': 'computeNodeList',
        'hypervisor_isos': 'hypervisorIsos',
        'hyperv_sku': 'hypervSku',
        'bundle_info': 'bundleInfo',
        'skip_host_networking': 'skipHostNetworking',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, block_list=None, node_list=None, compute_node_list=None, hypervisor_isos=None, hyperv_sku=None, bundle_info=None, skip_host_networking=None, *args, **kwargs):  # noqa: E501
        """NodeParam - a model defined in Swagger
            \nParameters of the node to be added
        """
        self.__block_list = None
        self.__node_list = None
        self.__compute_node_list = None
        self.__hypervisor_isos = None
        self.__hyperv_sku = None
        self.__bundle_info = None
        self.__skip_host_networking = None
        self.discriminator = None
        if block_list is not None:
            self.__block_list = block_list
        if node_list is not None:
            self.__node_list = node_list
        if compute_node_list is not None:
            self.__compute_node_list = compute_node_list
        if hypervisor_isos is not None:
            self.__hypervisor_isos = hypervisor_isos
        if hyperv_sku is not None:
            self.__hyperv_sku = hyperv_sku
        if bundle_info is not None:
            self.__bundle_info = bundle_info
        if skip_host_networking is not None:
            self.__skip_host_networking = skip_host_networking
        # populate hidden vars if not empty
        self._populate_hidden_vars(kwargs)

    def _initialize_object_type(self):
        return 'clustermgmt.v4.config.NodeParam'

    def _initialize_fq_object_type(self):
        return 'clustermgmt.v4.r0.a2.config.NodeParam'

    def _populate_hidden_vars(self, kwargs):
        if "_reserved" in kwargs and kwargs["_reserved"] is not None:
            self.__dollar_reserved = kwargs["_reserved"]
        elif "_reserved" in self.attribute_map and self.attribute_map["_reserved"] in kwargs and kwargs[self.attribute_map["_reserved"]] is not None:
            self.__dollar_reserved = kwargs[self.attribute_map["_reserved"]]
        else :
            self.__dollar_reserved = {"$fqObjectType": self._initialize_fq_object_type()}
        if "_unknown_fields" in kwargs and kwargs["_unknown_fields"] is not None:
            self.__dollar_unknown_fields = kwargs["_unknown_fields"]
        elif "_unknown_fields" in self.attribute_map and self.attribute_map["_unknown_fields"] in kwargs and kwargs[self.attribute_map["_unknown_fields"]] is not None:
            self.__dollar_unknown_fields = kwargs[self.attribute_map["_unknown_fields"]]
        else :
            self.__dollar_unknown_fields = {}
        if "_object_type" in kwargs and kwargs["_object_type"] is not None:
            self.__dollar_object_type = kwargs["_object_type"]
        elif "_object_type" in self.attribute_map and self.attribute_map["_object_type"] in kwargs and kwargs[self.attribute_map["_object_type"]] is not None:
            self.__dollar_object_type = kwargs[self.attribute_map["_object_type"]]
        else:
            self.__dollar_object_type = self._initialize_object_type()

    def get_object_type(self):
        return self.__dollar_object_type

    def get_reserved(self):
        return self.__dollar_reserved

    def get_unknown_fields(self):
        return self.__dollar_unknown_fields

    @property
    def block_list(self):
        """`{ list[clustermgmt.v4.config.BlockItem] }`
            \nBlock list of a cluster
        """ # noqa: E501
        return self.__block_list

    @block_list.setter
    def block_list(self, block_list):

        self.__block_list = block_list

    @property
    def node_list(self):
        """`{ list[clustermgmt.v4.config.NodeItem] }`
            \nList of nodes in a cluster
        """ # noqa: E501
        return self.__node_list

    @node_list.setter
    def node_list(self, node_list):

        self.__node_list = node_list

    @property
    def compute_node_list(self):
        """`{ list[clustermgmt.v4.config.ComputeNodeItem] }`
            \nList of compute only nodes
        """ # noqa: E501
        return self.__compute_node_list

    @compute_node_list.setter
    def compute_node_list(self, compute_node_list):

        self.__compute_node_list = compute_node_list

    @property
    def hypervisor_isos(self):
        """`{ list[clustermgmt.v4.config.HypervisorIsoMap] }`
            \nHypervisor type to md5sum map
        """ # noqa: E501
        return self.__hypervisor_isos

    @hypervisor_isos.setter
    def hypervisor_isos(self, hypervisor_isos):

        self.__hypervisor_isos = hypervisor_isos

    @property
    def hyperv_sku(self):
        """`{ str }`
            \nHyperv SKU
        """ # noqa: E501
        return self.__hyperv_sku

    @hyperv_sku.setter
    def hyperv_sku(self, hyperv_sku):

        self.__hyperv_sku = hyperv_sku

    @property
    def bundle_info(self):
        """`{ clustermgmt.v4.config.BundleInfo }`
            
        """ # noqa: E501
        return self.__bundle_info

    @bundle_info.setter
    def bundle_info(self, bundle_info):

        self.__bundle_info = bundle_info

    @property
    def skip_host_networking(self):
        """`{ bool }`
            \nIndicates if the host networking needs to be skipped or not
        """ # noqa: E501
        return self.__skip_host_networking

    @skip_host_networking.setter
    def skip_host_networking(self, skip_host_networking):

        self.__skip_host_networking = skip_host_networking

    @property
    def _reserved(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_reserved

    @property
    def _object_type(self):
        """`{ str }`
            
        """ # noqa: E501
        return self.__dollar_object_type

    @property
    def _unknown_fields(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_unknown_fields

    def _to_dict(self, sanitize):
        """
        Returns the model properties as a dict. Omits None properties based on the provided "sanitize" parameter.
        :param bool sanitize
        """

        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x._to_dict(sanitize) if hasattr(x, "_to_dict") else x,
                    value
                ))
            elif hasattr(value, "_to_dict"):
                result[attr] = value._to_dict(sanitize)
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1]._to_dict(sanitize))
                    if hasattr(item[1], "_to_dict") else item,
                    six.iteritems(value)
                ))
            else:
                if sanitize:
                    if value is not None:
                        result[attr] = value
                else:
                    result[attr] = value
        if issubclass(NodeParam, dict):
            for key, value in six.iteritems(self):
                result[key] = value

        return result

    def to_dict(self):
        """Returns the model properties as a dict"""
        return self._to_dict(False)

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self._to_dict(True))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NodeParam):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

