# Update Memory Bank (UMB)

Update the memory bank with current development context and decisions.

## Usage

```bash
# Command: /umb
```

Updates the following memory bank files:
- `.memory_bank/activeContext.md` - Current session state and focus areas
- `.memory_bank/decisionLog.md` - New technical decisions and architectural choices
- `.memory_bank/progress.md` - Milestone updates and current tasks
- `.memory_bank/productContext.md` - Project overview refinements

## When to Use

- After completing major features or milestones
- When making significant architectural decisions
- At the end of development sessions
- Before switching development focus areas
- After resolving complex technical issues

## What Gets Updated

The memory bank captures:
- **Development Context**: Current focus, active files, session goals
- **Technical Decisions**: API choices, architecture patterns, trade-offs
- **Progress Tracking**: Completed tasks, next priorities, metrics
- **Knowledge Patterns**: Reusable solutions, lessons learned

This enables AI assistants to maintain rich context about the library's development patterns and architectural evolution.