from plone.exportimport import interfaces
from plone.exportimport.importers import principals
from zope.component import getAdapter

import pytest


class TestImporterPrincipals:
    @pytest.fixture(autouse=True)
    def _init(self, portal_multilingual_content):
        self.portal = portal_multilingual_content
        self.importer = principals.PrincipalsImporter(self.portal)

    def test_adapter_is_registered(self):
        adapter = getAdapter(
            self.portal, interfaces.INamedImporter, "plone.importer.principals"
        )
        assert isinstance(adapter, principals.PrincipalsImporter)

    def test_output_is_str(self, multilingual_import_path):
        importer = self.importer
        result = importer.import_data(base_path=multilingual_import_path)
        assert isinstance(result, str)
        assert result == "PrincipalsImporter: Imported 2 groups and 1 members"

    def test_empty_import_path(self, empty_import_path):
        importer = self.importer
        result = importer.import_data(base_path=empty_import_path)
        assert isinstance(result, str)
        assert result == "PrincipalsImporter: No data to import"

    def test_invalid_import_path(self, invalid_import_path):
        importer = self.importer
        result = importer.import_data(base_path=invalid_import_path)
        assert isinstance(result, str)
        assert result == "PrincipalsImporter: Import path does not exist"

    def test_pricinpals_import_path(self, principals_import_path):
        importer = self.importer
        result = importer.import_data(base_path=principals_import_path)
        assert isinstance(result, str)
        assert result == "PrincipalsImporter: Imported 2 groups and 1 members"
