# Source: https://github.com/Changaco/version.py

from os.path import dirname, isdir, join
from os import environ
import re
from subprocess import CalledProcessError, check_output


PREFIX = 'v'

tag_re = re.compile(r'\btag: %s([0-9][^,]*)\b' % PREFIX)
version_re = re.compile('^Version: (.+)$', re.M)


def get_version():
    return "0.2.1"
    # Return the version if it has been injected into the file by git-archive
    version = tag_re.search('$Format:%D$')
    if version:
        return version.group(1)
    
    branch = None

    d = dirname(__file__)

    if isdir(join(d, '.git')):
        # Get the version using "git describe".
        cmd_ver = 'git describe --tags --match %s[0-9]* --dirty' % PREFIX
        cmd_branch = 'git rev-parse --abbrev-ref HEAD'
        try:
            version = check_output(cmd_ver.split()).decode().strip()[len(PREFIX):]
            branch = check_output(cmd_branch.split()).decode().strip()
        except CalledProcessError:
            raise RuntimeError('Unable to get version number from git tags')

        # PEP 440 compatibility
        # if '-' in version:
        #     if version.endswith('-dirty') and not 'IGNORE_DIRTY' in environ:
        #         raise RuntimeError('The working tree is dirty')
#            version = '.post'.join(version.split('-')[:2])

        if branch and branch != "master":
            version = "{0}.{1}".format(version, branch)
    else:
        # Extract the version from the PKG-INFO file.
        with open(join(d, 'PKG-INFO')) as f:
            version = version_re.search(f.read()).group(1)

    return version


if __name__ == '__main__':
    print(get_version())
