#!/usr/bin/env python3
# @generated AUTOGENERATED file. Do not Change!

from dataclasses import dataclass, field as _field
from ...config import custom_scalars, datetime
from gql_client.runtime.variables import encode_variables
from gql import gql, Client
from gql.transport.exceptions import TransportQueryError
from functools import partial
from numbers import Number
from typing import Any, AsyncGenerator, Dict, List, Generator, Optional
from time import perf_counter
from dataclasses_json import DataClassJsonMixin, config

from ..input.resource_specification_items_filter_input import ResourceSpecificationItemsFilterInput


# fmt: off
QUERY: List[str] = ["""
query resourceSpecificationItems(
  $after: Cursor
  $first: Int
  $before: Cursor
  $last: Int
  $filterBy: [ResourceSpecificationItemsFilterInput!]
) {
  resourceSpecificationItems(
    after: $after
    first: $first
    before: $before
    last: $last
    filterBy: $filterBy
  ) {
    totalCount
    edges {
      node {
        id
        resourceSpecificationRelationship{
          id
          name
        }
        resourceSpecification{
          id
          name
        }
      }
      cursor
    }
    pageInfo {
      hasNextPage
      hasPreviousPage
      startCursor
      endCursor
    }
  }
}
"""
]


class resourceSpecificationItems:
    @dataclass(frozen=True)
    class resourceSpecificationItemsData(DataClassJsonMixin):
        @dataclass(frozen=True)
        class ResourceSpecificationItemsConnection(DataClassJsonMixin):
            @dataclass(frozen=True)
            class ResourceSpecificationItemsEdge(DataClassJsonMixin):
                @dataclass(frozen=True)
                class ResourceSpecificationItems(DataClassJsonMixin):
                    @dataclass(frozen=True)
                    class ResourceSpecificationRelationship(DataClassJsonMixin):
                        id: str
                        name: str

                    @dataclass(frozen=True)
                    class ResourceSpecification(DataClassJsonMixin):
                        id: str
                        name: str

                    id: str
                    resourceSpecificationRelationship: ResourceSpecificationRelationship
                    resourceSpecification: Optional[ResourceSpecification]

                node: Optional[ResourceSpecificationItems]
                cursor: str

            @dataclass(frozen=True)
            class PageInfo(DataClassJsonMixin):
                hasNextPage: bool
                hasPreviousPage: bool
                startCursor: Optional[str]
                endCursor: Optional[str]

            totalCount: int
            edges: List[ResourceSpecificationItemsEdge]
            pageInfo: PageInfo

        resourceSpecificationItems: ResourceSpecificationItemsConnection

    # fmt: off
    @classmethod
    def execute(cls, client: Client, after: Optional[str] = None, first: Optional[int] = None, before: Optional[str] = None, last: Optional[int] = None, filterBy: List[ResourceSpecificationItemsFilterInput] = []) -> resourceSpecificationItemsData.ResourceSpecificationItemsConnection:
        variables: Dict[str, Any] = {"after": after, "first": first, "before": before, "last": last, "filterBy": filterBy}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = client.execute(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.resourceSpecificationItemsData.from_dict(response_text)
        return res.resourceSpecificationItems

    # fmt: off
    @classmethod
    async def execute_async(cls, client: Client, after: Optional[str] = None, first: Optional[int] = None, before: Optional[str] = None, last: Optional[int] = None, filterBy: List[ResourceSpecificationItemsFilterInput] = []) -> resourceSpecificationItemsData.ResourceSpecificationItemsConnection:
        variables: Dict[str, Any] = {"after": after, "first": first, "before": before, "last": last, "filterBy": filterBy}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = await client.execute_async(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.resourceSpecificationItemsData.from_dict(response_text)
        return res.resourceSpecificationItems
