#!/usr/bin/env python3
# @generated AUTOGENERATED file. Do not Change!

from dataclasses import dataclass, field as _field
from ...config import custom_scalars, datetime
from gql_client.runtime.variables import encode_variables
from gql import gql, Client
from gql.transport.exceptions import TransportQueryError
from functools import partial
from numbers import Number
from typing import Any, AsyncGenerator, Dict, List, Generator, Optional
from time import perf_counter
from dataclasses_json import DataClassJsonMixin, config

from ..fragment.project_type import ProjectTypeFragment, QUERY as ProjectTypeFragmentQuery


# fmt: off
QUERY: List[str] = ProjectTypeFragmentQuery + ["""
query ProjectTypesQuery {
  projectTypes {
    edges {
      node {
        ...ProjectTypeFragment
      }
    }
  }
}
"""
]


class ProjectTypesQuery:
    @dataclass(frozen=True)
    class ProjectTypesQueryData(DataClassJsonMixin):
        @dataclass(frozen=True)
        class ProjectTypeConnection(DataClassJsonMixin):
            @dataclass(frozen=True)
            class ProjectTypeEdge(DataClassJsonMixin):
                @dataclass(frozen=True)
                class ProjectType(ProjectTypeFragment):
                    pass

                node: Optional[ProjectType]

            edges: List[ProjectTypeEdge]

        projectTypes: Optional[ProjectTypeConnection]

    # fmt: off
    @classmethod
    def execute(cls, client: Client) -> Optional[ProjectTypesQueryData.ProjectTypeConnection]:
        variables: Dict[str, Any] = {}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = client.execute(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.ProjectTypesQueryData.from_dict(response_text)
        return res.projectTypes

    # fmt: off
    @classmethod
    async def execute_async(cls, client: Client) -> Optional[ProjectTypesQueryData.ProjectTypeConnection]:
        variables: Dict[str, Any] = {}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = await client.execute_async(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.ProjectTypesQueryData.from_dict(response_text)
        return res.projectTypes
