// Copyright (c) Mito
import React from 'react';
import UndoIcon from '../icons/UndoIcon';
import ImportIcon from '../icons/ImportIcon';
import ExportIcon from '../icons/ExportIcon';
import PivotIcon from '../icons/PivotIcon';
import DeleteColumnIcon from '../icons/DeleteColumnIcon';
import AddColumnIcon from '../icons/AddColumnIcon';
import { CloseFullscreenIcon, OpenFullscreenIcon } from '../icons/FullscreenIcons';
import StepsIcon from '../icons/StepsIcon';
import CatchUpIcon from '../icons/CatchUpIcon';
import GraphIcon from '../icons/GraphIcon';
import RedoIcon from '../icons/RedoIcon';
import ClearIcon from '../icons/ClearIcon';
import FormatIcon from '../icons/FormatIcon';
import DtypeIcon from '../icons/DtypeIcon';
import DropdownItem from '../elements/DropdownItem';
/*
    Each button in the toolbar is one of the ToolbarButtonType.
    We use the ToolbarButtonType to get the correct icons for each button.

    In the future, we will also use this type to do things like having one function
    that can be used to specify any toolbar item to have attention drawn to. ie:
    through the tour.
*/
export var ToolbarButtonType;
(function (ToolbarButtonType) {
    ToolbarButtonType["UNDO"] = "UNDO";
    ToolbarButtonType["REDO"] = "REDO";
    ToolbarButtonType["CLEAR"] = "CLEAR";
    ToolbarButtonType["IMPORT"] = "IMPORT";
    ToolbarButtonType["EXPORT"] = "EXPORT";
    ToolbarButtonType["ADD_COL"] = "ADD COL";
    ToolbarButtonType["DEL_COL"] = "DEL COL";
    ToolbarButtonType["DTYPE"] = "DTYPE";
    ToolbarButtonType["FORMAT"] = "FORMAT";
    ToolbarButtonType["PIVOT"] = "PIVOT";
    ToolbarButtonType["GRAPH"] = "GRAPH";
    ToolbarButtonType["CATCH_UP"] = "CATCH UP";
    ToolbarButtonType["STEPS"] = "STEPS";
    ToolbarButtonType["OPEN_FULLSCREEN"] = "OPEN FULLSCREEN";
    ToolbarButtonType["CLOSE_FULLSCREEN"] = "CLOSE FULLSCREEN";
})(ToolbarButtonType || (ToolbarButtonType = {}));
/*
    Helper function for getting the light and dark version of each
    toolbar icon.
*/
export const getToolbarItemIcon = (toolbarButtonType) => {
    switch (toolbarButtonType) {
        case ToolbarButtonType.UNDO: {
            return React.createElement(UndoIcon, null);
        }
        case ToolbarButtonType.REDO: {
            return React.createElement(RedoIcon, null);
        }
        case ToolbarButtonType.CLEAR: {
            return React.createElement(ClearIcon, null);
        }
        case ToolbarButtonType.IMPORT: {
            return React.createElement(ImportIcon, null);
        }
        case ToolbarButtonType.EXPORT: {
            return React.createElement(ExportIcon, null);
        }
        case ToolbarButtonType.ADD_COL: {
            return React.createElement(AddColumnIcon, null);
        }
        case ToolbarButtonType.DEL_COL: {
            return React.createElement(DeleteColumnIcon, null);
        }
        case ToolbarButtonType.DTYPE: {
            return React.createElement(DtypeIcon, null);
        }
        case ToolbarButtonType.FORMAT: {
            return React.createElement(FormatIcon, null);
        }
        case ToolbarButtonType.PIVOT: {
            return React.createElement(PivotIcon, null);
        }
        case ToolbarButtonType.GRAPH: {
            return React.createElement(GraphIcon, null);
        }
        case ToolbarButtonType.CATCH_UP: {
            return React.createElement(CatchUpIcon, null);
        }
        case ToolbarButtonType.STEPS: {
            return React.createElement(StepsIcon, null);
        }
        case ToolbarButtonType.OPEN_FULLSCREEN: {
            return React.createElement(OpenFullscreenIcon, null);
        }
        case ToolbarButtonType.CLOSE_FULLSCREEN: {
            return React.createElement(CloseFullscreenIcon, null);
        }
    }
};
/**
 * A helper function that makes dropdown items for the toolbar menus. This is
 * a function and not a component itself because the dropdown _expects_ to get
 * a DropdownItem as it's child, so we cannot wrap this in another component
 */
export const makeToolbarDropdownItem = (action, supressFocusSettingOnClose) => {
    var _a, _b;
    return (React.createElement(DropdownItem, { title: action.longTitle, onClick: action.actionFunction, disabled: action.isDisabled() !== undefined, tooltip: action.isDisabled(), rightText: window.navigator.userAgent.toUpperCase().includes('MAC')
            ? (_a = action.displayKeyboardShortcuts) === null || _a === void 0 ? void 0 : _a.mac
            : (_b = action.displayKeyboardShortcuts) === null || _b === void 0 ? void 0 : _b.windows, supressFocusSettingOnClose: supressFocusSettingOnClose }));
};
//# sourceMappingURL=utils.js.map