import React from 'react';
import { classNames } from '../../utils/classNames';
import { TaskpaneType } from '../taskpanes/taskpanes';
// The component in the toolbar that either tells you are pro or asks you to upgrade
const PlanButton = (props) => {
    return (React.createElement("div", { className: classNames('text-button', 'text-button-variant-dark', 'plan-button'), onClick: () => {
            if (!props.userProfile.isPro) {
                void props.mitoAPI.log('clicked_plan_button');
            }
            props.setUIState(prevUIState => {
                return Object.assign(Object.assign({}, prevUIState), { currOpenTaskpane: { type: TaskpaneType.UPGRADE_TO_PRO }, selectedTabType: 'data' });
            });
        } }, props.userProfile.isPro ? "Mito Pro" : "Upgrade to Mito Pro"));
};
export default PlanButton;
//# sourceMappingURL=PlanButton.js.map